/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.progeeks.util.log.Log;
import org.progeeks.util.log.LogLevel;
import org.progeeks.util.xml.TagReader;
import org.progeeks.util.xml.XmlException;
import org.progeeks.util.xml.XmlReader;
import org.xml.sax.Attributes;

public class XmlSignatureReader
extends XmlReader {
    static Log log = Log.getLog(XmlSignatureReader.class);
    static Log xmlReaderLog = Log.getLog(XmlReader.class);
    private int currentDepth = 0;
    private int maxDepth = 0;
    private List<String> stack = new ArrayList<String>();
    private RuntimeException earlyOut = new RuntimeException("Stack depth reached, aborting read.");

    public XmlSignatureReader() {
        this.setDefaultHandler(new DefaultTagReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSignature(int depth, String separator, Reader in) {
        this.currentDepth = 0;
        this.maxDepth = depth;
        this.stack.clear();
        LogLevel oldLevel = xmlReaderLog.getLogLevel();
        xmlReaderLog.setLogLevel(LogLevel.OFF);
        try {
            this.readXml(in);
        }
        catch (XmlException e) {
            Throwable realException = e.getCause();
            while (realException instanceof XmlException) {
                realException = realException.getCause();
            }
            if (realException != this.earlyOut) {
                throw new RuntimeException("Error reading XML signature", e);
            }
        }
        catch (Exception e) {
            if (e != this.earlyOut) {
                throw new RuntimeException("Error reading XML", e);
            }
        }
        finally {
            xmlReaderLog.setLogLevel(oldLevel);
        }
        StringBuffer result = new StringBuffer();
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(this.stack.get(i));
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        XmlSignatureReader reader = new XmlSignatureReader();
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            try {
                System.out.println("Reading:" + f);
                BufferedReader in = new BufferedReader(new FileReader(f));
                String signature = reader.getSignature(1, ",", in);
                System.out.println("  singature:" + signature);
                continue;
            }
            catch (Exception e) {
                log.error("Error getting file signature for:" + f, e);
            }
        }
    }

    private class DefaultTagReader
    extends TagReader {
        private DefaultTagReader() {
        }

        public Object tagStart(String tag, Attributes atts, Object parent) throws XmlException {
            if (tag.startsWith("xml.")) {
                return tag;
            }
            XmlSignatureReader.this.stack.add(0, tag);
            XmlSignatureReader.this.currentDepth++;
            if (XmlSignatureReader.this.currentDepth >= XmlSignatureReader.this.maxDepth) {
                throw XmlSignatureReader.this.earlyOut;
            }
            return tag;
        }

        public void tagEnd(String tag, String text, Object parent, Object tagObject) throws XmlException {
            if (tag.startsWith("xml.")) {
                return;
            }
            XmlSignatureReader.this.currentDepth--;
            XmlSignatureReader.this.stack.remove(0);
        }
    }
}

