/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import org.progeeks.tool.console.ArgumentList;
import org.progeeks.tool.console.CharStream;

public class ArgumentParser {
    private boolean stripQuotes = true;

    public void setStripQuotes(boolean b) {
        this.stripQuotes = b;
    }

    public boolean getStripQuotes() {
        return this.stripQuotes;
    }

    protected RuntimeException error(CharStream stream, String message) {
        return this.error(stream, message, null);
    }

    protected RuntimeException error(CharStream stream, String message, Throwable cause) {
        String s = stream.createErrorMessage(message);
        return new RuntimeException(s, cause);
    }

    protected boolean isGroupStart(int c) {
        return c == 91 || c == 40;
    }

    protected boolean isGroupEnd(int c) {
        return c == 93 || c == 41;
    }

    protected int getGroupEnd(int c) {
        switch (c) {
            case 91: {
                return 93;
            }
            case 40: {
                return 41;
            }
        }
        return -1;
    }

    protected boolean isSingleLineQuote(int c) {
        return c == 34 || c == 39;
    }

    protected boolean isSeparator(int c) {
        return c == 44 || this.isWhitespace(c);
    }

    protected boolean isWhitespace(int c) {
        return c == 32 || c == 9;
    }

    public ParsedArguments parse(String argumentString) {
        CharStream stream = new CharStream(argumentString);
        Object parsed = this.parseArgument(stream);
        CharSequence r = stream.getRemaining();
        String suffix = r == null ? null : ((Object)r).toString();
        ArgumentList args = parsed instanceof ArgumentList ? (ArgumentList)parsed : new ArgumentList(String.valueOf(parsed), '(', ')');
        return new ParsedArguments(args, suffix);
    }

    protected Object parseArgument(CharStream stream) {
        int c;
        int start = stream.getPosition();
        while ((c = stream.read()) >= 0) {
            if (this.isGroupEnd(c) || this.isWhitespace(c) || this.isSeparator(c)) {
                stream.pushBack();
                break;
            }
            if (!this.isGroupStart(c)) continue;
        }
        if (this.isGroupStart(c)) {
            String name = null;
            if (stream.getPosition() - 1 > start) {
                name = stream.substring(start, -1);
            }
            return this.parseGroup(stream, name, c);
        }
        if (stream.getPosition() > start) {
            return stream.substring(start);
        }
        return null;
    }

    protected Object parseSingleLineQuote(CharStream stream, int quoteStart) {
        int c;
        int start = stream.getPosition();
        if (!this.stripQuotes) {
            --start;
        }
        while ((c = stream.read()) >= 0) {
            if (c == 10) {
                throw this.error(stream, "No closing '" + (char)quoteStart + "' before line ending.");
            }
            if (c != quoteStart) continue;
            if (this.stripQuotes) {
                return stream.substring(start, -1);
            }
            return stream.substring(start);
        }
        throw this.error(stream, "No closing '" + (char)quoteStart + "' before end of input.");
    }

    protected ArgumentList parseGroup(CharStream stream, String name, int groupStart) {
        int c;
        int separator = 0;
        int foundSeparator = 0;
        int start = stream.getPosition();
        int end = this.getGroupEnd(groupStart);
        if (end < 0) {
            throw this.error(stream, "No matching group character configured for '" + (char)groupStart + "'");
        }
        ArgumentList results = new ArgumentList(name, (char)groupStart, (char)end);
        while ((c = stream.read()) >= 0) {
            Object arg;
            if (this.isGroupEnd(c)) {
                if (c != end) {
                    throw this.error(stream, "Expected '" + (char)end + "' but found '" + (char)c + "'");
                }
                if (foundSeparator != 0) {
                    results.add(null);
                }
                return results;
            }
            if (this.isWhitespace(c)) {
                start = stream.getPosition();
                continue;
            }
            if (this.isSeparator(c)) {
                if (separator != 0 && c != separator) {
                    throw this.error(stream, "Found argument separator '" + (char)c + "' but expected '" + (char)separator + "'");
                }
                if (separator == 0) {
                    separator = c;
                }
                if (foundSeparator != 0) {
                    results.add(null);
                }
                foundSeparator = c;
                continue;
            }
            if (results.size() > 0) {
                if (foundSeparator == 0 && separator != 0 && separator != 32) {
                    throw this.error(stream, "Inconsistent argument separator ' ' found instead of '" + (char)separator + "'");
                }
                if (foundSeparator == 0) {
                    separator = 32;
                }
            }
            foundSeparator = 0;
            if (this.isSingleLineQuote(c)) {
                arg = this.parseSingleLineQuote(stream, c);
                results.add(arg);
                continue;
            }
            stream.pushBack();
            arg = this.parseArgument(stream);
            results.add(arg);
        }
        throw this.error(stream, "Missing '" + (char)end + "'");
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser p = new ArgumentParser();
        p.setStripQuotes(false);
        for (String s : args) {
            System.out.println("Parsing:" + args[0]);
            ParsedArguments parsed = p.parse(args[0]);
            System.out.println("Result:" + parsed);
            System.out.println("Tree:\n" + parsed.getArgumentList().appendTree("  ", null));
        }
    }

    public static class ParsedArguments {
        private ArgumentList args;
        private String remaining;

        public ParsedArguments(ArgumentList args, String remaining) {
            this.args = args;
            this.remaining = remaining;
        }

        public ArgumentList getArgumentList() {
            return this.args;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String toString() {
            return this.args + (this.remaining != null ? this.remaining : "");
        }
    }
}

