/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadJarsCommand
extends AbstractShellCommand {
    private static final String[] HELP = new String[]{"Usage: loadJars <jar files> | <jar directory>", "Where:", "  jar files - is a list of individual jars files to", "              load separated by the platform path", "              separator.", "  jar directory - is a directory from which all jars files", "              will be loaded.", "", "  These options can be used in any combination, but all", "  path components must be separated by the platform path", "  separator (for example: ';' on windows and ':' on Unix)"};

    public LoadJarsCommand() {
        super("Loads specified jars making the contained classes available to commands.", HELP);
    }

    protected void addDirectory(List<URL> jars, File dir) throws IOException {
        File[] sub;
        for (File f : sub = dir.listFiles()) {
            if (f.isDirectory() || !f.getName().toLowerCase().endsWith(".jar")) continue;
            this.addFile(jars, f);
        }
    }

    protected void addFile(List<URL> jars, File f) throws IOException {
        System.out.println("Adding jar:" + f);
        jars.add(f.toURL());
    }

    @Override
    public int execute(ShellEnvironment sEnv, String args) {
        ArrayList<URL> jars = new ArrayList<URL>();
        try {
            String[] paths;
            for (String s : paths = args.split(File.pathSeparator)) {
                if (s.length() == 0) continue;
                File f = new File(s);
                if (!f.exists()) {
                    System.out.println(f + " does not exist.");
                    return -1;
                }
                if (f.isDirectory()) {
                    this.addDirectory(jars, f);
                    continue;
                }
                this.addFile(jars, f);
            }
        }
        catch (IOException e) {
            System.out.println("Error accessing file list -> " + e);
            return -1;
        }
        if (jars.size() == 0) {
            return 0;
        }
        Thread t = Thread.currentThread();
        URL[] urls = jars.toArray(new URL[jars.size()]);
        URLClassLoader newClassLoader = new URLClassLoader(urls, t.getContextClassLoader());
        t.setContextClassLoader(newClassLoader);
        return 0;
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

