/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import java.util.Iterator;
import java.util.TreeSet;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;
import org.progeeks.util.log.Log;
import org.progeeks.util.log.LogLevel;

public class LogLevelCommand
extends AbstractShellCommand {
    private static final String[] HELP = new String[]{"Usage: loglevel [category [=level]]", "Where:", "   category - the category to set or view the log", "              log level.  For viewing, all categories with", "              the category prefix will be displayed.", "   level    - the level to set to the specified", "              category.", "   no args will cause the command to dump all of the", "   current categories and their log levels.", "", "   When displaying log levels, a level value surrouned in ()s", "   means that the level is inherited.  A value without ()s means", "   that the level is set directly on that category."};

    public LogLevelCommand() {
        super("Allows viewing or setting log levels.", HELP);
    }

    protected void showLevel(String prefix) {
        TreeSet sorted = new TreeSet();
        Iterator i = Log.categoryNames();
        while (i.hasNext()) {
            sorted.add(i.next());
        }
        for (String name : sorted) {
            if (prefix.length() != 0 && !name.startsWith(prefix)) continue;
            Log l = Log.getLog((String)name);
            System.out.print(name + " = ");
            LogLevel level = l.getLogLevel();
            if (level == null) {
                System.out.println("(" + l.getEffectiveLogLevel() + ")");
                continue;
            }
            System.out.println(level);
        }
    }

    protected int setLevel(String name, String level) {
        LogLevel ll = LogLevel.toLevel((String)level);
        if (!ll.toString().equals(level)) {
            System.out.println("Unknown log level:" + level);
            return -1;
        }
        Log l = Log.getLog((String)name);
        l.setLogLevel(ll);
        return 0;
    }

    public int execute(ShellEnvironment sEnv, String args) {
        int split = args.indexOf("=");
        if (split >= 0) {
            String name = args.substring(0, split).trim();
            String level = args.substring(split + 1).trim();
            return this.setLevel(name, level);
        }
        this.showLevel(args);
        return 0;
    }

    public boolean isSimple() {
        return true;
    }
}

