/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.LinearInterpolator;
import de.lessvoid.nifty.tools.SizeValue;

public class ImageSize
implements EffectImpl {
    private float startSize;
    private float endSize;
    private SizeValue imageSize = new SizeValue("100%");
    private LinearInterpolator interpolator;

    @Override
    public final void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startSize = Float.parseFloat(parameter.getProperty("startSize", "1.0"));
        this.endSize = Float.parseFloat(parameter.getProperty("endSize", "2.0"));
        String maxSizeString = parameter.getProperty("maxSize");
        if (maxSizeString != null) {
            this.imageSize = new SizeValue(maxSizeString);
        }
        this.interpolator = parameter.getInterpolator();
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        float scale = 1.0f;
        if (falloff == null) {
            float t = normalizedTime;
            scale = this.interpolator != null ? this.interpolator.getValue(t) : this.startSize + t * (this.endSize - this.startSize);
        } else {
            scale = 1.0f + falloff.getFalloffValue() * this.imageSize.getValue(1.0f);
        }
        r.setImageScale(scale);
    }

    @Override
    public void deactivate() {
    }
}

