/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image.areaprovider;

import de.lessvoid.nifty.Size;
import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.image.areaprovider.AreaProvider;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.logging.Logger;

public class SpriteAreaProvider
implements AreaProvider {
    private static Logger log = Logger.getLogger(SpriteAreaProvider.class.getName());
    private static final int SPRITE_ARGS_COUNT = 3;
    private int m_index;
    private int m_width;
    private int m_height;

    @Override
    public void setParameters(String parameters) {
        String[] args = this.getArguments(parameters);
        this.m_width = Integer.valueOf(args[0]);
        this.m_height = Integer.valueOf(args[1]);
        this.m_index = Integer.valueOf(args[2]);
    }

    private String[] getArguments(String parameters) {
        String[] args = null;
        if (parameters != null) {
            args = parameters.split(",");
        }
        if (args == null || args.length != 3) {
            int argCount = args == null ? 0 : args.length;
            throw new IllegalArgumentException("Trying to parse [" + this.getClass().getName() + "] : wrong parameter count (" + argCount + "). Expected [width,height,spriteIndex], found [" + parameters + "].");
        }
        return args;
    }

    @Override
    public Box getSourceArea(RenderImage renderImage) {
        int imageWidth = renderImage.getWidth();
        int imageHeight = renderImage.getHeight();
        int spriteCountPerLine = imageWidth / this.m_width;
        int spriteX = this.m_index % spriteCountPerLine;
        int spriteY = this.m_index / spriteCountPerLine;
        int imageX = spriteX * this.m_width;
        int imageY = spriteY * this.m_height;
        if (imageX + this.m_width > imageWidth || imageY + this.m_height > imageHeight) {
            log.warning("Sprite's area exceeds image's bounds.");
        }
        return new Box(imageX, imageY, this.m_width, this.m_height);
    }

    @Override
    public Size getNativeSize(NiftyImage image) {
        return new Size(this.m_width, this.m_height);
    }
}

