/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.util.ArrayList;
import java.util.List;

public class Split {
    private static final String BEGIN_KEY = "${";
    private static final String END_KEY = "}";

    public static List<String> split(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        String remaining = value;
        int startIdx = 0;
        while ((remaining = remaining.substring(startIdx)).length() != 0) {
            boolean parsingKey = remaining.startsWith(BEGIN_KEY);
            int endIdx = Split.findEndIdx(remaining, parsingKey);
            if (endIdx == -1) {
                result.add(remaining);
                break;
            }
            if (parsingKey) {
                result.add(remaining.substring(0, endIdx + 1));
                startIdx = endIdx + 1;
                continue;
            }
            result.add(remaining.substring(0, endIdx));
            startIdx = endIdx;
        }
        return result;
    }

    public static String join(List<String> parts) {
        StringBuffer result = new StringBuffer();
        for (String part : parts) {
            result.append(part);
        }
        return result.toString();
    }

    private static int findEndIdx(String remaining, boolean parsingKey) {
        if (parsingKey) {
            return remaining.indexOf(END_KEY);
        }
        return remaining.indexOf(BEGIN_KEY);
    }
}

