uniform mat4 g_WorldViewProjectionMatrix;
uniform float g_Time;

uniform sampler2D m_NoiseMap;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec4 inTexCoord;

varying vec4 color;

#ifdef USE_TEXTURE
varying vec4 texCoord;
#endif

#ifdef POINT_SPRITE
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;
uniform float m_Quadratic;
const float SIZE_MULTIPLIER = 4.0;
attribute float inSize;
#endif

uniform float m_Alpha;

// The same wind noise that grass uses for now
// ... with some tweaks
float simpleNoise( float x, float y, float z )
{
    // We'll cheat and just adjust x by a little bit of
    // z and y by a lot bit of z and use them as a texture look-up.
    //x += z * 0.1;
    //y += z;
    //x = mod(x, 64.0) / 64.0;
    //y = mod(y, 64.0) / 64.0;
    //z = z / 64.0;
    x += z; // * 0.001;
    y += z * 0.1;
    x = mod(x * 0.05, 1.0);
    y = mod(y * 0.05, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x,y) ).r - 0.5;
}

float simpleNoise( float x, float y, float z, float time )
{
    // Move x,y to be in a nicer range
    x = x * 0.3;
    z = z * 0.3;
    
    x = mod(x, 1.0);
    z = mod(z, 1.0);
    
    return texture2D( m_NoiseMap, vec2(x + time, z + y) ).r;
}

void main(){
    vec4 pos = vec4(inPosition, 1.0);

    gl_Position = g_WorldViewProjectionMatrix * pos;
    color = inColor;

    #ifdef USE_TEXTURE
        texCoord = inTexCoord;
    #endif

    #ifdef POINT_SPRITE
        vec4 worldPos = g_WorldMatrix * pos;
        //vec4 scalePos = g_WorldMatrix * (pos + vec4(0.0, 1.0, 0.0, 1.0));

        //float scale = distance(scalePos.xyz, worldPos.xyz);
        float scale = length( g_WorldMatrix[0].xyz );
         
        
        float y = pos.y - floor(pos.y);
        float yNorm = y - 0.25;
        //gl_Position.x += y;

        // Calculate some wind offsets
        float windNoise = simpleNoise( pos.x, pos.z, g_Time * 0.5 );
        float windStrength = 1.0;
        vec2 windDirection = vec2(1.0, 0.0); 
 
        float xWind = (windStrength * windNoise * windDirection.x) * yNorm * 0.5;
        float zWind = (windStrength * windNoise * windDirection.y) * yNorm * 0.5;

        gl_Position.x += xWind * scale;
        gl_Position.z += zWind * scale;

        // Calculate the point size and flame offsets
        float d = distance(g_CameraPosition.xyz, worldPos.xyz);
 
        //gl_Position.x += cos((g_Time + y * 2) * 8) * y * 0.1 * scale;
                
        //gl_Position.x += cos((g_Time + y * 2) * 8) * 0.01 * scale;        
        //gl_Position.x += cos((g_Time + y)) * y * 0.01 * scale;        
 
        //float offset = texture2D( m_NoiseMap, vec2(pos.x + g_Time * 0.1, pos.z + y) ).r; 
        float yOffset = simpleNoise( pos.x, y, pos.z, g_Time * 0.2 ); 
        gl_Position.y += yOffset * scale * 0.2 * y;
 
        float base = texture2D( m_NoiseMap, vec2(pos.x, pos.z) ).r;
        float bias = cos( base + g_Time );
 
        float xOffset = simpleNoise( pos.z, y, pos.x, g_Time * 0.1 ) - 0.5;
        gl_Position.x += xOffset * scale * 0.2 * (1.0 - y) * bias;
               
        //vec4 scale = g_WorldMatrix * vec4(1.0, 0.0, 0.0, 1.0);
        
        //gl_PointSize = (inSize * SIZE_MULTIPLIER * m_Quadratic) / d;
        gl_PointSize = max(1.0, ((inSize * SIZE_MULTIPLIER * m_Quadratic) / d) * scale );
        //gl_PointSize = scale;
        //gl_PointSize = max(1.0, ((inSize * SIZE_MULTIPLIER * m_Quadratic * scale) / d) );
        //gl_PointSize = max(1.0, ((inSize * scale) / d) );

        //vec4 worldViewPos = g_WorldViewMatrix * pos;
        //gl_PointSize = (inSize * SIZE_MULTIPLIER * m_Quadratic)*100.0 / worldViewPos.z;

        //color.a *= min(1.0, gl_PointSize) * m_Alpha;
        //color.b = 1;
        //color = mix( color, vec4(0.9,1.0,0.4,1.0), gl_Position.z * 1.0 / 32.0 );  
        //color = mix( color, vec4(0.9,1.0,0.4,1.0), gl_Position.z * 1.0 / 16.0 );  
        color = mix( color, vec4(0.9,1.4,0.6,1.0), min(1.0, gl_Position.z * 1.0 / 24.0) );  
        color.a *= min(gl_PointSize, 1.0) * m_Alpha;
 
        //color.r = 0.0;
        //color.g = 0.0;       
        //color.b = min(1.0, gl_Position.z * 1.0 / 32.0);
        //color.rgb = mix( color.rgb
        //color.a = 1.0;
    #endif
}


