uniform vec4 m_Color;
uniform float g_Time;

#if defined(HAS_GLOWMAP) || defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPARATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

#ifdef HAS_COLORMAP
    uniform sampler2D m_ColorMap;
#endif

#ifdef NEED_TEXCOORD1
    varying vec2 texCoord1;
#endif

#ifdef HAS_LIGHTMAP
    uniform sampler2D m_LightMap;
    #ifdef SEPARATE_TEXCOORD
        varying vec2 texCoord2;
    #endif
#endif

#ifdef HAS_VERTEXCOLOR
    varying vec4 vertColor;
#endif

void main(){
    vec4 color = vec4(1.0);

    float alphaCurve = 1.0 - abs(texCoord1.y);
    float curve = abs(texCoord1.y);
    curve = curve * curve;
    alphaCurve = alphaCurve * alphaCurve;// * alphaCurve; 

    #ifdef HAS_COLORMAP
        vec2 tc = texCoord1;
        tc.x *= 5.0;
        tc.y = curve; //abs(tc.y);
        tc.y -= mod(g_Time * 0.25, 1.0);
        
        float c = 0.5 + texture2D(m_ColorMap, tc).r * 0.5;
        c = clamp( c, 0.5, 1.0 ); 
        color *= c; 
        //color.a = max(0.1, color.r);
    #endif

    #ifdef HAS_VERTEXCOLOR
        color *= vertColor;
    #endif

    #ifdef HAS_COLOR
        color *= m_Color;
    #endif

    #ifdef HAS_LIGHTMAP
        #ifdef SEPARATE_TEXCOORD
            color.rgb *= texture2D(m_LightMap, texCoord2).rgb;
        #else
            color.rgb *= texture2D(m_LightMap, texCoord1).rgb;
        #endif
    #endif

    gl_FragColor = mix( color, m_Color, alphaCurve );
    float a = alphaCurve * color.a;
    //if( a < 0.1 )
    //    discard;
             
    gl_FragColor.a = a; 
    //gl_FragColor.r = gl_FragColor.a;
    //gl_FragColor.g = gl_FragColor.a;
    //gl_FragColor.b = gl_FragColor.a;
}
