uniform sampler2D m_Texture;
uniform sampler2D m_DepthTexture;
varying vec2 texCoord;

uniform vec4 m_Radial;
uniform vec4 m_FadeColor;

void main() {

    vec4 texVal = texture2D( m_Texture, texCoord );
 
    float x = (texCoord.x - 0.5) * m_Radial.z;   
    float y = (texCoord.y - 0.5) * m_Radial.w;
    float fade = clamp(x * x + y * y, 0.0, 1.0) * m_FadeColor.a;
    gl_FragColor = mix( texVal, m_FadeColor, fade );
}
