/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.button;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ButtonControl
extends AbstractController
implements Button {
    private Nifty nifty;
    private Screen screen;
    private FocusHandler focusHandler;
    private Element buttonTextElement;
    private TextRenderer buttonTextRenderer;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(newElement);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.buttonTextElement = this.getElement().findElementByName("#text");
        this.buttonTextRenderer = (TextRenderer)this.buttonTextElement.getRenderer(TextRenderer.class);
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        EventTopicSubscriber<NiftyMousePrimaryClickedEvent> mouseClickedSubscriber = new EventTopicSubscriber<NiftyMousePrimaryClickedEvent>(){

            public void onEvent(String topic, NiftyMousePrimaryClickedEvent data) {
                ButtonControl.this.nifty.publishEvent(topic, (NiftyEvent)new ButtonClickedEvent(ButtonControl.this));
            }
        };
        this.nifty.subscribe(this.screen, this.getElement().getId(), NiftyMousePrimaryClickedEvent.class, (EventTopicSubscriber)mouseClickedSubscriber);
        super.init(parameter, controlDefinitionAttributes);
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        Element prevElement;
        Element buttonElement = this.getElement();
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            if (this.focusHandler != null) {
                this.focusHandler.getNext(buttonElement).setFocus();
            }
            return true;
        }
        if (inputEvent == NiftyInputEvent.PrevInputElement) {
            if (this.focusHandler != null) {
                this.focusHandler.getPrev(buttonElement).setFocus();
            }
            return true;
        }
        if (inputEvent == NiftyInputEvent.Activate) {
            this.buttonClick();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            Element nextElement;
            if (this.focusHandler != null && (nextElement = this.focusHandler.getNext(buttonElement)).getParent().equals(buttonElement.getParent())) {
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorUp && this.focusHandler != null && (prevElement = this.focusHandler.getPrev(buttonElement)).getParent().equals(buttonElement.getParent())) {
            prevElement.setFocus();
            return true;
        }
        return false;
    }

    private void buttonClick() {
        this.getElement().onClick();
    }

    @Override
    public void activate() {
        this.buttonClick();
    }

    @Override
    public String getText() {
        return this.buttonTextRenderer.getOriginalText();
    }

    @Override
    public void setText(String text) {
        this.buttonTextRenderer.setText(text);
        if (!this.buttonTextRenderer.isLineWrapping()) {
            this.buttonTextElement.setConstraintWidth(new SizeValue(this.buttonTextRenderer.getTextWidth() + "px"));
        }
    }

    @Override
    public int getTextWidth() {
        return this.buttonTextRenderer.getTextWidth();
    }

    @Override
    public int getTextHeight() {
        return this.buttonTextRenderer.getTextHeight();
    }

    @Override
    public RenderFont getFont() {
        return this.buttonTextRenderer.getFont();
    }

    @Override
    public void setFont(RenderFont fontParam) {
        this.buttonTextRenderer.setFont(fontParam);
    }

    @Override
    public VerticalAlign getTextVAlign() {
        return this.buttonTextRenderer.getTextVAlign();
    }

    @Override
    public void setTextVAlign(VerticalAlign newTextVAlign) {
        this.buttonTextRenderer.setTextVAlign(newTextVAlign);
    }

    @Override
    public HorizontalAlign getTextHAlign() {
        return this.buttonTextRenderer.getTextHAlign();
    }

    @Override
    public void setTextHAlign(HorizontalAlign newTextHAlign) {
        this.buttonTextRenderer.setTextHAlign(newTextHAlign);
    }

    @Override
    public Color getTextColor() {
        return this.buttonTextRenderer.getColor();
    }

    @Override
    public void setTextColor(Color newColor) {
        this.buttonTextRenderer.setColor(newColor);
    }
}

