/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.List;
import mythruna.MaterialIndex;
import mythruna.es.EntityId;

public class Avatar
extends Node {
    public static final String DEFAULT_NAME = "Loading...";
    public static final String TYPE = "Avatar";
    private Spatial model;
    private String name;
    private float headHeight = 1.7f;
    private BitmapFont font;
    private BitmapText label;
    private Node textNode;
    private Quaternion facing;
    private Node headNode;
    private Node hairNode;
    private SkeletonControl skeletonControl;
    private List<Material> materials = new ArrayList<Material>();

    public Avatar(AssetManager assets, String name) {
        super("FemaleAvatar");
        String tempName = name == null ? DEFAULT_NAME : name;
        float scale = 0.27006173f;
        this.model = assets.loadModel("Models/female-parts.j3o");
        this.setupMaterial(this.model, assets);
        if (this.model instanceof Node) {
            Avatar.fixBucket((Node)this.model);
        }
        this.model.setQueueBucket(RenderQueue.Bucket.Opaque);
        this.model.setUserData("type", (Object)TYPE);
        this.attachChild(this.model);
        this.model.setLocalTranslation(0.0f, -(this.headHeight / scale), 0.0f);
        this.setLocalScale(scale, scale, scale);
        this.font = assets.loadFont("Interface/knights24-outline.fnt");
        this.textNode = new Node("LabelNode");
        this.textNode.setLocalScale(0.7f, 0.7f, 0.7f);
        this.updateText(tempName);
        this.textNode.setLocalTranslation(0.0f, this.label.getHeight(), 0.0f);
        this.attachChild((Spatial)this.textNode);
        System.out.println("Found skeleton:" + this.getSkeleton());
    }

    public int collideWith(Collidable other, CollisionResults results) {
        return super.collideWith(other, results);
    }

    protected void showControls(Spatial s) {
        System.out.println("show controls:" + s);
        int count = s.getNumControls();
        for (int i = 0; i < count; ++i) {
            Control c = s.getControl(i);
            System.out.println("  c[" + i + "] = " + c);
        }
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                this.showControls(child);
            }
        }
    }

    protected void attachHead(Node n) {
        this.headNode = n;
    }

    protected void attachHair(Node n) {
        this.hairNode = n;
    }

    protected void setupMaterial(Spatial s, AssetManager assets) {
        if (s instanceof Geometry) {
            this.setupMaterial((Geometry)s, assets);
        } else {
            this.setupMaterial((Node)s, assets);
        }
    }

    protected void setupMaterial(Node n, AssetManager assets) {
        System.out.println("Node:" + n);
        if ("head".equals(n.getName())) {
            this.attachHead(n);
        } else if ("hair".equals(n.getName())) {
            this.attachHair(n);
        }
        for (Spatial s : n.getChildren()) {
            this.setupMaterial(s, assets);
        }
    }

    protected void setupMaterial(Geometry g, AssetManager assets) {
        Material m = g.getMaterial();
        System.out.println("geom:" + g + "  has material:" + m);
        System.out.println("  pos:" + g.getLocalTranslation());
        MatParamTexture mpt = m.getTextureParam("DiffuseMap");
        Texture t = mpt.getTextureValue();
        System.out.println("  -- texture:" + t);
        Material material = new Material(assets, "MatDefs/LightingWithFog2.j3md");
        material.setTexture("DiffuseMap", t);
        material.setColor("Diffuse", MaterialIndex.getDiffuse());
        material.setColor("Ambient", MaterialIndex.getAmbient().mult(1.5f));
        material.setColor("Specular", MaterialIndex.getSpecular());
        material.setColor("FogColor", MaterialIndex.getFogColor());
        material.setFloat("Shininess", 100.0f);
        material.setFloat("SunFactor", 1.0f);
        material.setFloat("LightFactor", 0.0f);
        material.setBoolean("UseMaterialColors", true);
        g.setMaterial(material);
        this.materials.add(material);
    }

    public void setEntityId(EntityId id) {
        if (id != null) {
            this.model.setUserData("id", (Object)id.getId());
        }
    }

    public long getEntityId() {
        Long l = (Long)this.model.getUserData("id");
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected void updateText(String s) {
        if (this.label != null) {
            this.label.removeFromParent();
        }
        this.label = new BitmapText(this.font, false);
        this.label.setSize(1.0f);
        this.label.setText(s);
        float textWidth = this.label.getLineWidth() + 20.0f;
        float textOffset = textWidth / 2.0f;
        this.label.setBox(new Rectangle(-textOffset, 0.0f, textWidth, this.label.getHeight()));
        this.label.setColor(new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f));
        this.label.setAlignment(BitmapFont.Align.Center);
        this.label.setQueueBucket(RenderQueue.Bucket.Transparent);
        BillboardControl bc = new BillboardControl();
        bc.setAlignment(BillboardControl.Alignment.Screen);
        this.label.addControl((Control)bc);
        this.textNode.attachChild((Spatial)this.label);
    }

    public void setName(String name) {
        if (this.name != null && this.name.equals(name)) {
            return;
        }
        if (name == null) {
            return;
        }
        this.name = name;
        this.updateText(name);
    }

    public String getName() {
        return this.name;
    }

    public float getHeadHeight() {
        return this.headHeight;
    }

    protected static void fixBucket(Node n) {
        n.setQueueBucket(RenderQueue.Bucket.Opaque);
        for (Spatial c : n.getChildren()) {
            c.setQueueBucket(RenderQueue.Bucket.Opaque);
            if (!(c instanceof Node)) continue;
            Avatar.fixBucket((Node)c);
        }
    }

    protected SkeletonControl findSkeletonControl(Node n) {
        for (Spatial s : n.getChildren()) {
            SkeletonControl sc = (SkeletonControl)s.getControl(SkeletonControl.class);
            if (sc != null) {
                return sc;
            }
            if (s instanceof Node) {
                sc = this.findSkeletonControl((Node)s);
            }
            if (sc == null) continue;
            return sc;
        }
        return null;
    }

    protected Skeleton getSkeleton() {
        if (this.skeletonControl != null) {
            return this.skeletonControl.getSkeleton();
        }
        this.skeletonControl = (SkeletonControl)this.model.getControl(SkeletonControl.class);
        if (this.skeletonControl != null) {
            return this.skeletonControl.getSkeleton();
        }
        if (this.model instanceof Node) {
            this.skeletonControl = this.findSkeletonControl((Node)this.model);
        }
        if (this.skeletonControl != null) {
            return this.skeletonControl.getSkeleton();
        }
        return null;
    }

    public void setLighting(float sun, float local) {
        for (Material material : this.materials) {
            material.setFloat("SunFactor", sun);
            material.setFloat("LightFactor", local);
        }
    }

    public void setFacing(Quaternion quat) {
        if (this.facing != null && this.facing.equals((Object)quat)) {
            return;
        }
        this.facing = quat.clone();
        float[] angles = this.facing.toAngles(null);
        Quaternion body = new Quaternion().fromAngles(0.0f, angles[1], 0.0f);
        float angle = FastMath.clamp((float)angles[0], (float)-1.5707964f, (float)1.5707964f);
        Quaternion head = new Quaternion().fromAngles(angle * 0.5f, 0.0f, 0.0f);
        Quaternion realHead = new Quaternion().fromAngles(angle * 0.5f, 0.0f, 0.0f);
        this.setLocalRotation(body);
        Bone b = this.getSkeleton().getBone("Head");
        b.setUserControl(true);
        b.setUserTransforms(Vector3f.ZERO, head, Vector3f.UNIT_XYZ);
        if (this.headNode != null) {
            this.headNode.setLocalRotation(realHead);
        }
        if (this.hairNode != null) {
            this.hairNode.setLocalRotation(realHead);
        }
    }

    public String toString() {
        return "Avatar[" + this.getName() + ", " + this.getEntityId() + "]";
    }
}

