/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mythruna.Coordinates;
import org.progeeks.util.Inspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOptions {
    private static ClientOptions instance = new ClientOptions();
    private static final String PREFS_ROOT = "mythruna";
    private static String[] availableOptions = new String[]{"ambientSounds", "ambientSoundsVolume", "ambientEffects", "ambientEffectsVolume", "soundEffects", "soundEffectsVolume", "geometryThreadCount", "maxUpdatesPerFrame", "geometryBuildDelay", "mouseSensitivity", "invertMouse", "modalMap"};
    private static Set<String> optionNames = new HashSet<String>(Arrays.asList(availableOptions));
    public static final float ROTATION_SPEED_MAX = 6.0f;
    private Inspector inspector = new Inspector((Object)this);
    private Preferences prefs;
    private int geometryThreads;
    private int maxUpdatesPerFrame = 2;
    private long geometryBuildDelay;
    private float rotationSpeed = 1.2f;
    private boolean invertMouse;
    private boolean ambientSounds = true;
    private float ambientSoundsVolume = 1.0f;
    private boolean ambientEffects = true;
    private float ambientEffectsVolume = 1.0f;
    private boolean soundEffects = true;
    private float soundEffectsVolume = 1.0f;
    private boolean modalMap = true;
    private boolean firstTime = true;
    private Map<String, PrefLink> prefLinks = new ConcurrentHashMap<String, PrefLink>();

    protected ClientOptions() {
        this.geometryThreads = Math.min(2, Runtime.getRuntime().availableProcessors());
        this.geometryBuildDelay = this.geometryThreads > 1 ? 20L : 0L;
        this.setupPrefs();
        this.loadPrefs();
    }

    public static ClientOptions getInstance() {
        return instance;
    }

    public void reset() {
        try {
            this.getPrefs().removeNode();
            this.prefs = null;
            this.loadPrefs();
            this.save();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Error storing preferences", e);
        }
    }

    protected void setupPrefs() {
        this.addPref(new FloatPref("rotationSpeed", 1.2f));
        this.addPref(new BooleanPref("invertMouse", false));
        this.addPref(new BooleanPref("ambientSounds", true));
        this.addPref(new FloatPref("ambientSoundsVolume", 1.0f));
        this.addPref(new BooleanPref("ambientEffects", true));
        this.addPref(new FloatPref("ambientEffectsVolume", 1.0f));
        this.addPref(new BooleanPref("soundEffects", true));
        this.addPref(new FloatPref("soundEffectsVolume", 1.0f));
        this.addPref(new BooleanPref("firstTime", true));
    }

    protected void addPref(PrefLink p) {
        this.prefLinks.put(p.getName(), p);
    }

    protected void loadPrefs() {
        long start = System.nanoTime();
        for (PrefLink p : this.prefLinks.values()) {
            p.loadValue();
        }
        long end = System.nanoTime();
        System.out.println("Loaded preferences in " + (double)(end - start) / 1000000.0 + " ms");
    }

    public void save() {
        long start = System.nanoTime();
        System.out.println("--Saving client options.");
        for (PrefLink p : this.prefLinks.values()) {
            p.storeValue();
        }
        try {
            this.getPrefs().flush();
            long end = System.nanoTime();
            System.out.println("Saved preferences in " + (double)(end - start) / 1000000.0 + " ms");
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Error storing preferences", e);
        }
    }

    public Preferences getPrefs() {
        if (this.prefs == null) {
            Preferences userRoot = Preferences.userRoot();
            this.prefs = userRoot.node(PREFS_ROOT);
            System.out.println("Prefs:" + this.prefs);
            Preferences test = Preferences.userNodeForPackage(Coordinates.class);
            System.out.println("Test:" + test);
        }
        return this.prefs;
    }

    public Set<String> options() {
        return optionNames;
    }

    public <T> T getOption(String option) {
        return (T)this.inspector.get(option);
    }

    public void setOption(String option, Object value) {
        this.inspector.set(option, value);
    }

    public void setFirstTime(boolean f) {
        this.firstTime = f;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setInvertMouse(boolean f) {
        this.invertMouse = f;
    }

    public boolean getInvertMouse() {
        return this.invertMouse;
    }

    public void setAmbientSounds(boolean f) {
        this.ambientSounds = f;
    }

    public boolean getAmbientSounds() {
        return this.ambientSounds;
    }

    public void setAmbientEffects(boolean f) {
        this.ambientEffects = f;
    }

    public boolean getAmbientEffects() {
        return this.ambientEffects;
    }

    public void setSoundEffects(boolean f) {
        this.soundEffects = f;
    }

    public boolean getSoundEffects() {
        return this.soundEffects;
    }

    public void setAmbientSoundsVolume(float f) {
        this.ambientSoundsVolume = f;
    }

    public float getAmbientSoundsVolume() {
        return this.ambientSoundsVolume;
    }

    public void setAmbientEffectsVolume(float f) {
        this.ambientEffectsVolume = f;
    }

    public float getAmbientEffectsVolume() {
        return this.ambientEffectsVolume;
    }

    public void setSoundEffectsVolume(float f) {
        this.soundEffectsVolume = f;
    }

    public float getSoundEffectsVolume() {
        return this.soundEffectsVolume;
    }

    public void setGeometryThreadCount(int val) {
        this.geometryThreads = val;
    }

    public int getGeometryThreadCount() {
        return this.geometryThreads;
    }

    public void setMaxUpdatesPerFrame(int val) {
        this.maxUpdatesPerFrame = val;
    }

    public int getMaxUpdatesPerFrame() {
        return this.maxUpdatesPerFrame;
    }

    public void setGeometryBuildDelay(long val) {
        this.geometryBuildDelay = val;
    }

    public long getGeometryBuildDelay() {
        return 10L;
    }

    public void setRotationSpeed(float f) {
        this.rotationSpeed = f;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setMouseSensitivity(float f) {
        this.rotationSpeed = f * 6.0f;
    }

    public float getMouseSensitivity() {
        return this.rotationSpeed / 6.0f;
    }

    public void setModalMap(boolean b) {
        this.modalMap = b;
    }

    public boolean getModalMap() {
        return this.modalMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Options:\n");
        sb.append("  ambientSounds=" + this.getAmbientSounds() + "\n");
        sb.append("  ambientEffects=" + this.getAmbientEffects() + "\n");
        sb.append("  soundEffects=" + this.getSoundEffects() + "\n");
        sb.append("  geometryThreadCount=" + this.getGeometryThreadCount() + "\n");
        sb.append("  maxUpdatesPerFrame=" + this.getMaxUpdatesPerFrame() + "\n");
        sb.append("  geometryBuildDelay=" + this.getGeometryBuildDelay() + "\n");
        sb.append("  rotationSpeed=" + this.getRotationSpeed());
        return sb.toString();
    }

    private class BooleanPref
    extends PrefLink {
        private boolean defValue;

        public BooleanPref(String name, boolean defValue) {
            super(name);
            this.defValue = defValue;
        }

        public void loadValue() {
            boolean value = ClientOptions.this.getPrefs().getBoolean(this.name, this.defValue);
            ClientOptions.this.setOption(this.name, value);
        }

        public void storeValue() {
            boolean value = (Boolean)ClientOptions.this.getOption(this.name);
            if (value != this.defValue) {
                ClientOptions.this.getPrefs().putBoolean(this.name, value);
            } else {
                ClientOptions.this.getPrefs().remove(this.name);
            }
        }
    }

    private class FloatPref
    extends PrefLink {
        private float defValue;

        public FloatPref(String name, float defValue) {
            super(name);
            this.defValue = defValue;
        }

        public void loadValue() {
            float value = ClientOptions.this.getPrefs().getFloat(this.name, this.defValue);
            ClientOptions.this.setOption(this.name, Float.valueOf(value));
        }

        public void storeValue() {
            float value = ((Float)ClientOptions.this.getOption(this.name)).floatValue();
            if (value != this.defValue) {
                ClientOptions.this.getPrefs().putFloat(this.name, value);
            } else {
                ClientOptions.this.getPrefs().remove(this.name);
            }
        }
    }

    private abstract class PrefLink {
        protected String name;

        public PrefLink(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract void loadValue();

        public abstract void storeValue();
    }
}

