/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import mythruna.Coordinates;
import mythruna.MovementState;
import mythruna.client.ClientOptions;
import mythruna.client.GameClient;
import mythruna.client.WorldIntersector;
import mythruna.client.ui.ObservableState;
import mythruna.client.view.LocalArea;

public class ConveyerCamera
extends ObservableState
implements AnalogListener,
ActionListener {
    public static final long MIN_INTERSECT_TIME = 250L;
    private static final String CAM_LEFT = "CAM_PanLeft";
    private static final String CAM_RIGHT = "CAM_PanRight";
    private static final String CAM_UP = "CAM_PanUp";
    private static final String CAM_DOWN = "CAM_PanDown";
    private static final String CAM_FORWARD = "CAM_Forward";
    private static final String CAM_BACK = "CAM_Back";
    private static final String CAM_STRAFE_LEFT = "CAM_StrafeLeft";
    private static final String CAM_STRAFE_RIGHT = "CAM_StrafeRight";
    private static final String CAM_RAISE = "CAM_Raise";
    private static final String CAM_LOWER = "CAM_Lower";
    private static final String CAM_JUMP = "CAM_Jump";
    private static final String CAM_RUN = "CAM_Run";
    private static final String CAM_TEST = "CAM_Test";
    private static final String[] CAM_MAPPINGS = new String[]{"CAM_PanLeft", "CAM_PanRight", "CAM_PanUp", "CAM_PanDown", "CAM_Forward", "CAM_Back", "CAM_StrafeLeft", "CAM_StrafeRight", "CAM_Raise", "CAM_Lower", "CAM_Jump", "CAM_Run", "CAM_Test"};
    private Camera camera;
    private float movementSpeed;
    private Vector3f initialUpVec = new Vector3f(0.0f, 1.0f, 0.0f);
    private InputManager inputManager;
    private MovementState movement = new MovementState();
    private GameClient client;
    private LocalArea localArea;
    private long lastIntersectTime = -1L;
    private WorldIntersector.Intersection hit;
    private boolean hitTest = true;
    private boolean walkOnWater = false;

    public ConveyerCamera(Camera camera, GameClient client, LocalArea localArea) {
        super("CameraState", true);
        this.camera = camera;
        this.movementSpeed = 5.0f;
        this.localArea = localArea;
        this.client = client;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setHitTest(boolean f) {
        this.hitTest = f;
    }

    public void setSpeed(float f) {
        this.movementSpeed = f;
    }

    public float getSpeed() {
        return this.movementSpeed;
    }

    public float getRotationSpeed() {
        return ClientOptions.getInstance().getRotationSpeed();
    }

    public boolean invertMouse() {
        return ClientOptions.getInstance().getInvertMouse();
    }

    public void setWorldLocation(float x, float y) {
        float z = this.localArea.setLocation(x, y);
        this.client.setLocation(x, y, z);
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.registerWithInput(app.getInputManager());
    }

    public void registerWithInput(InputManager inputManager) {
        this.inputManager = inputManager;
        inputManager.addMapping(CAM_LEFT, new Trigger[]{new MouseAxisTrigger(0, true), new KeyTrigger(203)});
        inputManager.addMapping(CAM_RIGHT, new Trigger[]{new MouseAxisTrigger(0, false), new KeyTrigger(205)});
        inputManager.addMapping(CAM_UP, new Trigger[]{new MouseAxisTrigger(1, false), new KeyTrigger(200)});
        inputManager.addMapping(CAM_DOWN, new Trigger[]{new MouseAxisTrigger(1, true), new KeyTrigger(208)});
        inputManager.addMapping(CAM_STRAFE_LEFT, new Trigger[]{new KeyTrigger(30)});
        inputManager.addMapping(CAM_STRAFE_RIGHT, new Trigger[]{new KeyTrigger(32)});
        inputManager.addMapping(CAM_FORWARD, new Trigger[]{new KeyTrigger(17)});
        inputManager.addMapping(CAM_BACK, new Trigger[]{new KeyTrigger(31)});
        inputManager.addMapping(CAM_RAISE, new Trigger[]{new KeyTrigger(16)});
        inputManager.addMapping(CAM_LOWER, new Trigger[]{new KeyTrigger(44)});
        inputManager.addMapping(CAM_JUMP, new Trigger[]{new KeyTrigger(57)});
        inputManager.addMapping(CAM_RUN, new Trigger[]{new KeyTrigger(42)});
        inputManager.addMapping(CAM_TEST, new Trigger[]{new KeyTrigger(45)});
        inputManager.addListener((InputListener)this, CAM_MAPPINGS);
        Joystick[] sticks = inputManager.getJoysticks();
        if (sticks != null && sticks.length > 0) {
            sticks[0].assignAxis(CAM_STRAFE_RIGHT, CAM_STRAFE_LEFT, 254);
            sticks[0].assignAxis(CAM_FORWARD, CAM_BACK, 255);
            sticks[0].assignAxis(CAM_RIGHT, CAM_LEFT, sticks[0].getXAxisIndex());
            sticks[0].assignAxis(CAM_DOWN, CAM_UP, sticks[0].getYAxisIndex());
        }
        this.client.setFacing(this.camera.getRotation());
    }

    protected void enable() {
        this.inputManager.setCursorVisible(false);
    }

    protected void disable() {
        this.inputManager.setCursorVisible(true);
    }

    private void testIntersect() {
        long start = System.nanoTime();
        long end = System.nanoTime();
        System.out.println("Intersect done in:" + (double)(end - start) / 1000000.0 + " ms");
    }

    private void rotate(float value, Vector3f axis) {
        Matrix3f mat = new Matrix3f();
        mat.fromAngleNormalAxis(this.getRotationSpeed() * value, axis);
        Vector3f up = this.camera.getUp();
        Vector3f left = this.camera.getLeft();
        Vector3f dir = this.camera.getDirection();
        mat.mult(up, up);
        mat.mult(left, left);
        mat.mult(dir, dir);
        Quaternion q = new Quaternion();
        q.fromAxes(left, up, dir);
        q.normalize();
        this.camera.setAxes(q);
        this.client.setFacing(this.camera.getRotation());
    }

    private void rotatePitch(float value, Vector3f axis) {
        Matrix3f mat = new Matrix3f();
        if (this.invertMouse()) {
            value *= -1.0f;
        }
        mat.fromAngleNormalAxis(this.getRotationSpeed() * value, axis);
        Vector3f up = this.camera.getUp();
        Vector3f left = this.camera.getLeft();
        Vector3f dir = this.camera.getDirection();
        mat.mult(up, up);
        mat.mult(left, left);
        mat.mult(dir, dir);
        Quaternion q = new Quaternion();
        q.fromAxes(left, up, dir);
        q.normalize();
        this.camera.setAxes(q);
        this.client.setFacing(this.camera.getRotation());
    }

    protected Quaternion toWorld(Quaternion q) {
        return Coordinates.flipAxes(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAnalog(String name, float value, float tpf) {
        long start = System.nanoTime();
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (CAM_LEFT.equals(name)) {
                this.rotate(value, this.initialUpVec);
            } else if (CAM_RIGHT.equals(name)) {
                this.rotate(-value, this.initialUpVec);
            } else if (CAM_UP.equals(name)) {
                this.rotatePitch(-value, this.camera.getLeft());
            } else if (CAM_DOWN.equals(name)) {
                this.rotatePitch(value, this.camera.getLeft());
            }
        }
        finally {
            long end = System.nanoTime();
            long delta = end - start;
            if (delta > 1000000L) {
                System.out.println("onAnalog() took:" + (double)delta / 1000000.0 + " ms.");
            }
        }
    }

    public boolean isHeadInWater() {
        return this.client.isHeadInWater();
    }

    public WorldIntersector.Intersection getHit() {
        return this.hit;
    }

    public void update() {
        Vector3f pos = this.client.getLocation();
        this.localArea.setLocation(pos.x, pos.y, pos.z);
        long time = System.currentTimeMillis();
        if (time - this.lastIntersectTime > 250L && this.hitTest) {
            long start = System.nanoTime();
            Vector3f dir = new Vector3f();
            this.camera.getDirection(dir);
            pos = pos.clone();
            dir.set(dir.x, dir.z, dir.y);
            Ray ray = new Ray(pos, dir);
            ray.setLimit(4.0f);
            WorldIntersector wi = new WorldIntersector(this.localArea, ray, 7, 8);
            this.hit = null;
            while (wi.hasNext()) {
                WorldIntersector.Intersection isect = wi.next();
                if (!this.walkOnWater && isect.getType() == 7) continue;
                this.hit = isect;
                break;
            }
            long end = System.nanoTime();
            this.lastIntersectTime = time;
        }
    }

    private int minIndex(float ... vals) {
        int minIndex = 0;
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == Float.NaN || !(vals[i] < min)) continue;
            min = vals[i];
            minIndex = i;
        }
        return minIndex;
    }

    private int maxIndex(float ... vals) {
        int maxIndex = 0;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == Float.NaN || !(vals[i] > max)) continue;
            max = vals[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAction(String name, boolean value, float tpf) {
        long start = System.nanoTime();
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (CAM_TEST.equals(name)) {
                if (!value) {
                    this.testIntersect();
                }
                System.gc();
            } else {
                if (CAM_FORWARD.equals(name)) {
                    this.movement.set((byte)1, value);
                } else if (CAM_BACK.equals(name)) {
                    this.movement.set((byte)2, value);
                } else if (CAM_STRAFE_LEFT.equals(name)) {
                    this.movement.set((byte)4, value);
                } else if (CAM_STRAFE_RIGHT.equals(name)) {
                    this.movement.set((byte)8, value);
                } else if (CAM_RAISE.equals(name)) {
                    this.movement.set((byte)16, value);
                } else if (CAM_LOWER.equals(name)) {
                    this.movement.set((byte)32, value);
                } else if (CAM_JUMP.equals(name)) {
                    this.movement.set((byte)64, value);
                } else if (CAM_RUN.equals(name)) {
                    this.movement.set((byte)-128, value);
                }
                this.client.setMoveState(this.movement.getMovementFlags());
            }
        }
        finally {
            long end = System.nanoTime();
            long delta = end - start;
            if (delta > 1000000L) {
                System.out.println("onAction() took:" + (double)delta / 1000000.0 + " ms.");
            }
        }
    }
}

