/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.ui.Picture;
import mythruna.client.GameClient;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.VAlignment;
import mythruna.es.Entity;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.item.ReticleStyle;
import org.progeeks.util.ObjectUtils;

public class CrosshairState
extends ObservableState {
    private GameClient client;
    private Node guiRoot;
    private Node crosshair;
    private Picture cursor;
    private Label text;
    private String imageName;
    private float width;
    private float height;
    private float scale = 1.0f;
    private float maxScale = 1.0f;
    private EntitySet us;
    private ReticleStyle style;

    public CrosshairState(GameClient client, Node guiRoot) {
        super("Crosshair", true);
        this.guiRoot = guiRoot;
        this.client = client;
    }

    public CrosshairState(GameClient client, Node guiRoot, String imageName, int width, int height) {
        this(client, guiRoot);
        this.client = client;
        this.setImage(imageName, width, height);
    }

    public void setImage(String imageName, float width, float height) {
        if (ObjectUtils.areEqual((Object)this.imageName, (Object)imageName) && this.width == width && this.height == height) {
            return;
        }
        this.setStyle(null);
        this.imageName = imageName;
        this.width = width;
        this.height = height;
        if (imageName == null) {
            if (this.cursor != null) {
                this.cursor.removeFromParent();
            }
            this.cursor = null;
            return;
        }
        if (this.crosshair == null) {
            return;
        }
        this.updateCursor();
    }

    protected void updateCursor() {
        if (this.cursor == null) {
            this.cursor = new Picture("Cursor");
            this.crosshair.attachChild((Spatial)this.cursor);
        }
        this.cursor.setLocalTranslation(-this.width * 0.5f * this.scale, -this.height * 0.5f * this.scale, 0.0f);
        this.cursor.setWidth(this.width * this.scale);
        this.cursor.setHeight(this.height * this.scale);
        this.cursor.setImage(this.getApplication().getAssetManager(), this.imageName, true);
        this.text.setLocalTranslation(0.0f, -this.height * 0.4f * this.scale, 0.0f);
    }

    protected void updateStyle() {
        Entity e = this.us.getEntity(this.client.getPlayer());
        System.out.println("-------------------updateslots() e:" + e);
        if (e == null) {
            this.setStyle(null);
            return;
        }
        ReticleStyle s = e.get(ReticleStyle.class);
        this.setStyle(s);
    }

    public void setStyle(ReticleStyle style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        System.out.println("setStyle(" + style + ")");
        if (style == null) {
            this.text.setText(null);
        } else {
            this.text.setText(style.getText());
        }
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.crosshair = new Node("CrosshairReticle");
        Camera cam = app.getCamera();
        this.crosshair.setLocalTranslation((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, -1.0f);
        this.scale = (float)cam.getHeight() / 720.0f;
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
        }
        this.text = new Label(app);
        this.text.setHAlignment(HAlignment.CENTER);
        this.text.setVAlignment(VAlignment.TOP);
        this.text.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.text.setLocalScale(this.scale * 0.75f);
        this.crosshair.attachChild((Spatial)this.text);
        if (this.imageName != null) {
            this.updateCursor();
        }
    }

    protected void enable() {
        if (this.crosshair.getParent() != null) {
            return;
        }
        this.guiRoot.attachChild((Spatial)this.crosshair);
        FieldFilter<ReticleStyle> filter = new FieldFilter<ReticleStyle>(ReticleStyle.class, "id", this.client.getPlayer());
        this.us = this.client.getEntityData().getEntities(filter, ReticleStyle.class);
        this.updateStyle();
    }

    protected void disable() {
        this.us.release();
        this.guiRoot.detachChild((Spatial)this.crosshair);
    }

    public void update(float tpf) {
        if (this.us.applyChanges()) {
            this.updateStyle();
        }
    }
}

