/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import mythruna.client.ErrorHandler;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.TimeLog;

public class GameLoader
extends Thread {
    private GameClient client;
    private AppStateManager stateManager;

    public GameLoader(GameClient client, AppStateManager stateManager) {
        this.client = client;
        this.stateManager = stateManager;
        this.setDaemon(true);
        this.setName("Game Loader");
    }

    public void run() {
        try {
            TimeLog.log(this.getClass().getSimpleName(), "Starting game client.");
            this.client.initialize();
            this.client.start();
            TimeLog.log(this.getClass().getSimpleName(), "Creating app state.");
            GameAppState gameState = new GameAppState(this.client);
            System.out.println("Attaching:" + (Object)((Object)gameState) + "   to:" + this.stateManager);
            TimeLog.log(this.getClass().getSimpleName(), "Attaching game state.");
            this.stateManager.attach((AppState)gameState);
        }
        catch (Exception e) {
            ErrorHandler.handle(e, true);
        }
    }
}

