/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.client.PhysicsTask;

public class PhysicsThread
extends Thread {
    public static PhysicsThread instance = new PhysicsThread();
    private long targetFrameLength = 20000000L;
    private long maxFrameLength = 50000000L;
    private long lastTime = -1L;
    private List<PhysicsTask> tasks = new CopyOnWriteArrayList<PhysicsTask>();
    private PhysicsTask[] taskArray;

    public PhysicsThread() {
        this.setName("AnimationThread");
        this.setDaemon(true);
    }

    public void addTask(PhysicsTask t) {
        this.tasks.add(t);
        this.taskArray = null;
    }

    public void removeTask(PhysicsTask t) {
        this.tasks.remove(t);
        this.taskArray = null;
    }

    private PhysicsTask[] getTaskArray() {
        if (this.taskArray == null) {
            this.taskArray = this.tasks.toArray(new PhysicsTask[this.tasks.size()]);
        }
        return this.taskArray;
    }

    private void doTasks(long delta) {
        PhysicsTask[] array;
        double secs = (double)delta / 1.0E9;
        for (PhysicsTask t : array = this.getTaskArray()) {
            if (t.updatePhysics(this, secs)) continue;
            this.removeTask(t);
        }
    }

    public void poll() {
        long time = System.nanoTime();
        if (this.lastTime < 0L) {
            this.lastTime = time - 1L;
        }
        long delta = time - this.lastTime;
        this.doTasks(delta);
        this.lastTime = time;
    }

    public void run() {
        long timeTest = System.nanoTime();
        while (true) {
            long time = System.nanoTime();
            long delta = time - this.lastTime;
            long testDelta = time - timeTest;
            timeTest = time;
            if (testDelta < 0L) {
                System.out.println("Time went backwards:" + testDelta);
                continue;
            }
            if (delta > this.targetFrameLength) {
                long off = delta - this.targetFrameLength;
                if (this.lastTime > 0L) {
                    int count = 0;
                    while (delta > this.maxFrameLength) {
                        System.out.println("Catchup frame:" + delta);
                        this.doTasks(this.maxFrameLength);
                        if (++count <= 10 || (delta -= this.maxFrameLength) <= this.maxFrameLength) continue;
                        delta = this.maxFrameLength;
                    }
                }
                this.doTasks(delta);
                this.lastTime = time;
                continue;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

