/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.math.Vector3f;
import mythruna.Coordinates;
import mythruna.Vector3i;
import mythruna.client.GameClient;
import mythruna.db.ColumnInfo;
import mythruna.db.WorldDatabase;
import org.progeeks.util.ObservableMap;
import org.progeeks.util.beans.StandardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerState
extends AbstractAppState {
    public static final String TYPE_AT_HEAD = "typeAtHead";
    public static final String TYPE_AT_FEET = "typeAtFeet";
    public static final String TYPE_UNDER_FEET = "typeUnderFeet";
    public static final String HEAD_IN_WATER = "headInWater";
    public static final String MOVING = "moving";
    public static final String RUNNING = "running";
    public static final String WALK_TYPE = "walkType";
    public static final String SUNLIGHT = "sunlight";
    private static float MOVE_EPSILON = 0.01f;
    private static final Vector3i defaultCoords = new Vector3i(0, 0, 0);
    private GameClient gameClient;
    private WorldDatabase worldDb;
    private ObservableMap<String, Object> values = new ObservableMap();
    private float headHeight = 1.7f;

    public PlayerState(GameClient gameClient) {
        this.gameClient = gameClient;
    }

    protected <T> T get(String key, T defaultValue) {
        Object o = this.values.get((Object)key);
        return (T)(o == null ? defaultValue : o);
    }

    public void setSunlight(int val) {
        this.values.put((Object)SUNLIGHT, (Object)val);
    }

    public int getSunlight() {
        return this.get(SUNLIGHT, 15);
    }

    public void setTypeAtHead(int type) {
        this.values.put((Object)TYPE_AT_HEAD, (Object)type);
    }

    public int getTypeAtHead() {
        return this.get(TYPE_AT_HEAD, 0);
    }

    public void setTypeAtFeet(int type) {
        this.values.put((Object)TYPE_AT_FEET, (Object)type);
    }

    public int getTypeAtFeet() {
        return this.get(TYPE_AT_FEET, 0);
    }

    public void setTypeUnderFeet(int type) {
        this.values.put((Object)TYPE_UNDER_FEET, (Object)type);
    }

    public int getTypeUnderFeet() {
        return this.get(TYPE_UNDER_FEET, 0);
    }

    public void setHeadInWater(boolean f) {
        this.values.put((Object)HEAD_IN_WATER, (Object)f);
    }

    public boolean isHeadInWater() {
        return this.get(HEAD_IN_WATER, false);
    }

    public void setMoving(boolean f) {
        this.values.put((Object)MOVING, (Object)f);
    }

    public boolean isMoving() {
        return this.get(MOVING, false);
    }

    public void setRunning(boolean f) {
        this.values.put((Object)RUNNING, (Object)f);
    }

    public boolean isRunning() {
        return this.get(RUNNING, false);
    }

    public void setWalkType(int type) {
        this.values.put((Object)WALK_TYPE, (Object)type);
    }

    public int getWalkType() {
        return this.get(WALK_TYPE, 0);
    }

    public StandardBean getBean() {
        return this.values;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.worldDb = this.gameClient.getWorld().getWorldDatabase();
        this.setHeadInWater(false);
        this.setTypeAtFeet(0);
        this.setTypeAtHead(0);
    }

    protected int getBlockType(float x, float y, float z) {
        return this.worldDb.getCellType(Coordinates.worldToCell(x), Coordinates.worldToCell(y), Coordinates.worldToCell(z));
    }

    protected int getSunlight(float x, float y, float z) {
        return this.worldDb.getLight(0, Coordinates.worldToCell(x), Coordinates.worldToCell(y), Coordinates.worldToCell(z));
    }

    public void update(float tpf) {
        boolean move;
        Vector3f loc = this.gameClient.getLocation();
        this.setSunlight(this.getSunlight(loc.x, loc.y, loc.z));
        Vector3f vel = this.gameClient.getVelocity();
        boolean bl = move = Math.abs(vel.x) >= MOVE_EPSILON || Math.abs(vel.y) >= MOVE_EPSILON;
        if (!move && Math.abs(vel.z) < MOVE_EPSILON) {
            this.setMoving(false);
            this.setWalkType(0);
            return;
        }
        ColumnInfo colInfo = this.worldDb.getColumnInfo(Coordinates.worldToCell(loc.x), Coordinates.worldToCell(loc.y), true);
        if (colInfo != null) {
            short water = colInfo.getCount((byte)1);
            short ocean = colInfo.getCount((byte)2);
            short ground = colInfo.getCount((byte)3);
            short trees = colInfo.getCount((byte)4);
            short hills = colInfo.getCount((byte)5);
            short mountains = colInfo.getCount((byte)6);
            String type = "Grasslands";
            if (mountains > 200 || loc.z > 100.0f) {
                type = "mountains";
            } else if (trees > 50 && ocean < 100) {
                type = "forest";
            } else if (water > 50 && ocean < 100 && ground > 100) {
                type = "lakeside";
            } else if (ocean > 100 && ocean < 800 && ground > 100) {
                type = "seaside";
            } else if (ocean >= 800) {
                type = "open water";
            }
        }
        int typeAtFeet = this.getBlockType(loc.x, loc.y, loc.z - this.headHeight + 0.3f);
        int typeUnderFeet = this.getBlockType(loc.x, loc.y, loc.z - this.headHeight - 0.3f);
        int typeAtHead = this.getBlockType(loc.x, loc.y, loc.z);
        boolean inWater = false;
        boolean headInWater = false;
        if (typeAtFeet == 7 || typeAtFeet == 8) {
            if (typeAtHead == 7) {
                headInWater = true;
                inWater = true;
            } else if (typeAtHead == 8) {
                inWater = true;
                float zHead = loc.z;
                float zHeadDelta = zHead - (float)Math.floor(zHead);
                headInWater = zHeadDelta < 0.89f;
            } else {
                headInWater = false;
            }
        } else {
            headInWater = typeAtHead == 7 || typeAtHead == 8;
        }
        this.setMoving(true);
        this.setHeadInWater(headInWater);
        this.setTypeAtFeet(typeAtFeet);
        this.setTypeUnderFeet(typeUnderFeet);
        this.setTypeAtHead(typeAtHead);
        if (!move) {
            this.setWalkType(0);
        } else if (typeAtFeet == 8 && typeUnderFeet != 8 && typeUnderFeet != 0) {
            this.setWalkType(8);
        } else if (typeUnderFeet == 7) {
            this.setWalkType(0);
        } else {
            this.setWalkType(typeUnderFeet);
        }
    }
}

