/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import mythruna.GameTime;
import mythruna.client.ModeManager;

public class TimeController
implements AnalogListener,
ActionListener {
    private static final String ADJUST_TIME = "Time Adjust";
    private static final String TIME_UP = "Time Up";
    private static final String TIME_DOWN = "Time Down";
    private static final String TIME_ADVANCE = "Time Advance";
    private static final String[] TIME_MAPPINGS = new String[]{"Time Adjust", "Time Up", "Time Down", "Time Advance"};
    private GameTime gameTime;
    private boolean activated;
    private InputManager inputManager;

    public TimeController(GameTime gameTime, InputManager inputManager) {
        this.gameTime = gameTime;
        this.registerWithInput(inputManager);
    }

    public boolean isActivated() {
        return this.activated;
    }

    protected void registerWithInput(InputManager inputManager) {
        this.inputManager = inputManager;
        inputManager.addMapping(ADJUST_TIME, new Trigger[]{new KeyTrigger(62)});
        ModeManager.instance.addMode(ADJUST_TIME, TIME_UP, TIME_DOWN, TIME_ADVANCE, this);
        inputManager.addListener((InputListener)this, new String[]{ADJUST_TIME});
    }

    public void onAnalog(String name, float value, float tpf) {
        double increment = 300.0;
        if (TIME_UP.equals(name)) {
            this.gameTime.setTime(this.gameTime.getTime() + increment);
        } else if (TIME_DOWN.equals(name)) {
            this.gameTime.setTime(this.gameTime.getTime() - increment);
        } else if (TIME_ADVANCE.equals(name)) {
            this.gameTime.setTime(this.gameTime.getTime() + (double)(100000.0f * tpf));
        }
    }

    public void onAction(String name, boolean value, float tpf) {
        if (ADJUST_TIME.equals(name)) {
            ModeManager.instance.setMode(ADJUST_TIME, value);
        }
    }
}

