/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.anim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mythruna.client.anim.AnimatedContainer;
import mythruna.client.anim.AnimationState;
import mythruna.client.anim.AnimationTask;

public class ContainerAnimation
implements AnimationTask {
    private boolean keepGoing = true;
    private AnimatedContainer last;
    private AnimatedContainer current;
    private State state = State.IDLE;
    private List<AnimationTask> tasks = new ArrayList<AnimationTask>();

    public void stop() {
        this.keepGoing = false;
    }

    public void setContainer(AnimatedContainer container) {
        if (this.current != null) {
            switch (this.state) {
                case IDLE: {
                    this.close();
                    break;
                }
                case CLOSING: {
                    break;
                }
                case OPENING: {
                    this.tasks.clear();
                    this.close();
                }
            }
        }
        this.current = container;
        if (this.state == State.IDLE) {
            this.open();
        }
    }

    protected void close() {
        if (this.current == null) {
            return;
        }
        this.tasks.addAll(Arrays.asList(this.current.animateClose()));
        this.last = this.current;
        this.state = State.CLOSING;
    }

    protected void open() {
        if (this.current == null) {
            this.state = State.IDLE;
            return;
        }
        this.current.attach();
        this.tasks.addAll(Arrays.asList(this.current.animateOpen()));
        this.state = State.OPENING;
    }

    public boolean animate(AnimationState anim, float seconds) {
        if (this.state == State.IDLE && this.tasks.isEmpty()) {
            return this.keepGoing;
        }
        Iterator<AnimationTask> it = this.tasks.iterator();
        while (it.hasNext()) {
            AnimationTask t = it.next();
            boolean keep = t.animate(anim, seconds);
            if (keep) continue;
            it.remove();
        }
        if (this.tasks.isEmpty()) {
            switch (this.state) {
                case OPENING: {
                    this.state = State.IDLE;
                    break;
                }
                case CLOSING: {
                    this.last.detach();
                    this.last = null;
                    this.open();
                }
            }
        }
        return this.keepGoing || !this.tasks.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        OPENING,
        CLOSING;

    }
}

