/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.bm;

import com.jme3.collision.CollisionResult;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Vector3i;
import mythruna.client.WorldIntersector;
import mythruna.client.bm.ObjectSelector;
import mythruna.client.bm.Tool;
import mythruna.client.bm.ToolGroup;
import mythruna.client.view.BlockObject;
import mythruna.client.view.ClaimFieldControl;
import mythruna.client.view.DragControl;
import mythruna.db.BlueprintData;
import mythruna.db.DefaultBlueprintDatabase;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimType;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import mythruna.es.Name;
import mythruna.es.OwnedBy;
import mythruna.es.Position;
import mythruna.script.BlockParameter;
import mythruna.script.ObjectParameter;
import org.progeeks.util.log.Log;

public class ClaimsGroup
extends ToolGroup {
    static Log log = Log.getLog();
    private EntitySet claims;
    private EntitySet placedClaims;
    private List<Tool> originals = new ArrayList<Tool>();
    private Map<EntityId, PlaceClaimTool> placeClaimsMap = new TreeMap<EntityId, PlaceClaimTool>();
    private Map<EntityId, CreatePlotTool> createPlotMap = new TreeMap<EntityId, CreatePlotTool>();
    private Map<EntityId, GivePlotTool> givePlotMap = new TreeMap<EntityId, GivePlotTool>();
    private Map<EntityId, GiveBadgeTool> giveBadgeMap = new TreeMap<EntityId, GiveBadgeTool>();
    private ClaimTool defaultClaimTool;
    private BlueprintData stronghold;
    private BlueprintData town;
    private BlueprintData city;
    private BlueprintData flag1;
    private BlockObject groupIcon;

    public ClaimsGroup() {
        super("Claims");
    }

    protected BlockObject createIcon(BlueprintData data) {
        BlockObject bo = new BlockObject(data);
        bo.setScale(0.25f);
        bo.setLighting(0.8f, 0.25f);
        bo.build();
        bo.applyUpdates(null);
        return bo;
    }

    public void initialize(ObjectSelector selector) {
        try {
            this.stronghold = DefaultBlueprintDatabase.loadResource("stronghold.bp");
            this.town = DefaultBlueprintDatabase.loadResource("town.bp");
            this.city = DefaultBlueprintDatabase.loadResource("city.bp");
            this.flag1 = DefaultBlueprintDatabase.loadResource("flag1.bp");
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading claim tool models.", e);
        }
        this.groupIcon = this.createIcon(this.flag1);
        this.defaultClaimTool = new ClaimTool("Property");
        this.getTools().add(0, this.defaultClaimTool);
        this.originals.addAll(this.getTools());
        EntityData ed = selector.getWorld().getEntityData();
        this.claims = ed.getEntities(new FieldFilter<InContainer>(InContainer.class, "parentId", selector.getGameClient().getPlayer()), InContainer.class, ClaimType.class, Name.class);
        for (Entity e : this.claims) {
            this.placeClaimsMap.put(e.getId(), new PlaceClaimTool(e));
        }
        this.placedClaims = ed.getEntities(new FieldFilter<OwnedBy>(OwnedBy.class, "ownerId", selector.getGameClient().getPlayer()), OwnedBy.class, Position.class, ClaimArea.class, ClaimType.class, Name.class);
        for (Entity e : this.placedClaims) {
            ClaimType type = e.get(ClaimType.class);
            if (type.canBeParent()) {
                this.createPlotMap.put(e.getId(), new CreatePlotTool(e));
                this.givePlotMap.put(e.getId(), new GivePlotTool(e));
            }
            this.giveBadgeMap.put(e.getId(), new GiveBadgeTool(e));
        }
        this.getTools().addAll(this.placeClaimsMap.values());
        this.getTools().addAll(this.createPlotMap.values());
        this.getTools().addAll(this.givePlotMap.values());
        this.getTools().addAll(this.giveBadgeMap.values());
        super.initialize(selector);
    }

    public void setVisible(boolean v) {
        if (this.isVisible() == v) {
            return;
        }
        super.setVisible(v);
        ((ClaimFieldControl)this.getSelector().getLocalArea().getControl(ClaimFieldControl.class)).setEnabled(v);
    }

    public Spatial getIcon() {
        Spatial result = super.getIcon();
        if (result == null) {
            result = this.groupIcon.getNode();
        }
        return result;
    }

    public boolean update() {
        if (!this.isVisible()) {
            return false;
        }
        boolean resetTools = false;
        if (this.claims.applyChanges()) {
            PlaceClaimTool tool;
            if (log.isTraceEnabled()) {
                log.trace((Object)"******* There are claim changes...");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("All:" + this.claims));
            }
            resetTools = true;
            for (Entity e : this.claims.getAddedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  added:" + e));
                }
                tool = new PlaceClaimTool(e);
                this.placeClaimsMap.put(e.getId(), tool);
                tool.initialize(this.getSelector());
            }
            for (Entity e : this.claims.getChangedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  changed:" + e));
                }
                tool = this.placeClaimsMap.get(e.getId());
                tool.update();
            }
            for (Entity e : this.claims.getRemovedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  removed:" + e));
                }
                if ((tool = this.placeClaimsMap.remove(e.getId())) == null) continue;
            }
        }
        if (this.placedClaims.applyChanges()) {
            GiveBadgeTool tool3;
            GivePlotTool tool2;
            CreatePlotTool tool1;
            if (log.isTraceEnabled()) {
                log.trace((Object)"******* There are placed town changes...");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("All:" + this.claims));
            }
            resetTools = true;
            for (Entity e : this.placedClaims.getAddedEntities()) {
                ClaimType type;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  added:" + e));
                }
                if ((type = e.get(ClaimType.class)).canBeParent()) {
                    CreatePlotTool tool12 = new CreatePlotTool(e);
                    this.createPlotMap.put(e.getId(), tool12);
                    tool12.initialize(this.getSelector());
                    GivePlotTool tool22 = new GivePlotTool(e);
                    this.givePlotMap.put(e.getId(), tool22);
                    tool22.initialize(this.getSelector());
                }
                GiveBadgeTool tool32 = new GiveBadgeTool(e);
                this.giveBadgeMap.put(e.getId(), tool32);
                tool32.initialize(this.getSelector());
            }
            for (Entity e : this.placedClaims.getChangedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  changed:" + e));
                }
                if ((tool1 = this.createPlotMap.get(e.getId())) != null) {
                    tool1.update();
                }
                if ((tool2 = this.givePlotMap.get(e.getId())) != null) {
                    tool2.update();
                }
                if ((tool3 = this.giveBadgeMap.get(e.getId())) == null) continue;
                tool3.update();
            }
            for (Entity e : this.placedClaims.getRemovedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  removed:" + e));
                }
                if ((tool1 = this.createPlotMap.remove(e.getId())) != null) {
                    // empty if block
                }
                if ((tool2 = this.givePlotMap.remove(e.getId())) != null) {
                    // empty if block
                }
                if ((tool3 = this.giveBadgeMap.remove(e.getId())) == null) continue;
            }
        }
        if (resetTools) {
            this.getTools().clear();
            this.getTools().addAll(this.originals);
            this.getTools().addAll(this.placeClaimsMap.values());
            this.getTools().addAll(this.createPlotMap.values());
            this.getTools().addAll(this.givePlotMap.values());
            this.getTools().addAll(this.giveBadgeMap.values());
            return true;
        }
        return false;
    }

    public String toString() {
        return "ClaimsGroup[" + this.getName() + "]";
    }

    protected class GiveBadgeTool
    implements Tool {
        private ObjectSelector selector;
        private Entity claim;
        private String name;
        private BlockObject icon;
        private ClaimType type;

        public GiveBadgeTool(Entity claim) {
            this.claim = claim;
            this.name = claim.get(Name.class).getName();
            this.type = claim.get(ClaimType.class);
        }

        public void initialize(ObjectSelector selector) {
            this.selector = selector;
            switch (this.type.getClaimType()) {
                case 1: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.stronghold);
                    break;
                }
                case 3: 
                case 5: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.city);
                    break;
                }
                case 2: 
                case 4: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.town);
                }
            }
        }

        public void update() {
            this.name = this.claim.get(Name.class).getName();
        }

        public Spatial getIcon() {
            return this.icon != null ? this.icon.getNode() : null;
        }

        public String getName() {
            return "Give Badge for:" + this.name;
        }

        public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            this.place(pos, dir, rotation, value);
        }

        public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            System.out.println("GiveBadgeTool.place(" + value + ")");
            if (value) {
                return;
            }
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            if (collision == null) {
                return;
            }
            Node parent = this.selector.findEntityParent(collision.getGeometry());
            Long id = (Long)parent.getUserData("id");
            log.info((Object)("Selected id:" + id));
            Vector3f p = collision.getContactPoint().clone();
            float t = p.y;
            p.y = p.z;
            p.z = t;
            ObjectParameter parm = new ObjectParameter(new EntityId(id), p);
            if (!"Avatar".equals(parent.getUserData("type"))) {
                this.selector.getGameClient().execute("Alternate Action", new EntityId(id), parm);
                return;
            }
            if ("Avatar".equals(parent.getUserData("type"))) {
                this.selector.getGameClient().execute("Give Badge", this.claim.getId(), parm);
            }
        }

        public boolean isCapturingView() {
            return ClaimsGroup.this.defaultClaimTool.isCapturingView();
        }

        public boolean showBlockSelection() {
            return false;
        }

        public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
            ClaimsGroup.this.defaultClaimTool.viewMoved(pos, dir, rotation);
        }
    }

    protected class GivePlotTool
    implements Tool {
        private ObjectSelector selector;
        private Entity claim;
        private String name;
        private BlockObject icon;
        private ClaimType type;

        public GivePlotTool(Entity claim) {
            this.claim = claim;
            this.name = claim.get(Name.class).getName();
            this.type = claim.get(ClaimType.class);
        }

        public void initialize(ObjectSelector selector) {
            this.selector = selector;
            switch (this.type.getClaimType()) {
                case 1: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.stronghold);
                    break;
                }
                case 3: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.city);
                    break;
                }
                case 2: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.town);
                }
            }
        }

        public void update() {
            this.name = this.claim.get(Name.class).getName();
        }

        public Spatial getIcon() {
            return this.icon != null ? this.icon.getNode() : null;
        }

        public String getName() {
            return "Give Plot for:" + this.name;
        }

        public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            ClaimsGroup.this.defaultClaimTool.select(pos, dir, rotation, value);
        }

        public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            if (value) {
                return;
            }
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            if (collision == null) {
                return;
            }
            Node parent = this.selector.findEntityParent(collision.getGeometry());
            Long id = (Long)parent.getUserData("id");
            log.info((Object)("Selected id:" + id));
            Vector3f p = collision.getContactPoint().clone();
            float t = p.y;
            p.y = p.z;
            p.z = t;
            ObjectParameter parm = new ObjectParameter(new EntityId(id), p);
            if (!"Avatar".equals(parent.getUserData("type"))) {
                this.selector.getGameClient().execute("Alternate Action", new EntityId(id), parm);
                return;
            }
            if ("Avatar".equals(parent.getUserData("type"))) {
                this.selector.getGameClient().execute("Give Plot", this.claim.getId(), parm);
            }
        }

        public boolean isCapturingView() {
            return ClaimsGroup.this.defaultClaimTool.isCapturingView();
        }

        public boolean showBlockSelection() {
            return false;
        }

        public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
            ClaimsGroup.this.defaultClaimTool.viewMoved(pos, dir, rotation);
        }
    }

    protected class CreatePlotTool
    implements Tool {
        private ObjectSelector selector;
        private Entity claim;
        private String name;
        private BlockObject icon;
        private ClaimType type;

        public CreatePlotTool(Entity claim) {
            this.claim = claim;
            this.name = claim.get(Name.class).getName();
            this.type = claim.get(ClaimType.class);
        }

        public void initialize(ObjectSelector selector) {
            this.selector = selector;
            switch (this.type.getClaimType()) {
                case 1: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.stronghold);
                    break;
                }
                case 3: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.city);
                    break;
                }
                case 2: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.town);
                }
            }
        }

        public void update() {
            this.name = this.claim.get(Name.class).getName();
        }

        public Spatial getIcon() {
            return this.icon != null ? this.icon.getNode() : null;
        }

        public String getName() {
            return "Create Plot for:" + this.name;
        }

        public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            ClaimsGroup.this.defaultClaimTool.select(pos, dir, rotation, value);
        }

        public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            if (value) {
                return;
            }
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            if (collision != null) {
                Node parent = this.selector.findEntityParent(collision.getGeometry());
                Long id = (Long)parent.getUserData("id");
                log.info((Object)("Selected id:" + id));
                Vector3f p = collision.getContactPoint().clone();
                float t = p.y;
                p.y = p.z;
                p.z = t;
                ObjectParameter parm = new ObjectParameter(new EntityId(id), p);
                this.selector.getGameClient().execute("Alternate Action", new EntityId(id), parm);
                return;
            }
            WorldIntersector.Intersection hit = this.selector.intersectWorld(pos, dir, new Integer[0]);
            if (hit == null) {
                return;
            }
            Vector3i block = hit.getBlock();
            int side = hit.getSide();
            Vector3f point = hit.getPoint();
            System.out.println("place:" + point);
            BlockParameter parm = new BlockParameter(point, block, side);
            this.selector.getGameClient().execute("Create Plot", this.claim.getId(), parm);
        }

        public boolean isCapturingView() {
            return ClaimsGroup.this.defaultClaimTool.isCapturingView();
        }

        public boolean showBlockSelection() {
            return false;
        }

        public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
            ClaimsGroup.this.defaultClaimTool.viewMoved(pos, dir, rotation);
        }
    }

    protected class PlaceClaimTool
    implements Tool {
        private ObjectSelector selector;
        private Entity claim;
        private String name;
        private BlockObject icon;
        private ClaimType type;

        public PlaceClaimTool(Entity claim) {
            this.claim = claim;
            this.name = claim.get(Name.class).getName();
            this.type = claim.get(ClaimType.class);
        }

        public void initialize(ObjectSelector selector) {
            this.selector = selector;
            switch (this.type.getClaimType()) {
                case 1: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.stronghold);
                    break;
                }
                case 3: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.city);
                    break;
                }
                case 2: {
                    this.icon = ClaimsGroup.this.createIcon(ClaimsGroup.this.town);
                }
            }
        }

        public void update() {
            this.name = this.claim.get(Name.class).getName();
        }

        public Spatial getIcon() {
            return this.icon != null ? this.icon.getNode() : null;
        }

        public String getName() {
            return "Place Property:" + this.name;
        }

        public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            ClaimsGroup.this.defaultClaimTool.select(pos, dir, rotation, value);
        }

        public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            if (value) {
                return;
            }
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            if (collision != null) {
                Node parent = this.selector.findEntityParent(collision.getGeometry());
                Long id = (Long)parent.getUserData("id");
                log.info((Object)("Selected id:" + id));
                Vector3f p = collision.getContactPoint().clone();
                float t = p.y;
                p.y = p.z;
                p.z = t;
                ObjectParameter parm = new ObjectParameter(new EntityId(id), p);
                this.selector.getGameClient().execute("Alternate Action", new EntityId(id), parm);
                return;
            }
            WorldIntersector.Intersection hit = this.selector.intersectWorld(pos, dir, new Integer[0]);
            if (hit == null) {
                return;
            }
            Vector3i block = hit.getBlock();
            int side = hit.getSide();
            Vector3f point = hit.getPoint();
            System.out.println("place:" + point);
            BlockParameter parm = new BlockParameter(point, block, side);
            this.selector.getGameClient().execute("Place Claim", this.claim.getId(), parm);
        }

        public boolean isCapturingView() {
            return ClaimsGroup.this.defaultClaimTool.isCapturingView();
        }

        public boolean showBlockSelection() {
            return false;
        }

        public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
            ClaimsGroup.this.defaultClaimTool.viewMoved(pos, dir, rotation);
        }
    }

    protected class ClaimTool
    implements Tool {
        private ObjectSelector selector;
        private String name;
        private Node heldNode = null;
        private float heldDistance = 0.0f;
        private Vector3f heldOffset = null;
        private float angleOffset = 0.0f;
        private Quaternion rotDelta;
        private Vector3f lastPos = null;
        private Vector3f lastDir = null;
        private long lastTime = -1L;

        public ClaimTool(String name) {
            this.name = name;
        }

        public void initialize(ObjectSelector selector) {
            this.selector = selector;
        }

        public void update() {
        }

        public Spatial getIcon() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            System.out.println("ClaimTool.selectObject(" + value + ")");
            if (!value) {
                log.info((Object)("Dropping:" + this.heldNode));
                System.out.println("Dropping:" + this.heldNode);
                this.heldNode = null;
                return;
            }
            System.out.println("intersect:" + pos + ", " + dir);
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            System.out.println("collisions:" + collision);
            if (collision == null) {
                return;
            }
            Node parent = this.selector.findEntityParent(collision.getGeometry());
            Long id = (Long)parent.getUserData("id");
            DragControl dragger = (DragControl)parent.getControl(DragControl.class);
            System.out.println("Dragger:" + dragger);
            if (dragger != null) {
                Position entityPos = dragger.getPosition();
                if (entityPos == null) {
                    System.out.println("Clicked entity has no position?:" + parent);
                    return;
                }
                System.out.println("--------------- dragging:" + parent + " at position:" + entityPos + "   camera at:" + pos);
                this.heldNode = parent;
                this.heldDistance = collision.getDistance();
                Vector3f relativePos = entityPos.getLocation().subtract(pos);
                Vector3f contact = collision.getContactPoint();
                this.heldOffset = new Vector3f(relativePos.x - contact.x, relativePos.y - contact.z, relativePos.z - contact.y);
                Quaternion rot = entityPos.getRotation();
                float[] objAngles = rot.toAngles(new float[3]);
                float[] us = rotation.toAngles(new float[3]);
                log.debug((Object)("angles:" + objAngles[0] + ", " + objAngles[1] + ", " + objAngles[2]));
                log.debug((Object)("us:" + us[0] + ", " + us[1] + ", " + us[2]));
                this.angleOffset = objAngles[1] - us[1];
            }
        }

        public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
            if (value) {
                return;
            }
            CollisionResult collision = this.selector.intersectObjects(pos, dir);
            if (collision != null) {
                Node parent = this.selector.findEntityParent(collision.getGeometry());
                Long id = (Long)parent.getUserData("id");
                log.info((Object)("Selected id:" + id));
                Vector3f p = collision.getContactPoint().clone();
                float t = p.y;
                p.y = p.z;
                p.z = t;
                ObjectParameter parm = new ObjectParameter(new EntityId(id), p);
                this.selector.getGameClient().execute("Alternate Action", new EntityId(id), parm);
                return;
            }
        }

        public boolean showBlockSelection() {
            return false;
        }

        public boolean isCapturingView() {
            return this.heldNode != null;
        }

        public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
            BlockType bt;
            if (this.heldNode == null) {
                return;
            }
            long time = System.currentTimeMillis();
            if (time < this.lastTime + 50L) {
                return;
            }
            this.lastTime = time;
            if (pos.equals((Object)this.lastPos) && dir.equals((Object)this.lastDir)) {
                return;
            }
            this.lastPos = pos.clone();
            this.lastDir = dir.clone();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Moving:" + this.heldNode));
            }
            Vector3f projected = dir.mult(this.heldDistance);
            projected.addLocal(this.selector.getLocation());
            projected.addLocal(this.heldOffset);
            int type = this.selector.getWorld().getType(projected.x, projected.y, projected.z, null);
            while (type != 0 && (bt = BlockTypeIndex.types[type]).isSolid(4)) {
                projected.z = (float)Math.floor((double)projected.z + 1.0);
                type = this.selector.getWorld().getType(projected.x, projected.y, projected.z, null);
            }
            float[] angles = rotation.toAngles(null);
            float angle = angles[1] + this.angleOffset;
            Quaternion targetRotation = new Quaternion().fromAngleAxis(angle, new Vector3f(0.0f, 1.0f, 0.0f));
            if (this.heldNode != null) {
                ((DragControl)this.heldNode.getControl(DragControl.class)).setPosition(new Position(projected.clone(), targetRotation.clone()));
            }
        }
    }
}

