/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.bm;

import com.jme3.app.state.AppStateManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.World;
import mythruna.client.GameClient;
import mythruna.client.ModeManager;
import mythruna.client.WorldIntersector;
import mythruna.client.bm.ActionTool;
import mythruna.client.bm.BlockTool;
import mythruna.client.bm.ClaimsGroup;
import mythruna.client.bm.ObjectToolGroup;
import mythruna.client.bm.Tool;
import mythruna.client.bm.ToolGroup;
import mythruna.client.view.DragControl;
import mythruna.client.view.LocalArea;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;
import mythruna.script.ActionReference;
import mythruna.script.ToolActions;
import org.progeeks.util.log.Log;

public class ObjectSelector
implements AnalogListener,
ActionListener {
    static Log log = Log.getLog();
    private static final String ADJUST_ITEM = "Adjust Sub-type";
    private static final String ITEM_UP = "Item Up";
    private static final String ITEM_DOWN = "Item Down";
    private static final String TYPE_UP = "Type Up";
    private static final String TYPE_DOWN = "Type Down";
    private GameClient gameClient;
    private AppStateManager stateManager;
    private InputManager inputManager;
    private World world;
    private List<ToolGroup> toolGroups = new ArrayList<ToolGroup>();
    private ObjectToolGroup objectTools;
    private ClaimsGroup claimTools;
    private List<ToolGroup> dynamicGroups = new ArrayList<ToolGroup>();
    private ToolActions lastActions;
    private int group = 0;
    private int type = 0;
    private boolean typeDebounce = false;
    private Tool lastTool = null;
    private LocalArea localArea;
    private EntityId heldEntity = null;
    private float heldDistance = 0.0f;
    private Vector3f heldOffset = null;
    private float angleOffset = 0.0f;
    private Quaternion rotDelta;
    private boolean oldWay = true;
    private boolean enabled = true;

    public ObjectSelector(GameClient gameClient, InputManager inputManager, AppStateManager stateManager) {
        if (gameClient == null) {
            throw new IllegalArgumentException("GameClient cannot be null.");
        }
        this.gameClient = gameClient;
        this.world = gameClient.getWorld();
        this.stateManager = stateManager;
        this.inputManager = inputManager;
        this.registerWithInput();
        for (BlockTypeIndex.BlockGroup bg : BlockTypeIndex.groups()) {
            this.toolGroups.add(this.createBlockToolGroup(bg));
        }
        this.objectTools = new ObjectToolGroup("Object Mode");
        this.toolGroups.add(this.objectTools);
        this.claimTools = new ClaimsGroup();
        this.toolGroups.add(this.claimTools);
        for (ToolGroup tg : this.toolGroups) {
            tg.initialize(this);
        }
        if (!this.toolGroups.isEmpty()) {
            this.toolGroups.get(0).setVisible(true);
        }
    }

    public void setEnabled(boolean f) {
        if (this.enabled == f) {
            return;
        }
        this.enabled = f;
        if (this.enabled) {
            this.registerWithInput();
        } else {
            this.unregisterInput();
        }
    }

    protected ToolGroup createBlockToolGroup(BlockTypeIndex.BlockGroup bg) {
        ToolGroup g = new ToolGroup(bg.getName());
        for (BlockType type : bg.getTypes()) {
            g.getTools().add(new BlockTool(type));
        }
        return g;
    }

    protected void loadDynamicTools() {
        EntityData ed = this.world.getEntityData();
        ToolActions ta = ed.getComponent(this.gameClient.getPlayer(), ToolActions.class);
        if (ta == null) {
            System.out.println("No tool actions found yet.  Will try again next frame.");
            return;
        }
        System.out.println("Tool actions:" + ta);
        this.lastActions = ta;
        for (ActionReference ar : ta.getActions()) {
            System.out.println("Adding tool for:" + ar);
            ToolGroup g = this.getGroup(ar.getGroup());
            if (g == null) {
                g = new ToolGroup(ar.getGroup());
                this.dynamicGroups.add(g);
                this.toolGroups.add(g);
            }
            ActionTool t = new ActionTool(ar);
            g.getTools().add(t);
        }
        for (ToolGroup tg : this.dynamicGroups) {
            System.out.println("Initializing:" + tg + "  containing tools:" + tg.getTools());
            tg.initialize(this);
        }
    }

    public void update() {
        if (this.lastActions == null && this.dynamicGroups.isEmpty()) {
            this.loadDynamicTools();
        }
        if (this.objectTools.update()) {
            this.type = Math.min(this.type, this.getGroupSize(this.group) - 1);
            this.lastTool = null;
        }
        if (this.claimTools != null && this.claimTools.update()) {
            this.type = Math.min(this.type, this.getGroupSize(this.group) - 1);
            this.lastTool = null;
        }
    }

    public void setLocalArea(LocalArea localArea) {
        this.localArea = localArea;
    }

    public World getWorld() {
        return this.world;
    }

    public LocalArea getLocalArea() {
        return this.localArea;
    }

    public GameClient getGameClient() {
        return this.gameClient;
    }

    public Vector3f getLocation() {
        return this.localArea.getLocation();
    }

    public AppStateManager getStateManager() {
        return this.stateManager;
    }

    public String getLabel() {
        return this.getSelectedTool().getName();
    }

    public Spatial getIcon() {
        Spatial icon = this.getSelectedTool().getIcon();
        if (icon == null) {
            icon = this.getToolGroup(this.group).getIcon();
        }
        return icon;
    }

    public Tool getSelectedTool() {
        if (this.lastTool != null) {
            return this.lastTool;
        }
        ToolGroup tg = this.getToolGroup(this.group);
        if (tg.getTools().size() == 0) {
            return null;
        }
        this.lastTool = tg.getTools().get(this.type);
        return this.lastTool;
    }

    public ToolGroup getToolGroup(int index) {
        return this.toolGroups.get(index);
    }

    protected ToolGroup getGroup(String name) {
        for (ToolGroup tg : this.toolGroups) {
            if (!tg.getName().equals(name)) continue;
            return tg;
        }
        return null;
    }

    protected int getGroupSize(int index) {
        return this.getToolGroup(index).getTools().size();
    }

    protected void registerWithInput() {
        this.inputManager.addMapping(ADJUST_ITEM, new Trigger[]{new KeyTrigger(29)});
        this.inputManager.addMapping(TYPE_UP, new Trigger[]{new KeyTrigger(52)});
        this.inputManager.addMapping(TYPE_DOWN, new Trigger[]{new KeyTrigger(51)});
        this.inputManager.addListener((InputListener)this, new String[]{ADJUST_ITEM, TYPE_UP, TYPE_DOWN});
        ModeManager.instance.addMode(ADJUST_ITEM, ITEM_UP, ITEM_DOWN, this);
        ModeManager.instance.setDefaultMode(TYPE_UP, TYPE_DOWN, this);
    }

    protected void unregisterInput() {
        if (this.inputManager.hasMapping(ADJUST_ITEM)) {
            this.inputManager.deleteMapping(ADJUST_ITEM);
        }
        if (this.inputManager.hasMapping(TYPE_UP)) {
            this.inputManager.deleteMapping(TYPE_UP);
        }
        if (this.inputManager.hasMapping(TYPE_DOWN)) {
            this.inputManager.deleteMapping(TYPE_DOWN);
        }
        this.inputManager.removeListener((InputListener)this);
        ModeManager.instance.removeMode(ADJUST_ITEM);
        ModeManager.instance.clearDefaultMode(TYPE_UP, TYPE_DOWN);
    }

    public void onAnalog(String name, float value, float tpf) {
        if (this.isCapturingView()) {
            return;
        }
        try {
            if (ModeManager.instance.isActive(ADJUST_ITEM)) {
                if (name.equals(TYPE_UP)) {
                    name = ITEM_UP;
                } else if (name.equals(TYPE_DOWN)) {
                    name = ITEM_DOWN;
                }
            }
            if (ITEM_UP.equals(name) && !this.typeDebounce) {
                ++this.type;
                if (this.type >= this.getGroupSize(this.group)) {
                    this.type = 0;
                }
            } else if (ITEM_DOWN.equals(name) && !this.typeDebounce) {
                --this.type;
                if (this.type < 0) {
                    this.type = Math.max(0, this.getGroupSize(this.group) - 1);
                }
            } else if (TYPE_UP.equals(name) && !this.typeDebounce) {
                this.setGroup(this.group + 1);
            } else if (TYPE_DOWN.equals(name) && !this.typeDebounce) {
                this.setGroup(this.group - 1);
            } else if (ADJUST_ITEM.equals(name)) {
                return;
            }
            this.lastTool = null;
        }
        catch (RuntimeException e) {
            log.error((Object)("Error processing input:" + name), (Throwable)e);
        }
    }

    protected void setGroup(int newGroup) {
        if (this.group == newGroup) {
            return;
        }
        if (this.group < this.toolGroups.size()) {
            this.toolGroups.get(this.group).setVisible(false);
        }
        this.group = newGroup;
        if (this.group >= this.toolGroups.size()) {
            this.group = 0;
        }
        if (this.group < 0) {
            this.group = this.toolGroups.size() - 1;
        }
        this.toolGroups.get(this.group).setVisible(true);
        this.type = Math.max(0, Math.min(this.type, this.getGroupSize(this.group) - 1));
        this.lastTool = null;
    }

    public void onAction(String name, boolean value, float tpf) {
        try {
            if (ADJUST_ITEM.equals(name)) {
                if (value && ModeManager.instance.getMode() == null) {
                    ModeManager.instance.setMode(ADJUST_ITEM, value);
                } else if (!value) {
                    ModeManager.instance.setMode(ADJUST_ITEM, value);
                }
            } else if (TYPE_UP.equals(name)) {
                this.typeDebounce = value;
            } else if (TYPE_DOWN.equals(name)) {
                this.typeDebounce = value;
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("Error processing input:" + name), (Throwable)e);
        }
    }

    protected Spatial createBlockIcon(BlockType type) {
        GeomFactory gf = type.getGeomFactory();
        GeomPartBuffer buffer = new GeomPartBuffer();
        for (int i = 0; i < 6; ++i) {
            gf.createGeometry(buffer, 0, 0, 0, 0, 0, 0, 1.0f, 0.5f, type, i);
        }
        gf.createInternalGeometry(buffer, 0, 0, 0, 0, 0, 0, 1.0f, 0.5f, type);
        Node node = buffer.createNode("Icon:" + type.getName());
        node.setLocalTranslation(-0.5f, -0.5f, -0.5f);
        return node;
    }

    public boolean isCapturingView() {
        return this.getSelectedTool().isCapturingView();
    }

    public boolean showBlockSelection() {
        return this.getSelectedTool().showBlockSelection();
    }

    protected WorldIntersector.Intersection intersectWorld(Vector3f pos, Vector3f dir, Integer ... skipTypes) {
        WorldIntersector.Intersection hit;
        block0: {
            WorldIntersector.Intersection isect;
            Ray ray = new Ray(pos, dir);
            ray.setLimit(10.0f);
            WorldIntersector wi = new WorldIntersector(this.localArea, ray, skipTypes);
            hit = null;
            if (!wi.hasNext()) break block0;
            hit = isect = wi.next();
        }
        return hit;
    }

    public void viewMoved(Vector3f pos, Vector3f dir, Quaternion rotation) {
        this.getSelectedTool().viewMoved(pos, dir, rotation);
    }

    protected CollisionResult intersectObjects(Vector3f pos, Vector3f dir) {
        WorldIntersector.Intersection hit = this.intersectWorld(pos, dir, new Integer[0]);
        return this.intersectObjects(pos, dir, hit);
    }

    public Node findEntityParent(Geometry g) {
        for (Node n = g.getParent(); n != null; n = n.getParent()) {
            if (n.getUserData("id") == null) continue;
            return n;
        }
        return null;
    }

    protected CollisionResult intersectObjects(Vector3f pos, Vector3f dir, WorldIntersector.Intersection limit) {
        Ray ray = new Ray(pos.clone(), dir.clone());
        if (limit != null) {
            Vector3f delta = limit.getPoint().subtract(pos);
            ray.setLimit(delta.length());
        }
        long start = System.nanoTime();
        CollisionResults results = new CollisionResults();
        ray.origin = new Vector3f(0.0f, 0.0f, 0.0f);
        float y = ray.direction.z;
        ray.direction.z = ray.direction.y;
        ray.direction.y = y;
        LocalArea target = this.localArea;
        target.updateGeometricState();
        target.collideWith((Collidable)ray, results);
        long end = System.nanoTime();
        log.debug((Object)("Collided in:" + (double)(end - start) / 1000000.0 + " ms"));
        log.debug((Object)("Collision count:" + results.size()));
        for (int i = 0; i < results.size(); ++i) {
            float d = results.getCollision(i).getDistance();
            Node parent = this.findEntityParent(results.getCollision(i).getGeometry());
            if (parent == null) {
                System.out.println("No ID'ed parent found for:" + results.getCollision(i).getGeometry());
                continue;
            }
            Long id = (Long)parent.getUserData("id");
            if (id == null && parent.getControl(DragControl.class) == null) continue;
            log.info((Object)("Selected id:" + id));
            return results.getCollision(i);
        }
        return null;
    }

    public void selectBlockType(Vector3f pos, Vector3f dir, Quaternion rotation) {
        WorldIntersector.Intersection hit = this.intersectWorld(pos, dir, new Integer[0]);
        if (hit == null) {
            return;
        }
        log.debug((Object)("hit type:" + hit.getType()));
        if (hit.getType() <= 0) {
            return;
        }
        BlockType blockType = BlockTypeIndex.types[hit.getType()];
        int groupIndex = 0;
        for (BlockTypeIndex.BlockGroup g : BlockTypeIndex.groups()) {
            int typeIndex = 0;
            for (BlockType t : g.getTypes()) {
                if (t == blockType) {
                    this.group = groupIndex;
                    this.type = typeIndex;
                    this.lastTool = null;
                    break;
                }
                ++typeIndex;
            }
            ++groupIndex;
        }
    }

    public void select(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
        this.getSelectedTool().select(pos, dir, rotation, value);
    }

    public void place(Vector3f pos, Vector3f dir, Quaternion rotation, boolean value) {
        this.getSelectedTool().place(pos, dir, rotation, value);
    }
}

