/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.env;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.List;
import mythruna.GameTime;
import mythruna.MaterialIndex;
import mythruna.client.GameClient;
import mythruna.client.env.CloudLayer;
import mythruna.client.env.ColorRangeEffect;
import mythruna.client.env.FloatRangeEffect;
import mythruna.client.env.Ground;
import mythruna.client.env.RangeEffect;
import mythruna.client.env.Sky;
import mythruna.client.env.StarMesh;
import mythruna.client.env.TimeEffect;
import mythruna.client.env.Vector4fRangeEffect;
import mythruna.client.ui.ObservableState;

public class Environment
extends ObservableState {
    private static Environment instance = new Environment();
    private GameClient gameClient;
    private int effectRate = 100;
    private int lastEffectTime = -1;
    private List<TimeEffect> timeEffects = new ArrayList<TimeEffect>();
    private Geometry skyGeom;
    private Geometry groundGeom;
    private DirectionalLight sun;
    private Geometry lightSphere;
    private Geometry moonGeom;
    private Node moonNode;
    private Geometry starGeometry;
    private Spatial clouds;
    private Spatial clouds2;
    private Node flareNode;
    private Geometry flare;
    private Material flareMaterial;
    private ColorRGBA flareColor;
    private Vector3f lightPos = new Vector3f();
    private ColorRGBA cloudColor;
    private ColorRGBA waterColor = new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f);
    private ColorRGBA ambient = ColorRGBA.DarkGray.clone();
    private ColorRGBA diffuse = ColorRGBA.White.clone();
    private ColorRGBA specular = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private ColorRGBA fogColor = new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f);
    private float fogDistance = 128.0f;

    public Environment() {
        super("Environment", true);
    }

    public static Environment getInstance() {
        return instance;
    }

    public void setGameClient(GameClient client) {
        this.gameClient = client;
    }

    protected void initialize(Application app) {
        super.initialize(app);
        Node rootNode = ((SimpleApplication)app).getRootNode();
        AssetManager assetManager = app.getAssetManager();
        this.addTimeEffect(new SunArc());
        this.addTimeEffect(new MoonArc());
        Sky sky = new Sky(24, 24);
        this.skyGeom = sky.getGeometry();
        Material skyMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        Texture skyTexture = assetManager.loadTexture("Textures/sky-colors.png");
        skyMaterial.setTexture("ColorMap", skyTexture);
        this.skyGeom.setMaterial(skyMaterial);
        rootNode.attachChild((Spatial)this.skyGeom);
        sky.setEastWest(1.0f, 1.0f, 1.0f);
        StarMesh stars = new StarMesh(20.0f, 1000);
        this.starGeometry = new Geometry("Stars", (Mesh)stars);
        final Material starMaterial = new Material(assetManager, "MatDefs/MyParticle.j3md");
        starMaterial.setBoolean("PointSprite", true);
        starMaterial.setTexture("Texture", assetManager.loadTexture("Textures/Smoke.png"));
        this.starGeometry.setMaterial(starMaterial);
        this.starGeometry.setCullHint(Spatial.CullHint.Never);
        this.starGeometry.setQueueBucket(RenderQueue.Bucket.Sky);
        this.starGeometry.setShadowMode(RenderQueue.ShadowMode.Off);
        float quadratic = (float)app.getCamera().getHeight() / 720.0f * 6.0f;
        starMaterial.setFloat("Quadratic", quadratic);
        rootNode.attachChild((Spatial)this.starGeometry);
        this.addTimeEffect(new FloatRangeEffect(new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.3f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}){

            protected void update(Float value) {
                starMaterial.setFloat("Alpha", value.floatValue());
            }
        });
        this.sun = new DirectionalLight();
        Vector3f lightDir = new Vector3f(-0.37352666f, -0.50444174f, -0.7784704f);
        this.sun.setDirection(lightDir);
        this.sun.setColor(new ColorRGBA(1.5f, 1.5f, 1.5f, 1.0f));
        rootNode.addLight((Light)this.sun);
        boolean useFlare = true;
        Material sunMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        if (useFlare) {
            sunMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f));
        } else {
            sunMaterial.setColor("Color", new ColorRGBA(0.95f, 0.9f, 0.6f, 1.0f));
        }
        Sphere lite = useFlare ? new Sphere(30, 30, 30.0f) : new Sphere(30, 30, 30.0f);
        this.lightSphere = new Geometry("lightsphere", (Mesh)lite);
        this.lightSphere.setMaterial(sunMaterial);
        Vector3f lightPos = lightDir.clone().multLocal(-500.0f);
        this.lightSphere.setLocalTranslation(lightPos);
        if (useFlare) {
            this.lightSphere.setLocalScale(0.7f);
        }
        this.lightSphere.setQueueBucket(RenderQueue.Bucket.Sky);
        this.lightSphere.setCullHint(Spatial.CullHint.Never);
        float flareSize = 300.0f;
        Quad flareQuad = new Quad(flareSize, flareSize);
        this.flare = new Geometry("flare", (Mesh)flareQuad);
        this.flareMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.flareColor = new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f);
        this.flareMaterial.setColor("Color", this.flareColor);
        this.flareMaterial.setTexture("ColorMap", assetManager.loadTexture("Textures/sun-256.png"));
        this.flareMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.flare.setMaterial(this.flareMaterial);
        this.flare.setLocalTranslation(-(flareSize * 0.5f), -(flareSize * 0.5f), 0.0f);
        this.flareNode = new Node("Flare Node");
        this.flareNode.setLocalTranslation(lightPos);
        this.flareNode.attachChild((Spatial)this.flare);
        this.flareNode.setQueueBucket(RenderQueue.Bucket.Sky);
        this.flareNode.setCullHint(Spatial.CullHint.Never);
        this.flareNode.addControl((Control)new BillboardControl());
        if (useFlare) {
            rootNode.attachChild((Spatial)this.flareNode);
        }
        rootNode.attachChild((Spatial)this.lightSphere);
        Texture moonTexture = assetManager.loadTexture("Textures/moon2.png");
        Material moonMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        moonMaterial.setTexture("ColorMap", moonTexture);
        moonMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        final ColorRGBA moonColor = ColorRGBA.White.clone();
        moonMaterial.setColor("Color", moonColor);
        Sphere moonMesh = new Sphere(20, 20, 1.25f);
        this.moonGeom = new Geometry("moon", (Mesh)moonMesh);
        moonMesh.setTextureMode(Sphere.TextureMode.Polar);
        this.moonGeom.setMaterial(moonMaterial);
        this.moonGeom.setQueueBucket(RenderQueue.Bucket.Sky);
        this.moonGeom.setCullHint(Spatial.CullHint.Never);
        this.moonNode = new Node("MoonNode");
        this.moonNode.attachChild((Spatial)this.moonGeom);
        this.moonNode.setLocalTranslation(new Vector3f(0.0f, 200.0f, 0.0f));
        int starIndex = rootNode.getChildIndex((Spatial)this.starGeometry);
        rootNode.attachChildAt((Spatial)this.moonNode, starIndex);
        this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.6f, 0.5f, 0.4f, 1.0f), new ColorRGBA(1.2f, 0.9f, 0.8f, 1.0f), new ColorRGBA(1.4f, 1.1f, 0.9f, 1.0f), new ColorRGBA(1.4f, 1.3f, 1.1f, 1.0f), new ColorRGBA(1.4f, 1.3f, 1.2f, 1.0f), new ColorRGBA(1.3f, 1.3f, 1.2f, 1.0f), new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f), new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f), new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f), new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f), new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f), new ColorRGBA(1.3f, 1.3f, 1.2f, 1.0f), new ColorRGBA(1.4f, 1.3f, 1.2f, 1.0f), new ColorRGBA(1.4f, 1.2f, 0.9f, 1.0f), new ColorRGBA(1.3f, 1.1f, 0.8f, 1.0f), new ColorRGBA(0.6f, 0.5f, 0.4f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f)}){

            protected void update(ColorRGBA value) {
                Environment.this.sun.setColor(value);
                float min = 0.9f;
                float max = 1.1f;
                float delta = max - min;
                float scale = (1.4f - value.r) / 1.3f;
                float colorScale = min + delta * scale;
                moonColor.r = colorScale = Math.max(1.0f, colorScale);
                moonColor.g = colorScale;
                moonColor.b = colorScale;
                moonColor.a = Math.min(1.0f, scale * scale);
            }
        });
        this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.95f, 0.9f, 0.7f, 0.2f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.2f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.2f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.2f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.2f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.5f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.5f), new ColorRGBA(0.95f, 0.9f, 0.8f, 0.7f), new ColorRGBA(0.95f, 0.9f, 0.6f, 0.7f), new ColorRGBA(0.95f, 0.9f, 0.6f, 0.7f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f), new ColorRGBA(0.95f, 0.9f, 0.7f, 0.8f), new ColorRGBA(0.95f, 0.9f, 0.6f, 0.7f), new ColorRGBA(0.95f, 0.9f, 0.5f, 0.65f), new ColorRGBA(0.95f, 0.9f, 0.5f, 0.65f), new ColorRGBA(0.95f, 0.85f, 0.55f, 0.65f), new ColorRGBA(0.95f, 0.7f, 0.55f, 0.9f), new ColorRGBA(0.95f, 0.7f, 0.55f, 0.9f), new ColorRGBA(0.95f, 0.6f, 0.55f, 0.2f), new ColorRGBA(0.95f, 0.6f, 0.55f, 0.2f), new ColorRGBA(0.95f, 0.6f, 0.55f, 0.2f)}){

            protected void update(ColorRGBA value) {
                Environment.this.flareColor.set(value);
            }
        });
        this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.1f, 0.0f, 0.2f, 1.0f), new ColorRGBA(0.2f, 0.2f, 0.3f, 1.0f), new ColorRGBA(0.3f, 0.3f, 0.4f, 1.0f), new ColorRGBA(0.8f, 0.8f, 0.7f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f), new ColorRGBA(0.9f, 0.8f, 0.7f, 1.0f), new ColorRGBA(0.2f, 0.2f, 0.4f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f)}){

            protected void update(ColorRGBA value) {
                value.a = Environment.this.fogDistance;
                MaterialIndex.setFogColor(value);
            }
        });
        this.addTimeEffect(new Vector4fRangeEffect(new Vector4f[]{new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.5f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)}){

            protected void update(Vector4f value) {
                MaterialIndex.setTimeParms(value);
            }
        });
        boolean cloudsOn = true;
        if (cloudsOn) {
            this.addTimeEffect(new CloudArc());
            long baseSeed = 100L;
            CloudLayer cloudLayer = new CloudLayer(baseSeed, 20, 40.0f, 80.0f, 100.0f);
            Mesh cloudMesh = cloudLayer.createMesh();
            CloudLayer cloudLayer2 = new CloudLayer(baseSeed + 1L, 20, 40.0f, 80.0f, 100.0f);
            Mesh cloudMesh2 = cloudLayer2.createMesh();
            Geometry cloudGeometry1 = new Geometry("Cloud1", cloudMesh);
            Geometry cloudGeometry2 = new Geometry("Cloud2", cloudMesh2);
            Material cloudMat = new Material(assetManager, "MatDefs/Cloud.j3md");
            this.cloudColor = new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f);
            cloudMat.setColor("Color", this.cloudColor);
            Texture tex = assetManager.loadTexture("Textures/cloud-atlas-smaller.png");
            cloudMat.setTexture("ColorMap", tex);
            cloudGeometry1.setMaterial(cloudMat);
            cloudGeometry1.setCullHint(Spatial.CullHint.Never);
            cloudGeometry1.setQueueBucket(RenderQueue.Bucket.Sky);
            cloudGeometry2.setMaterial(cloudMat);
            cloudGeometry2.setCullHint(Spatial.CullHint.Never);
            cloudGeometry2.setQueueBucket(RenderQueue.Bucket.Sky);
            rootNode.attachChild((Spatial)cloudGeometry1);
            rootNode.attachChild((Spatial)cloudGeometry2);
            this.clouds = cloudGeometry1;
            this.clouds2 = cloudGeometry2;
            this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.5f, 0.3f, 0.3f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f), new ColorRGBA(0.7f, 0.6f, 0.6f, 1.0f), new ColorRGBA(0.6f, 0.5f, 0.5f, 1.0f), new ColorRGBA(0.4f, 0.3f, 0.3f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f), new ColorRGBA(0.05f, 0.05f, 0.1f, 2.0f)}){

                protected void update(ColorRGBA value) {
                    Environment.this.cloudColor.set(value);
                }
            });
        }
        Ground ground = new Ground(24);
        this.groundGeom = ground.getGeometry();
        Material groundMat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        final ColorRGBA groundColor = new ColorRGBA(0.4f, 0.6f, 0.99f, 1.0f);
        groundMat.setColor("Color", groundColor);
        this.groundGeom.setMaterial(groundMat);
        this.groundGeom.setLocalTranslation(0.0f, -1.0f, 0.0f);
        rootNode.attachChild((Spatial)this.groundGeom);
        this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.1f, 0.0f, 0.2f, 1.0f), new ColorRGBA(0.2f, 0.2f, 0.3f, 1.0f), new ColorRGBA(0.3f, 0.3f, 0.4f, 1.0f), new ColorRGBA(0.6f, 0.6f, 0.7f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.8f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.6f, 0.7f, 0.9f, 1.0f), new ColorRGBA(0.4f, 0.4f, 0.6f, 1.0f), new ColorRGBA(0.2f, 0.2f, 0.4f, 1.0f), new ColorRGBA(0.1f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f), new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f)}){

            protected void update(ColorRGBA value) {
                groundColor.set(value);
            }
        });
        this.addTimeEffect(new ColorRangeEffect(new ColorRGBA[]{new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.2f, 0.5f, 1.0f), new ColorRGBA(0.0f, 0.1f, 0.2f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f), new ColorRGBA(0.0f, 0.01f, 0.02f, 1.0f)}){

            protected void update(ColorRGBA value) {
                Environment.this.waterColor.set(value);
            }
        });
        this.addTimeEffect(new SkyEffect(sky, new Float[][]{{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, {Float.valueOf(0.8f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, {Float.valueOf(0.7f), Float.valueOf(0.9f), Float.valueOf(1.5f)}, {Float.valueOf(0.6f), Float.valueOf(0.8f), Float.valueOf(2.25f)}, {Float.valueOf(0.5f), Float.valueOf(0.7f), Float.valueOf(2.25f)}, {Float.valueOf(0.5f), Float.valueOf(0.2f), Float.valueOf(2.5f)}, {Float.valueOf(0.3f), Float.valueOf(0.1f), Float.valueOf(2.0f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(2.0f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(2.0f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.5f)}, {Float.valueOf(0.1f), Float.valueOf(0.0f), Float.valueOf(2.0f)}, {Float.valueOf(0.3f), Float.valueOf(0.1f), Float.valueOf(2.25f)}, {Float.valueOf(0.7f), Float.valueOf(0.5f), Float.valueOf(2.5f)}, {Float.valueOf(0.9f), Float.valueOf(0.5f), Float.valueOf(2.0f)}, {Float.valueOf(0.9f), Float.valueOf(0.9f), Float.valueOf(2.0f)}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.5f)}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}}));
    }

    public void setFogDistance(float f) {
        this.fogDistance = f;
    }

    public float getFogDistance() {
        return this.fogDistance;
    }

    public ColorRGBA getWaterColor() {
        return this.waterColor;
    }

    public Vector3f getLightPosition() {
        return this.lightPos;
    }

    public void addTimeEffect(TimeEffect e) {
        this.timeEffects.add(e);
    }

    public float getTime() {
        return (float)(this.getTotalTime() % 24.0);
    }

    public double getTotalTime() {
        return this.gameClient.getGameTime() / 3600.0;
    }

    public void update(float tpf) {
        double total = this.getTotalTime();
        double dayPart = total % 24.0;
        for (TimeEffect e : this.timeEffects) {
            e.timeUpdate((float)dayPart, total);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SkyEffect
    extends RangeEffect<Float[]> {
        private Sky sky;

        public SkyEffect(Sky sky, Float[][] values) {
            super((T[])values);
            this.sky = sky;
        }

        @Override
        protected void update(Float[] value) {
            this.sky.setEastWest(value[0].floatValue(), value[1].floatValue(), value[2].floatValue());
        }

        @Override
        protected float interpolate(float val1, float val2, float ratio) {
            return val1 + (val2 - val1) * ratio;
        }

        @Override
        protected Float[] interpolate(Float[] val1, Float[] val2, float ratio) {
            Float[] last = (Float[])this.getLastValue();
            Float[] next = new Float[]{Float.valueOf(this.interpolate(val1[0].floatValue(), val2[0].floatValue(), ratio)), Float.valueOf(this.interpolate(val1[1].floatValue(), val2[1].floatValue(), ratio)), Float.valueOf(this.interpolate(val1[2].floatValue(), val2[2].floatValue(), ratio))};
            if (last != null && last[0].floatValue() == next[0].floatValue() && last[1].floatValue() == next[1].floatValue() && last[2].floatValue() == next[2].floatValue()) {
                return last;
            }
            return next;
        }
    }

    private class CloudArc
    implements TimeEffect {
        private CloudArc() {
        }

        public void timeUpdate(float hours, double totalTime) {
            double cloudDay = 11.0;
            float dayPart = (float)(totalTime % cloudDay / cloudDay);
            float angle = (float)Math.PI * 2 * dayPart + 1.5707964f;
            Vector3f cloudAxis = new Vector3f(0.5f, 0.0f, 0.5f).normalize();
            Vector3f cloudAxis2 = new Vector3f(0.4f, 0.0f, 0.5f).normalize();
            Quaternion cloudRot = new Quaternion().fromAngleAxis(angle, cloudAxis);
            Environment.this.clouds.setLocalRotation(cloudRot);
            Quaternion cloudRot2 = new Quaternion().fromAngleAxis(angle, cloudAxis2);
            Environment.this.clouds2.setLocalRotation(cloudRot2);
        }
    }

    private class MoonArc
    implements TimeEffect {
        private MoonArc() {
        }

        public void timeUpdate(float hours, double totalTime) {
            int dayOfMonth;
            float angle = (float)Math.PI * 2 * ((hours - 13.0f) / 24.0f) + 1.5707964f;
            float cos = FastMath.cos((float)angle);
            float sin = FastMath.sin((float)angle);
            Vector3f moonDir = new Vector3f(cos, sin, sin * -0.35f).normalize();
            if ((double)hours <= 4.0 || (double)hours > 21.0) {
                Environment.this.sun.setDirection(moonDir);
            }
            float moonOffset = 0.0f;
            moonDir = new Vector3f(cos, sin, 0.0f).normalize();
            Vector3f pos = moonDir.mult(-20.0f).add(0.0f, moonOffset, 0.0f);
            if ((double)hours <= 4.0 || (double)hours > 21.0) {
                Environment.this.lightPos.set(pos);
            }
            Quaternion starRot = new Quaternion().fromAngleAxis(angle, new Vector3f(0.0f, 0.0f, 1.0f));
            Environment.this.starGeometry.setLocalRotation(starRot);
            Environment.this.moonNode.setLocalTranslation(0.0f, 0.0f, 0.0f);
            Environment.this.moonGeom.setLocalTranslation(-20.0f, 0.0f, 0.0f);
            Environment.this.moonNode.setLocalTranslation(0.0f, -Math.abs(cos * cos) * 5.0f, 0.0f);
            Environment.this.moonGeom.setLocalScale(Math.max(0.65f, Math.min(1.0f, Math.abs(sin) * 1.5f)));
            double gameTime = Environment.this.gameClient.getGameTime();
            double oldTime = gameTime - 43200.0;
            int gameDay = GameTime.toGameDay(oldTime);
            int part = dayOfMonth = GameTime.dayOfMonth(gameDay);
            if (part > 14) {
                part = 28 - part;
            }
            float phaseAngle = (float)part / 28.0f * ((float)Math.PI * 2);
            Quaternion phaseRot = new Quaternion().fromAngles(0.0f, -0.5890486f, 0.0f);
            Quaternion moonRot = new Quaternion().fromAngles(0.0f, 0.0f, angle);
            Environment.this.moonNode.setLocalRotation(moonRot.mult(phaseRot));
            Quaternion faceRot = new Quaternion().fromAngles(0.0f, 0.0f, -1.5707964f);
            Quaternion faceRot2 = new Quaternion().fromAngles(0.0f, phaseAngle, 0.0f);
            Environment.this.moonGeom.setLocalRotation(faceRot2.mult(faceRot));
        }
    }

    private class SunArc
    implements TimeEffect {
        private SunArc() {
        }

        public void timeUpdate(float hours, double totalTime) {
            float angle = (float)Math.PI * 2 * ((hours - 1.0f) / 24.0f) + 1.5707964f;
            float cos = FastMath.cos((float)angle);
            float sin = FastMath.sin((float)angle);
            Vector3f lightDir = new Vector3f(cos, sin, sin * 0.25f).normalize();
            if ((double)hours > 4.0 && (double)hours <= 21.0) {
                Environment.this.sun.setDirection(lightDir);
            }
            float sunOffset = 100.0f;
            Vector3f pos = lightDir.mult(-500.0f).add(0.0f, sunOffset, 0.0f);
            Environment.this.lightSphere.setLocalTranslation(pos);
            Environment.this.flareNode.setLocalTranslation(pos);
            if ((double)hours > 4.0 && (double)hours <= 21.0) {
                Environment.this.lightPos.set(pos);
            }
        }
    }
}

