/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.env;

import mythruna.client.env.TimeEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RangeEffect<T>
implements TimeEffect {
    private T[] values;
    private T lastValue;

    public RangeEffect(T ... values) {
        this.values = values;
        if (values.length != 24) {
            throw new IllegalArgumentException("There must be 24 range values.");
        }
    }

    public T getLastValue() {
        return this.lastValue;
    }

    protected void update(T value) {
    }

    protected abstract T interpolate(T var1, T var2, float var3);

    protected void rangeUpdate(int hour1, int hour2, float ratio) {
        T val1 = this.values[hour1];
        T val2 = this.values[hour2];
        T result = this.interpolate(val1, val2, ratio);
        if (result == this.lastValue || result.equals(this.lastValue)) {
            return;
        }
        this.update(result);
        this.lastValue = result;
    }

    @Override
    public void timeUpdate(float hours, double totalTime) {
        int hour1 = (int)Math.floor(hours);
        int hour2 = hour1 + 1;
        float ratio = hours - (float)hour1;
        if (hour2 >= 24) {
            hour2 %= 24;
        }
        this.rangeUpdate(hour1, hour2, ratio);
    }
}

