/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.env;

import com.jme3.math.Quaternion;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Cylinder;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Sky {
    private static final float DEFAULT_RANGE = 2.0f;
    private int radials;
    private int slices;
    private Cylinder mesh;
    private Geometry geom;
    private float[] ranges;
    private float[] texCoords;
    private float centerTexCoord;
    private boolean valid;

    public Sky(int radials, int slices) {
        this.radials = radials;
        this.slices = slices;
        this.mesh = new Cylinder(slices, radials, 50.0f, 50.0f, true, true);
        this.ranges = new float[radials];
        for (int i = 0; i < radials; ++i) {
            this.ranges[i] = 2.0f;
        }
        this.texCoords = new float[radials];
        this.valid = false;
    }

    public Geometry getGeometry() {
        if (this.geom == null) {
            this.geom = new Geometry("sky cylinder", (Mesh)this.mesh);
            Quaternion rot = new Quaternion().fromAngles(1.5707964f, 0.0f, 0.0f);
            this.geom.setLocalRotation(rot);
            this.geom.setQueueBucket(RenderQueue.Bucket.Sky);
            this.geom.setCullHint(Spatial.CullHint.Never);
        }
        if (!this.valid) {
            this.refreshHorizon();
            this.valid = true;
        }
        return this.geom;
    }

    public void setEastWest(float east, float west, float horizon) {
        float ratio;
        int i;
        int halfRadials = this.radials / 2;
        float range = west - east;
        for (i = 0; i < halfRadials; ++i) {
            ratio = (float)(halfRadials - i) / (float)halfRadials;
            this.texCoords[i] = west + (east - west) * ratio;
            this.ranges[i] = horizon;
        }
        for (i = halfRadials; i < this.radials; ++i) {
            ratio = (float)(i - halfRadials) / (float)halfRadials;
            this.texCoords[i] = west + (east - west) * ratio;
            this.ranges[i] = horizon;
        }
        this.centerTexCoord = (west + east) / 2.0f;
        this.refreshHorizon();
    }

    protected void refreshHorizon() {
        FloatBuffer tb = this.mesh.getFloatBuffer(VertexBuffer.Type.TexCoord);
        tb.clear();
        for (int slice = 0; slice < this.slices; ++slice) {
            float ratio = (float)slice / (float)(this.slices - 1);
            for (int radial = 0; radial < this.radials; ++radial) {
                float t = 1.0f - ratio * this.ranges[radial];
                if (t < 0.0f) {
                    t = 0.0f;
                }
                tb.put(this.texCoords[radial]);
                tb.put(t);
            }
            tb.put(this.texCoords[0]);
            float t = 1.0f - ratio * this.ranges[0];
            if (t < 0.0f) {
                t = 0.0f;
            }
            tb.put(t);
        }
        tb.put(this.centerTexCoord).put(1.0f);
        tb.put(this.centerTexCoord).put(0.0f);
        VertexBuffer vBuff = this.mesh.getBuffer(VertexBuffer.Type.TexCoord);
        vBuff.updateData((Buffer)tb);
    }
}

