/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.bp;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Box;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.client.ui.ButtonControl;
import mythruna.client.ui.Command;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockIconSelection {
    private AssetManager assets;
    private Box boxMesh;
    private WireBox wireMesh;
    private Material boxMaterial;
    private Material wireMaterial;
    private Map<BlockType, Spatial> icons = new HashMap<BlockType, Spatial>();
    private List<String> groups = new ArrayList<String>();
    private int groupId = 0;
    private int itemType = 0;
    private BlockType lastType = null;

    public BlockIconSelection(AssetManager assets) {
        this.assets = assets;
        this.boxMesh = new Box(0.51f, 0.51f, 0.51f);
        this.wireMesh = new WireBox(0.51f, 0.51f, 0.51f);
        this.boxMaterial = new Material(assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.boxMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.01f));
        this.boxMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.boxMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Front);
        this.wireMaterial = new Material(assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.wireMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.1f));
        this.wireMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        for (int i = 0; i <= BlockTypeIndex.getMaxId(); ++i) {
            BlockType t = BlockTypeIndex.types[i];
            if (t == null) continue;
            this.icons.put(t, this.createBlockIcon(t));
        }
        this.groups.addAll(BlockTypeIndex.groupNames());
    }

    public String getLabel() {
        BlockType t = this.getSelectedType();
        if (t == null) {
            return "(none)";
        }
        return "(" + t.getId() + ") " + t.getName();
    }

    public Spatial getIcon() {
        BlockType t = this.getSelectedType();
        if (t == null) {
            return null;
        }
        return this.icons.get(t);
    }

    public BlockType getSelectedType() {
        if (this.lastType != null) {
            return this.lastType;
        }
        List<BlockType> types = this.getTypes(this.groups.get(this.groupId));
        if (types.size() == 0) {
            return null;
        }
        this.lastType = types.get(this.itemType);
        return this.lastType;
    }

    public void setSelectedType(BlockType type) {
        int groupIndex = 0;
        for (BlockTypeIndex.BlockGroup g : BlockTypeIndex.groups()) {
            int typeIndex = 0;
            for (BlockType t : g.getTypes()) {
                if (t == type) {
                    this.setGroup(groupIndex);
                    this.setItemType(typeIndex);
                    break;
                }
                ++typeIndex;
            }
            ++groupIndex;
        }
    }

    public int getTypeId() {
        BlockType t = this.getSelectedType();
        if (t == null) {
            return 0;
        }
        return t.getId();
    }

    public List<BlockType> getTypes(String group) {
        if (BlockTypeIndex.getGroup(group) == null) {
            return Collections.EMPTY_LIST;
        }
        return BlockTypeIndex.getGroup(group).getTypes();
    }

    public List<Spatial> getTypeIcons() {
        ArrayList<Spatial> results = new ArrayList<Spatial>();
        for (BlockType type : this.getTypes(this.groups.get(this.groupId))) {
            Spatial icon = this.icons.get(type);
            results.add(icon);
        }
        return results;
    }

    public List<Spatial> getGroupIcons() {
        ArrayList<Spatial> results = new ArrayList<Spatial>();
        for (String s : this.groups) {
            List<BlockType> types = this.getTypes(s);
            if (types.size() == 0) continue;
            Spatial icon = this.icons.get(types.get(0));
            results.add(icon);
        }
        return results;
    }

    protected int getGroupSize(String group) {
        return this.getTypes(group).size();
    }

    public void setItemType(int type) {
        if (this.itemType == type) {
            return;
        }
        if (type < 0) {
            type = 0;
        } else if (type >= this.getGroupSize(this.groups.get(this.groupId))) {
            type = this.getGroupSize(this.groups.get(this.groupId)) - 1;
        }
        this.itemType = type;
        this.lastType = null;
    }

    public int getItemType() {
        return this.itemType;
    }

    public void setGroup(int group) {
        if (this.groupId == group) {
            return;
        }
        if (group < 0) {
            group = 0;
        }
        if (group >= this.groups.size()) {
            group = this.groups.size() - 1;
        }
        this.groupId = group;
        this.setItemType(Math.max(0, Math.min(this.getItemType(), this.getGroupSize(this.groups.get(this.groupId)) - 1)));
        this.lastType = null;
    }

    public int getGroup() {
        return this.groupId;
    }

    public void incrementItemType() {
        int type = this.getItemType();
        if (++type >= this.getGroupSize(this.groups.get(this.groupId))) {
            type = 0;
        }
        this.setItemType(type);
    }

    public void decrementItemType() {
        int type = this.getItemType();
        if (--type < 0) {
            type = Math.max(0, this.getGroupSize(this.groups.get(this.groupId)) - 1);
        }
        this.setItemType(type);
    }

    public void incrementGroup() {
        int g = this.getGroup();
        if (++g >= this.groups.size()) {
            g = 0;
        }
        this.setGroup(g);
    }

    public void decrementGroup() {
        int g = this.getGroup();
        if (--g < 0) {
            g = this.groups.size() - 1;
        }
        this.setGroup(g);
    }

    protected Spatial createBlockIcon(BlockType type) {
        GeomFactory gf = type.getGeomFactory();
        GeomPartBuffer buffer = new GeomPartBuffer(new BoundingBox(Vector3f.ZERO, 1.0f, 1.0f, 1.0f));
        for (int i = 0; i < 6; ++i) {
            gf.createGeometry(buffer, 0, 0, 0, 0, 0, 0, 1.0f, 0.5f, type, i);
        }
        gf.createInternalGeometry(buffer, 0, 0, 0, 0, 0, 0, 1.0f, 0.5f, type);
        Node node = buffer.createNode("Icon:" + type.getName(), -0.5f, -0.5f, -0.5f);
        Geometry box = new Geometry("Icon:" + type.getName() + " Box", (Mesh)this.boxMesh);
        box.setMaterial(this.boxMaterial);
        box.setQueueBucket(RenderQueue.Bucket.Transparent);
        Geometry wireBox = new Geometry("Icon:" + type.getName() + " Wire", (Mesh)this.wireMesh);
        wireBox.setMaterial(this.wireMaterial);
        wireBox.setQueueBucket(RenderQueue.Bucket.Transparent);
        node.addControl((Control)new ButtonControl());
        ((ButtonControl)node.getControl(ButtonControl.class)).addCommand(new SelectCommand(type));
        box.addControl((Control)new ButtonControl());
        ((ButtonControl)box.getControl(ButtonControl.class)).addCommand(new SelectCommand(type));
        node.attachChild((Spatial)box);
        node.attachChild((Spatial)wireBox);
        return node;
    }

    public class SelectCommand
    implements Command {
        private BlockType blockType;

        public SelectCommand(BlockType blockType) {
            this.blockType = blockType;
        }

        public void execute(Object source, Object action) {
            BlockIconSelection.this.setSelectedType(this.blockType);
        }
    }
}

