/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.bp;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import mythruna.geom.CubeFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;

public class Workbench {
    private int size;
    private int borderSize = 2;
    private int totalSize;
    private int wallType = 10;
    private int floorType = 10;
    private int borderType = 11;
    private GeomFactory wallFactory = new CubeFactory(this.wallType);
    private GeomFactory borderFactory = new CubeFactory(this.borderType);

    public Workbench(int size) {
        this.size = size;
        this.totalSize = size + this.borderSize * 2;
    }

    public int getSize() {
        return this.size;
    }

    public boolean contains(Vector3f cell) {
        if (cell.x < 0.0f || cell.y < 0.0f || cell.z < 0.0f) {
            return false;
        }
        return !(cell.x >= (float)this.size) && !(cell.y >= (float)this.size) && !(cell.z >= (float)this.size);
    }

    public Vector3f cellToModel(Vector3f cell) {
        Vector3f result = new Vector3f();
        result.x = cell.x - (float)this.size / 2.0f;
        result.z = cell.y - (float)this.size / 2.0f;
        result.y = cell.z;
        return result;
    }

    public GeomPartBuffer generateParts(float sun, float localLight) {
        int j;
        int i;
        GeomPartBuffer parts = new GeomPartBuffer();
        for (i = 0; i < this.totalSize; ++i) {
            for (j = 0; j < this.totalSize; ++j) {
                if (i < this.borderSize || i >= this.totalSize - this.borderSize || j < this.borderSize || j >= this.totalSize - this.borderSize) {
                    this.borderFactory.createGeometry(parts, i, j, -1, i, j, -1, sun, localLight, null, 4);
                    continue;
                }
                this.wallFactory.createGeometry(parts, i, j, -1, i, j, -1, sun, localLight, null, 4);
                this.wallFactory.createGeometry(parts, i, j, this.size, i, j, this.size, sun, localLight, null, 5);
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                this.wallFactory.createGeometry(parts, i + this.borderSize, 1, j, i + this.borderSize, 1, j, sun, localLight, null, 1);
                this.wallFactory.createGeometry(parts, i + this.borderSize, this.size + this.borderSize, j, i + this.borderSize, this.size + this.borderSize, j, sun, localLight, null, 0);
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                this.wallFactory.createGeometry(parts, 1, i + this.borderSize, j, 1, i + this.borderSize, j, sun, localLight, null, 2);
                this.wallFactory.createGeometry(parts, this.size + this.borderSize, i + this.borderSize, j, this.size + this.borderSize, i + this.borderSize, j, sun, localLight, null, 3);
            }
        }
        return parts;
    }

    protected Node generateNode(float sun, float localLight) {
        GeomPartBuffer parts = this.generateParts(sun, localLight);
        Node node = parts.createNode(String.valueOf(this), (float)(-this.totalSize) / 2.0f, (float)(-this.totalSize) / 2.0f, 0.0f);
        return node;
    }
}

