/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.map;

import com.jme3.app.Application;
import com.jme3.font.BitmapFont;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mythruna.World;
import mythruna.client.GameClient;
import mythruna.client.tabs.map.MapState;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimType;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.Name;
import mythruna.es.OwnedBy;
import mythruna.es.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMarkers
extends AbstractControl {
    private static final ColorRGBA labelColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private Application app;
    private GameClient gameClient;
    private World world;
    private EntityData ed;
    private BitmapFont writingFont;
    private MapState mapState;
    private EntityId parent;
    private EntitySet entities;
    private PropertyMarkers localClaims = null;
    private Entity currentZone = null;
    private Map<Entity, Label> labels = new HashMap<Entity, Label>();

    public PropertyMarkers(Application app, GameClient gameClient, MapState mapState) {
        this.app = app;
        this.gameClient = gameClient;
        this.world = gameClient.getWorld();
        this.ed = this.world.getEntityData();
        this.mapState = mapState;
        super.setEnabled(false);
        this.writingFont = app.getAssetManager().loadFont("Interface/templar32.fnt");
    }

    protected void initialize() {
        this.entities = this.ed.getEntities(new FieldFilter<ClaimType>(ClaimType.class, "parent", this.parent), ClaimType.class, ClaimArea.class, Position.class, Name.class, OwnedBy.class);
        this.addNodes(this.entities);
    }

    protected void terminate() {
        if (this.localClaims != null) {
            this.localClaims.terminate();
        }
        this.localClaims = null;
        this.currentZone = null;
        this.removeNodes(this.entities);
        this.entities.release();
        this.entities = null;
    }

    protected void adjustLocal() {
        Matrix4f transform = this.mapState.getMapTransform();
        float scale = this.mapState.getMapScale();
        for (Map.Entry<Entity, Label> e : this.labels.entrySet()) {
            Position pos = e.getKey().get(Position.class);
            Name name = e.getKey().get(Name.class);
            Vector3f v = pos.getLocation();
            v = transform.mult(v);
            Quaternion rot = pos.getRotation();
            float[] angles = rot.toAngles(null);
            rot = new Quaternion().fromAngles(0.0f, 0.0f, angles[1]);
            Label l = e.getValue();
            l.setLocalRotation(rot);
            l.setLocalTranslation(v.x, v.y, 0.0f);
            ClaimType type = e.getKey().get(ClaimType.class);
            if (type.canBeParent()) {
                l.setLocalScale(scale / 1.2f);
                l.setText(name.getName());
                continue;
            }
            if (type.getClaimType() == 1) {
                l.setLocalScale(scale / 3.0f);
                String s = name.getName();
                s = s.replaceAll("\\s+", "\n");
                l.setText(s);
                continue;
            }
            l.setLocalScale(scale / 5.0f);
            l.setText(name.getName());
        }
    }

    protected void addNodes(Set<Entity> set) {
        for (Entity e : set) {
            Label l = new Label(this.writingFont);
            l.setText("Test");
            l.setHAlignment(HAlignment.CENTER);
            l.setColor(labelColor);
            l.setShadowColor(shadowColor);
            this.labels.put(e, l);
            ((Node)this.spatial).attachChild((Spatial)l);
        }
    }

    protected void updateNodes(Set<Entity> set) {
    }

    protected void removeNodes(Set<Entity> set) {
        for (Entity e : set) {
            Label l = this.labels.remove(e);
            if (l == null) continue;
            ((Node)this.spatial).detachChild((Spatial)l);
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        return this;
    }

    public void setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return;
        }
        super.setEnabled(b);
        if (b) {
            this.initialize();
        } else {
            this.terminate();
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
        if (this.localClaims != null) {
            this.localClaims.controlRender(rm, vp);
        }
    }

    protected void controlUpdate(float tpf) {
        if (this.entities == null) {
            return;
        }
        this.entities.applyChanges();
        this.removeNodes(this.entities.getRemovedEntities());
        this.addNodes(this.entities.getAddedEntities());
        this.updateNodes(this.entities.getChangedEntities());
        if (this.localClaims != null) {
            this.localClaims.controlUpdate(tpf);
        }
        this.adjustLocal();
    }
}

