/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import mythruna.client.tabs.property.Table;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.Name;
import mythruna.es.OwnedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotTable
implements Table<Entity> {
    private String[] columnNames = new String[]{"Plot Name", "Owner", "Lock"};
    private EntityId player;
    private EntityData ed;
    private EntitySet plots;
    private Entity[] rows;
    private long version;

    public PlotTable(EntityId player, EntityData ed, EntitySet plots) {
        this.ed = ed;
        this.player = player;
        this.plots = plots;
        this.update();
    }

    @Override
    public Entity getRow(int row) {
        if (this.rows == null) {
            return null;
        }
        return this.rows[row];
    }

    protected boolean needsUpdate() {
        if (this.rows == null) {
            return true;
        }
        if (!this.plots.getAddedEntities().isEmpty()) {
            return true;
        }
        return !this.plots.getRemovedEntities().isEmpty();
    }

    @Override
    public long getChangeVersion() {
        return this.version;
    }

    @Override
    public void update() {
        if (this.needsUpdate()) {
            this.updateRows();
            ++this.version;
        } else if (!this.plots.getChangedEntities().isEmpty()) {
            ++this.version;
        }
    }

    protected void updateRows() {
        this.rows = new Entity[this.plots.size()];
        this.rows = this.plots.toArray(this.rows);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getSize() {
        return this.rows.length;
    }

    @Override
    public String getHeading(int col) {
        return this.columnNames[col];
    }

    protected String safeName(Name name) {
        return name == null ? "Unknown" : name.getName();
    }

    @Override
    public String getValue(int row, int col) {
        if (this.rows == null) {
            this.updateRows();
        }
        Entity e = this.rows[row];
        switch (col) {
            case 0: {
                return this.safeName(e.get(Name.class));
            }
            case 1: {
                OwnedBy owner = e.get(OwnedBy.class);
                if (owner.getOwnerId().equals(this.player)) {
                    return "You";
                }
                return this.safeName(this.ed.getComponent(owner.getOwnerId(), Name.class));
            }
        }
        return "";
    }
}

