/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.KeyMethodAction;
import mythruna.client.PostProcessingState;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.tabs.property.PropertyViewPanel;
import mythruna.client.ui.Label;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.MouseListener;
import mythruna.client.ui.ObservableState;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimType;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.Name;
import mythruna.es.OwnedBy;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTabState
extends ObservableState
implements AnalogListener {
    static Log log = Log.getLog();
    private static final float REFERENCE_HEIGHT = 720.0f;
    private static final ColorRGBA titleColor = new ColorRGBA(0.24313726f, 0.24313726f, 0.41568628f, 1.0f);
    private static final ColorRGBA selectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.20784314f, 1.0f);
    private static final ColorRGBA nameColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA nameSelectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.39215687f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private GameClient gameClient;
    private GameAppState gameState;
    private AssetManager assets;
    private float heightOffset;
    private BitmapFont writingFont;
    private Node propertyNode;
    private Node smallBook;
    private PropertyViewPanel viewPanel;
    private EntitySet claims;
    private Map<String, PropertyGroup> groups = new HashMap<String, PropertyGroup>();
    private PropertyGroup currentGroup = null;

    public PropertyTabState(GameClient gameClient, GameAppState gameState) {
        super("Property", false);
        this.gameClient = gameClient;
        this.gameState = gameState;
    }

    public void toggleProperty() {
        this.setEnabled(!this.isEnabled());
    }

    public void update(float tpf) {
        if (this.claims != null && this.claims.applyChanges()) {
            this.applyAdds(this.claims.getAddedEntities());
            this.applyChanges(this.claims.getChangedEntities());
            this.applyRemoves(this.claims.getRemovedEntities());
        }
        boolean changed = false;
        for (PropertyGroup g : this.groups.values()) {
            if (!g.update()) continue;
            changed = true;
        }
        if (changed) {
            float x = 240.0f;
            float y = 410.0f;
            PropertyGroup group = this.getGroup("Strongholds", true);
            group.getLabel().setLocalTranslation(x, y, 0.0f);
            y -= group.getHeight();
            group = this.getGroup("Towns", true);
            group.getLabel().setLocalTranslation(x, y, 0.0f);
            y -= group.getHeight();
            group = this.getGroup("Cities", true);
            group.getLabel().setLocalTranslation(x, y, 0.0f);
            y -= group.getHeight();
            group = this.getGroup("Town/City Plots", true);
            group.getLabel().setLocalTranslation(x, y, 0.0f);
            y -= group.getHeight();
        }
    }

    protected void applyAdds(Set<Entity> entities) {
        for (Entity e : entities) {
            ClaimType type = e.get(ClaimType.class);
            this.getGroup(type.getClaimType(), true).addEntity(e);
        }
    }

    protected void applyRemoves(Set<Entity> entities) {
        for (Entity e : entities) {
            ClaimType type = e.get(ClaimType.class);
            this.getGroup(type.getClaimType(), true).removeEntity(e);
        }
    }

    protected void applyChanges(Set<Entity> entities) {
        for (Entity e : entities) {
            ClaimType type = e.get(ClaimType.class);
            System.out.println("Claim changed:" + e);
        }
    }

    protected String getGroupName(byte type) {
        switch (type) {
            default: {
                return "World";
            }
            case 1: {
                return "Strongholds";
            }
            case 2: {
                return "Towns";
            }
            case 3: {
                return "Cities";
            }
            case 4: 
            case 5: 
        }
        return "Town/City Plots";
    }

    protected PropertyGroup getGroup(byte type, boolean create) {
        return this.getGroup(this.getGroupName(type), create);
    }

    protected PropertyGroup getGroup(String name, boolean create) {
        PropertyGroup result = this.groups.get(name);
        if (result == null && create) {
            result = new PropertyGroup(name);
            this.groups.put(name, result);
        }
        return result;
    }

    protected void setCurrentGroup(PropertyGroup group) {
        if (this.currentGroup == group) {
            return;
        }
        this.currentGroup = group;
        for (PropertyGroup g : this.groups.values()) {
            g.setActivated(g == this.currentGroup);
        }
    }

    protected void setCurrentProperty(Entity property) {
        System.out.println("setCurrentProperty( " + property + " )");
        this.viewPanel.setProperty(property);
    }

    @Override
    protected void initialize(Application app) {
        super.initialize(app);
        this.assets = app.getAssetManager();
        Camera cam = this.getApplication().getCamera();
        float scale = 1.0f;
        if ((float)cam.getHeight() < 720.0f) {
            scale = (float)cam.getHeight() / 720.0f;
            this.heightOffset = 0.0f;
        } else {
            this.heightOffset = (float)cam.getHeight() - 720.0f;
        }
        this.propertyNode = new Node("Property Tab Root");
        this.propertyNode.setLocalScale(scale);
        this.propertyNode.setLocalTranslation(0.0f, this.heightOffset, 0.0f);
        this.smallBook = new Node("Property Ledger");
        this.viewPanel = new PropertyViewPanel(this.gameClient, app);
        this.viewPanel.setLocalTranslation(510.0f, this.heightOffset, 0.0f);
        this.propertyNode.attachChild((Spatial)this.viewPanel);
        KeyMethodAction tab = new KeyMethodAction((Object)this, "toggleProperty", 25);
        tab.attach(app.getInputManager());
        this.writingFont = app.getAssetManager().loadFont("Interface/templar32.fnt");
        Quad quad = new Quad(512.0f, 512.0f);
        Geometry smallBookGeom = new Geometry("Property Ledger", (Mesh)quad);
        Material m = new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md");
        m.setTexture("ColorMap", this.assets.loadTexture("Interface/small-book.jpg"));
        smallBookGeom.setMaterial(m);
        smallBookGeom.setLocalTranslation(0.0f, 0.0f, -5.0f);
        this.smallBook.attachChild((Spatial)smallBookGeom);
        PropertyGroup group = this.getGroup("Strongholds", true);
        this.smallBook.attachChild((Spatial)group.getLabel());
        group = this.getGroup("Towns", true);
        this.smallBook.attachChild((Spatial)group.getLabel());
        group = this.getGroup("Cities", true);
        this.smallBook.attachChild((Spatial)group.getLabel());
        group = this.getGroup("Town/City Plots", true);
        this.smallBook.attachChild((Spatial)group.getLabel());
        this.propertyNode.attachChild((Spatial)this.smallBook);
    }

    @Override
    protected void enable() {
        super.enable();
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFadeOn(1.5f, 1.5f);
        Node gui = this.getState(GameAppState.class).getGuiNode();
        gui.attachChild((Spatial)this.propertyNode);
        Camera cam = this.getApplication().getCamera();
        Vector3f start = new Vector3f(0.0f, 720.0f, -1.0f);
        Vector3f end = new Vector3f(-50.0f, 163.0f, -1.0f);
        this.getState(AnimationState.class).add(Animation.move((Spatial)this.smallBook, start, end, 0.25f));
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.smallBook, 0.01f, 1.0f, 0.25f));
        end = new Vector3f(510.0f, this.heightOffset, 0.0f);
        this.getState(AnimationState.class).add(Animation.move((Spatial)this.viewPanel, start, end, 0.25f));
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.viewPanel, 0.01f, 1.0f, 0.25f));
        EntityData ed = this.gameClient.getEntityData();
        this.claims = ed.getEntities(new FieldFilter<OwnedBy>(OwnedBy.class, "ownerId", this.gameClient.getPlayer()), OwnedBy.class, ClaimType.class, ClaimArea.class, Name.class);
        this.applyAdds(this.claims);
        this.viewPanel.enable();
    }

    @Override
    protected void disable() {
        super.disable();
        this.viewPanel.setProperty(null);
        this.viewPanel.disable();
        this.applyRemoves(this.claims);
        this.claims.release();
        this.claims = null;
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFade(false);
        Camera cam = this.getApplication().getCamera();
        Vector3f start = new Vector3f(0.0f, 720.0f, -1.0f);
        Vector3f end = new Vector3f(-50.0f, 163.0f, -1.0f);
        this.getState(AnimationState.class).add(Animation.detach((Spatial)this.propertyNode, 0.25f), Animation.scale((Spatial)this.smallBook, 1.0f, 0.01f, 0.25f), Animation.move((Spatial)this.smallBook, end, start, 0.25f));
        end = new Vector3f(510.0f, this.heightOffset, 0.0f);
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.viewPanel, 1.0f, 0.01f, 0.25f), Animation.move((Spatial)this.viewPanel, end, start, 0.25f));
    }

    public void onAnalog(String name, float value, float tpf) {
        System.out.println("onAnalog(" + name + ", " + value + ")");
    }

    private class GroupExpander
    implements MouseListener {
        private PropertyGroup group;
        private int xDown;
        private int yDown;

        public GroupExpander(PropertyGroup group) {
            this.group = group;
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
            if (event.isPressed()) {
                this.xDown = event.getX();
                this.yDown = event.getY();
            } else {
                int x = event.getX();
                int y = event.getY();
                if (Math.abs(x - this.xDown) < 3 && Math.abs(y - this.yDown) < 3) {
                    System.out.println("Click:" + capture);
                    if (this.group.isActivated()) {
                        PropertyTabState.this.setCurrentGroup(null);
                    } else {
                        PropertyTabState.this.setCurrentGroup(this.group);
                    }
                }
            }
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            this.group.getLabel().setColor(selectColor);
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
            this.group.getLabel().setColor(titleColor);
            this.group.getLabel().setShadowColor(shadowColor);
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
        }
    }

    private class PropertySelector
    implements MouseListener {
        private Label label;
        private Entity property;
        private int xDown;
        private int yDown;

        public PropertySelector(Label label, Entity property) {
            this.label = label;
            this.property = property;
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
            if (event.isPressed()) {
                this.xDown = event.getX();
                this.yDown = event.getY();
            } else {
                int x = event.getX();
                int y = event.getY();
                if (Math.abs(x - this.xDown) < 3 && Math.abs(y - this.yDown) < 3) {
                    System.out.println("Click:" + capture);
                    PropertyTabState.this.setCurrentProperty(this.property);
                }
            }
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            this.label.setColor(nameSelectColor);
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
            this.label.setColor(nameColor);
            this.label.setShadowColor(shadowColor);
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
        }
    }

    private class PropertyGroup {
        private String name;
        private Label label;
        private boolean activated = false;
        private boolean invalid = true;
        private List<Entity> properties = new ArrayList<Entity>();
        private List<Label> labels = new ArrayList<Label>();

        private PropertyGroup(String name) {
            this.name = name;
            this.label = new Label(PropertyTabState.this.writingFont);
            this.label.setText("+ " + name);
            this.label.setColor(titleColor);
            this.label.setShadowColor(shadowColor);
            this.label.addControl((Control)new MouseEventControl());
            ((MouseEventControl)this.label.getControl(MouseEventControl.class)).addMouseListener(new GroupExpander(this));
        }

        public float getHeight() {
            float h = 30.0f;
            float spacing = 25.0f;
            if (!this.properties.isEmpty() && this.activated) {
                h += (float)this.properties.size() * spacing;
                h += spacing * 0.5f;
            }
            return h;
        }

        protected void resetText() {
            StringBuilder sb = new StringBuilder();
            if (this.activated) {
                sb.append("- ");
            } else {
                sb.append("+ ");
            }
            sb.append(this.name);
            sb.append(" (" + this.properties.size() + ")");
            this.label.setText(sb.toString());
        }

        protected void updateChildren() {
            for (Label l : this.labels) {
                this.label.detachChild((Spatial)l);
            }
            this.labels.clear();
            if (!this.activated) {
                return;
            }
            float y = 0.0f;
            float spacing = 25.0f;
            for (Entity e : this.properties) {
                Name n = e.get(Name.class);
                Label l = new Label(PropertyTabState.this.writingFont);
                this.labels.add(l);
                float scale = 0.75f;
                l.setLocalScale(scale);
                l.setText("- " + n.getName());
                l.setColor(nameColor);
                l.setShadowColor(shadowColor);
                l.setLocalTranslation(15.0f, y -= spacing, 0.0f);
                l.addControl((Control)new MouseEventControl());
                ((MouseEventControl)l.getControl(MouseEventControl.class)).addMouseListener(new PropertySelector(l, e));
                this.label.attachChild((Spatial)l);
            }
        }

        public void invalidate() {
            this.invalid = true;
        }

        public boolean update() {
            if (this.invalid) {
                this.resetText();
                this.updateChildren();
                this.invalid = false;
                return true;
            }
            return false;
        }

        public boolean addEntity(Entity e) {
            if (this.properties.add(e)) {
                this.invalidate();
                return true;
            }
            return false;
        }

        public boolean removeEntity(Entity e) {
            if (this.properties.remove(e)) {
                this.invalidate();
                return true;
            }
            return false;
        }

        public void setActivated(boolean f) {
            if (this.activated == f) {
                return;
            }
            this.activated = f;
            this.invalidate();
        }

        public boolean isActivated() {
            return this.activated;
        }

        public Label getLabel() {
            return this.label;
        }
    }
}

