/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import com.jme3.app.Application;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapFont;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import mythruna.MaterialIndex;
import mythruna.client.GameClient;
import mythruna.client.anim.AnimatedContainer;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.anim.AnimationTask;
import mythruna.client.anim.ContainerAnimation;
import mythruna.client.tabs.property.BadgeTable;
import mythruna.client.tabs.property.PlotTable;
import mythruna.client.tabs.property.PropertyMapView;
import mythruna.client.tabs.property.Table;
import mythruna.client.tabs.property.TableView;
import mythruna.client.ui.Button;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.client.ui.LabelSelector;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.MouseListener;
import mythruna.client.ui.VAlignment;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimPermissions;
import mythruna.es.ClaimType;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import mythruna.es.Name;
import mythruna.es.OwnedBy;
import mythruna.geom.Trifold;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyViewPanel
extends Node {
    static Log log = Log.getLog();
    private static final ColorRGBA titleColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA selectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.20784314f, 1.0f);
    private static final ColorRGBA infoColor = new ColorRGBA(0.24313726f, 0.24313726f, 0.41568628f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private GameClient gameClient;
    private Application app;
    private BitmapFont writingFont;
    private Entity property;
    private float pageWidth = 426.0f;
    private float pageHeight = 600.0f;
    private float rollerHeight = 80.0f;
    private Node bottomRoller;
    private Label title;
    private Node buttonPanel;
    private Button[] actions;
    private Label tableSwitch;
    private Node info;
    private Map<String, Object> infoValues = new LinkedHashMap<String, Object>();
    private PropertyMapView map;
    private EntitySet plots = null;
    private EntitySet badges = null;
    private TableView table;
    private Table plotTable;
    private Table badgeTable;
    private Node scrollBar;
    private int scrollSize = -1;
    private ContainerAnimation pageOpener;
    private Entity lastProperty = null;

    public PropertyViewPanel(GameClient gameClient, Application app) {
        this.gameClient = gameClient;
        this.app = app;
        this.writingFont = app.getAssetManager().loadFont("Interface/templar32.fnt");
        this.createScroll();
        this.createInfoView();
        this.createMapView();
        this.createTableView();
    }

    protected void enable() {
        this.pageOpener = new ContainerAnimation();
        ((AnimationState)this.app.getStateManager().getState(AnimationState.class)).add(this.pageOpener);
    }

    protected void disable() {
        if (this.pageOpener != null) {
            this.pageOpener.stop();
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.plots != null && this.plots.applyChanges()) {
            this.resetInfo();
            this.plotTable.update();
        }
        if (this.badges != null && this.badges.applyChanges()) {
            this.resetInfo();
            this.badgeTable.update();
        }
        if (this.table.getPageCount() != this.scrollSize) {
            this.scrollSize = this.table.getPageCount();
            if (this.scrollSize <= 0) {
                this.scrollBar.setCullHint(Spatial.CullHint.Always);
            } else {
                this.scrollBar.setCullHint(Spatial.CullHint.Inherit);
            }
        }
    }

    public void setProperty(Entity property) {
        if (this.lastProperty == property) {
            return;
        }
        this.lastProperty = property;
        this.pageOpener.setContainer(new PropertyContainer(property));
    }

    protected void resetInfo() {
        ClaimType type = this.property.get(ClaimType.class);
        switch (type.getClaimType()) {
            case 1: {
                this.showStrongholdInfo(this.property);
                break;
            }
            case 2: {
                this.showTownInfo("Town", this.property);
                break;
            }
            case 3: {
                this.showTownInfo("City", this.property);
                break;
            }
            case 4: {
                this.showPlotInfo("Town", this.property);
                break;
            }
            case 5: {
                this.showPlotInfo("City", this.property);
            }
        }
    }

    protected void showPlotTable() {
        if (this.table.getTable() == this.plotTable) {
            return;
        }
        this.table.setTable(this.plotTable, new float[]{180.0f, 140.0f, 60.0f});
        this.tableSwitch.setText("<Show Badges>");
    }

    protected void showBadgeTable() {
        if (this.table.getTable() == this.badgeTable) {
            return;
        }
        this.table.setTable(this.badgeTable, new float[]{180.0f});
        this.tableSwitch.setText("<Show Plots>");
    }

    protected void toggleTable() {
        System.out.println("toggleTable()");
        if (this.table.getTable() == this.badgeTable) {
            this.showPlotTable();
        } else {
            this.showBadgeTable();
        }
    }

    protected void setupPlots(Entity e) {
        EntityData ed = this.gameClient.getEntityData();
        if (this.plots != null) {
            this.plots.release();
        }
        this.plots = ed.getEntities(new FieldFilter<ClaimType>(ClaimType.class, "parent", e.getId()), ClaimType.class, Name.class, OwnedBy.class);
        this.plotTable = new PlotTable(this.gameClient.getPlayer(), ed, this.plots);
    }

    protected void setupBadges(Entity e) {
        EntityData ed = this.gameClient.getEntityData();
        if (this.badges != null) {
            this.badges.release();
        }
        this.badges = ed.getEntities(new FieldFilter<ClaimPermissions>(ClaimPermissions.class, "claimId", e.getId()), ClaimPermissions.class, InContainer.class);
        this.badgeTable = new BadgeTable(this.gameClient.getPlayer(), ed, this.badges);
    }

    protected void createMapView() {
        this.map = new PropertyMapView(this.gameClient, this.app);
        this.map.setLocalTranslation(this.pageWidth - 218.0f, this.pageHeight - 268.0f, 0.0f);
        this.attachChild((Spatial)this.map);
    }

    protected void createTableView() {
        this.table = new TableView(this.gameClient, this.app, 10);
        this.table.setLocalTranslation(10.0f, 400.0f, 0.0f);
        this.attachChild((Spatial)this.table);
        this.scrollBar = new Node("ScrollBar");
        this.attachChild((Spatial)this.scrollBar);
        float scrollHeight = 240.0f;
        Quad page = new Quad(24.0f, scrollHeight);
        Geometry geom = new Geometry("ScrollBar", (Mesh)page);
        Material m = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        Texture t = this.app.getAssetManager().loadTexture("Interface/scrollbar.jpg");
        m.setTexture("ColorMap", t);
        geom.setMaterial(m);
        this.scrollBar.setLocalTranslation(this.pageWidth - 30.0f, 400.0f - scrollHeight - 30.0f - 6.0f, 0.0f);
        this.scrollBar.attachChild((Spatial)geom);
        Quad button = new Quad(24.0f, 24.0f);
        geom = new Geometry("ScrollUp", (Mesh)button);
        m = m.clone();
        m.setColor("Color", shadowColor);
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(m);
        geom.setLocalTranslation(0.0f, scrollHeight - 24.0f, 0.1f);
        geom.addControl((Control)new MouseEventControl());
        ((MouseEventControl)geom.getControl(MouseEventControl.class)).addMouseListener(new ScrollButtonListener(-1));
        this.scrollBar.attachChild((Spatial)geom);
        geom = new Geometry("ScrollDown", (Mesh)button);
        geom.setMaterial(m);
        geom.setLocalTranslation(0.0f, 0.0f, 0.1f);
        geom.addControl((Control)new MouseEventControl());
        ((MouseEventControl)geom.getControl(MouseEventControl.class)).addMouseListener(new ScrollButtonListener(1));
        this.scrollBar.attachChild((Spatial)geom);
    }

    protected void createInfoView() {
        this.title = new Label(this.writingFont);
        this.title.setText("");
        this.title.setColor(titleColor);
        this.title.setShadowColor(shadowColor);
        this.title.setHAlignment(HAlignment.CENTER);
        this.title.setLocalTranslation(this.pageWidth * 0.5f, this.pageHeight + 10.0f, 0.0f);
        this.title.setLocalScale(1.25f);
        this.attachChild((Spatial)this.title);
        this.info = new Node("Info Panel");
        this.info.setLocalTranslation(0.0f, this.pageHeight, 0.0f);
        this.attachChild((Spatial)this.info);
        this.buttonPanel = new Node("Property Buttons");
        this.attachChild((Spatial)this.buttonPanel);
        ArrayList list = new ArrayList();
        float buttonWidth = this.pageWidth * 0.3f;
        float buttonHeight = 25.0f;
        float buttonTextScale = 0.75f;
        this.tableSwitch = new Label(this.writingFont);
        this.tableSwitch.setText("<Show Badges>");
        this.tableSwitch.setColor(titleColor);
        this.tableSwitch.setShadowColor(shadowColor);
        this.tableSwitch.setHAlignment(HAlignment.LEFT);
        this.tableSwitch.setLocalTranslation(50.0f, this.pageHeight - 200.0f, 0.0f);
        this.tableSwitch.setLocalScale(0.7f);
        this.tableSwitch.addControl((Control)new MouseEventControl());
        ((MouseEventControl)this.tableSwitch.getControl(MouseEventControl.class)).addMouseListener(new LabelSelector(this.tableSwitch, titleColor, shadowColor, selectColor){

            public void click(MouseButtonEvent event) {
                PropertyViewPanel.this.toggleTable();
            }
        });
    }

    protected void createScroll() {
        Quad page = new Quad(this.pageWidth, this.pageHeight);
        float x = this.pageWidth / 256.0f;
        float y = this.pageHeight / 256.0f;
        page.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, y, x, y, x, 0.0f, 0.0f, 0.0f});
        Geometry geom = new Geometry("Page", (Mesh)page);
        Material m = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        Texture t = this.app.getAssetManager().loadTexture("Textures/sand.jpg");
        t.setWrap(Texture.WrapMode.Repeat);
        m.setTexture("ColorMap", t);
        geom.setMaterial(m);
        geom.setLocalTranslation(0.0f, 70.0f, -1.0f);
        this.attachChild((Spatial)geom);
        this.bottomRoller = new Node("Bottom Roller");
        this.attachChild((Spatial)this.bottomRoller);
        float rollerWidth = this.pageWidth + 56.0f;
        Trifold roller = new Trifold(rollerWidth, this.rollerHeight);
        roller.setFoldTextureCoordinates(new Vector2f(0.25f, 0.25f), new Vector2f(0.75f, 0.75f));
        roller.setFoldCoordinates(new Vector2f(32.0f, this.rollerHeight * 0.25f), new Vector2f(rollerWidth - 32.0f, this.rollerHeight * 0.75f));
        roller.updateGeometry();
        Geometry roller1 = new Geometry("Roller1", (Mesh)roller);
        m = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        TextureKey key = new TextureKey("Interface/roller.png");
        key.setGenerateMips(false);
        t = this.app.getAssetManager().loadTexture(key);
        m.setTexture("ColorMap", t);
        roller1.setMaterial(m);
        roller1.setLocalTranslation(-27.0f, 70.0f - this.rollerHeight * 0.5f, 1.0f);
        this.bottomRoller.attachChild((Spatial)roller1);
        Quad test2 = new Quad(426.0f, this.pageHeight);
        Geometry geom2 = new Geometry("Overlay1", (Mesh)test2);
        geom2.setMaterial(MaterialIndex.TRANSPARENT_MATERIAL);
        geom2.setLocalTranslation(0.0f, 70.0f - this.pageHeight, 1.0f);
        geom2.setUserData("guiLayer", (Object)-1);
        this.bottomRoller.attachChild((Spatial)geom2);
        Geometry roller2 = new Geometry("Roller2", (Mesh)roller);
        roller2.setMaterial(m);
        roller2.setLocalTranslation(-27.0f, this.pageHeight + 70.0f - this.rollerHeight * 0.5f, 1.1f);
        this.attachChild((Spatial)roller2);
        this.bottomRoller.setLocalTranslation(0.0f, this.pageHeight - this.rollerHeight, 0.0f);
    }

    protected void showStrongholdInfo(Entity e) {
        this.infoValues.clear();
        this.infoValues.put("Age", "0 yrs 0 mos 00 days");
        ClaimArea area = e.get(ClaimArea.class);
        this.infoValues.put("Area", area.getAreaSize() + " sq. m");
        this.infoValues.put("Size", area.getDeltaX() + " x " + area.getDeltaY());
        this.infoValues.put("Badges", this.badges.size());
        this.fillInfoView(this.infoValues);
    }

    protected void showTownInfo(String type, Entity e) {
        this.infoValues.clear();
        this.infoValues.put("Age", "0 yrs 0 mos 00 days");
        ClaimArea area = e.get(ClaimArea.class);
        this.infoValues.put("Area", area.getAreaSize() + " sq. m");
        this.infoValues.put("Size", area.getDeltaX() + " x " + area.getDeltaY());
        this.infoValues.put("Plots", this.plots.size());
        this.infoValues.put("Player Owners", "00");
        this.infoValues.put("NPC Owners", "00");
        this.infoValues.put(type + " Badges", this.badges.size());
        this.infoValues.put("Last Income", "0000 gp");
        this.fillInfoView(this.infoValues);
    }

    protected void showPlotInfo(String type, Entity e) {
        this.infoValues.clear();
        ClaimType ct = e.get(ClaimType.class);
        ClaimArea area = e.get(ClaimArea.class);
        Name parentName = this.gameClient.getEntityData().getComponent(ct.getParent(), Name.class);
        this.infoValues.put("In", parentName.getName());
        this.infoValues.put("Age", "0 yrs 0 mos 00 days");
        this.infoValues.put("Area", area.getAreaSize() + " sq. m");
        this.infoValues.put("Size", area.getDeltaX() + " x " + area.getDeltaY());
        this.infoValues.put("Badges", this.badges.size());
        this.fillInfoView(this.infoValues);
    }

    protected void fillInfoView(Map<String, Object> values) {
        System.out.println("Info:" + values);
        this.clearInfoView();
        float y = 0.0f;
        float x = 10.0f;
        float scale = 0.6666667f;
        for (Map.Entry<String, Object> e : values.entrySet()) {
            Label l = new Label(this.writingFont);
            l.setText(e.getKey() + ":");
            l.setVAlignment(VAlignment.TOP);
            l.setColor(titleColor);
            l.setShadowColor(shadowColor);
            l.setLocalTranslation(x, y, 0.0f);
            l.setLocalScale(scale);
            this.info.attachChild((Spatial)l);
            float width = l.getWidth();
            l = new Label(this.writingFont);
            l.setText(String.valueOf(e.getValue()));
            l.setVAlignment(VAlignment.TOP);
            l.setColor(infoColor);
            l.setShadowColor(shadowColor);
            l.setLocalTranslation(x + width + 10.0f, y, 0.0f);
            l.setLocalScale(scale);
            this.info.attachChild((Spatial)l);
            y -= l.getHeight() - 4.0f;
        }
    }

    protected void clearInfoView() {
        this.info.detachAllChildren();
    }

    private class ScrollButtonListener
    implements MouseListener {
        private int direction;
        private int xDown;
        private int yDown;

        public ScrollButtonListener(int direction) {
            this.direction = direction;
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
            if (event.isPressed()) {
                this.xDown = event.getX();
                this.yDown = event.getY();
            } else {
                int x = event.getX();
                int y = event.getY();
                if (Math.abs(x - this.xDown) < 3 && Math.abs(y - this.yDown) < 3) {
                    PropertyViewPanel.this.table.setPage(PropertyViewPanel.this.table.getPage() + this.direction);
                }
            }
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
        }
    }

    private class PropertyContainer
    implements AnimatedContainer {
        private Entity property;

        public PropertyContainer(Entity property) {
            this.property = property;
        }

        public void detach() {
            System.out.println("-----------------------detach property:" + this.property);
            if (PropertyViewPanel.this.plots != null) {
                PropertyViewPanel.this.plots.release();
            }
            PropertyViewPanel.this.plots = null;
            if (PropertyViewPanel.this.badges != null) {
                PropertyViewPanel.this.badges.release();
            }
            PropertyViewPanel.this.badges = null;
            PropertyViewPanel.this.table.setTable(null, null);
        }

        public void attach() {
            System.out.println("-----------------------attach property:" + this.property);
            PropertyViewPanel.this.property = this.property;
            PropertyViewPanel.this.map.setProperty(this.property);
            if (this.property != null) {
                Name name = this.property.get(Name.class);
                PropertyViewPanel.this.title.setText("~ " + name.getName() + " ~");
                ClaimType type = this.property.get(ClaimType.class);
                PropertyViewPanel.this.setupBadges(this.property);
                if (type.canBeParent()) {
                    PropertyViewPanel.this.setupPlots(this.property);
                    PropertyViewPanel.this.showPlotTable();
                    PropertyViewPanel.this.attachChild((Spatial)PropertyViewPanel.this.tableSwitch);
                } else {
                    PropertyViewPanel.this.showBadgeTable();
                    PropertyViewPanel.this.detachChild((Spatial)PropertyViewPanel.this.tableSwitch);
                }
                PropertyViewPanel.this.resetInfo();
            } else {
                PropertyViewPanel.this.title.setText("");
                PropertyViewPanel.this.clearInfoView();
            }
        }

        public AnimationTask[] animateOpen() {
            if (this.property == null) {
                return new AnimationTask[0];
            }
            Vector3f start = PropertyViewPanel.this.bottomRoller.getLocalTranslation().clone();
            Vector3f end = new Vector3f(0.0f, 0.0f, 0.0f);
            return new AnimationTask[]{Animation.move((Spatial)PropertyViewPanel.this.bottomRoller, start, end, 0.25f)};
        }

        public AnimationTask[] animateClose() {
            if (this.property == null) {
                return new AnimationTask[0];
            }
            Vector3f start = PropertyViewPanel.this.bottomRoller.getLocalTranslation().clone();
            Vector3f end = new Vector3f(0.0f, PropertyViewPanel.this.pageHeight - PropertyViewPanel.this.rollerHeight, 0.0f);
            return new AnimationTask[]{Animation.move((Spatial)PropertyViewPanel.this.bottomRoller, start, end, 0.25f)};
        }
    }
}

