/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import com.jme3.app.Application;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapFont;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import mythruna.client.GameClient;
import mythruna.client.tabs.property.Table;
import mythruna.client.ui.Label;
import mythruna.client.ui.MouseAdapter;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.VAlignment;
import mythruna.es.Entity;
import mythruna.script.ObjectParameter;

public class TableView
extends Node {
    private static final ColorRGBA headerColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA selectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.20784314f, 1.0f);
    private static final ColorRGBA cellColor = new ColorRGBA(0.24313726f, 0.24313726f, 0.41568628f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private Application app;
    private GameClient gameClient;
    private BitmapFont writingFont;
    private long lastVersion = -1L;
    private Table table;
    private int visibleRows;
    private int page = 0;
    private int maxPage = 0;
    private float[] columnSizes;
    private Label[] header;
    private Label[][] cells;
    private Geometry[] rowQuads;
    private Material selectedMaterial;
    private Material unselectedMaterial;
    private String clickAction = "Row Click";

    public TableView(GameClient gameClient, Application app, int visibleRows) {
        this.gameClient = gameClient;
        this.app = app;
        this.visibleRows = visibleRows;
        this.writingFont = app.getAssetManager().loadFont("Interface/templar32.fnt");
        this.rowQuads = new Geometry[visibleRows];
        this.selectedMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.selectedMaterial.setColor("Color", new ColorRGBA(0.78431374f, 0.78431374f, 0.003921569f, 0.15f));
        this.selectedMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.unselectedMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.unselectedMaterial.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        this.unselectedMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
    }

    public void setTable(Table table, float[] columnSizes) {
        if (this.table == table) {
            return;
        }
        this.gameClient.execute("Close Context Menu", null, null);
        this.detachAllChildren();
        this.table = table;
        this.columnSizes = columnSizes;
        this.page = 0;
        this.maxPage = 0;
        this.buildViews();
    }

    public Table getTable() {
        return this.table;
    }

    protected void clampPage() {
        if (this.table == null) {
            return;
        }
        this.page = Math.min(this.maxPage, this.page);
        this.page = Math.max(0, this.page);
    }

    public int getPageCount() {
        return this.maxPage;
    }

    public void setPage(int page) {
        if (this.page == page) {
            return;
        }
        this.page = page;
        this.clampPage();
        --this.lastVersion;
    }

    public int getPage() {
        return this.page;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.table != null && this.table.getChangeVersion() != this.lastVersion) {
            this.updateCells();
        }
    }

    protected String cell(int row, int col) {
        if (this.table == null) {
            return "";
        }
        if (row >= this.table.getSize()) {
            return "";
        }
        return this.table.getValue(row, col);
    }

    protected void buildViews() {
        if (this.table == null) {
            return;
        }
        Material horzMat = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/sand.jpg");
        key.setGenerateMips(false);
        Texture t = this.app.getAssetManager().loadTexture(key);
        t.setWrap(Texture.WrapMode.Repeat);
        horzMat.setTexture("ColorMap", t);
        horzMat.setColor("Color", new ColorRGBA(1.0f, 0.6862745f, 0.47058824f, 0.35f));
        horzMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Material vertMat = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        vertMat.setTexture("ColorMap", t);
        vertMat.setColor("Color", new ColorRGBA(0.78431374f, 0.003921569f, 0.78431374f, 0.15f));
        vertMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        float height = this.visibleRows * 24 + 30;
        Quad vertical = new Quad(4.0f, height);
        float colSpacer = 6.0f;
        float tx = 0.015625f;
        float ty = height / 256.0f;
        vertical.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, ty, tx, ty, tx, 0.0f, 0.0f, 0.0f});
        int cols = this.table.getColumnCount();
        this.header = new Label[cols];
        int y = 0;
        int x = 0;
        for (int i = 0; i < cols; ++i) {
            this.header[i] = new Label(this.writingFont);
            this.header[i].setText(this.table.getHeading(i));
            this.header[i].setColor(headerColor);
            this.header[i].setShadowColor(shadowColor);
            this.header[i].setVAlignment(VAlignment.TOP);
            this.header[i].setLocalTranslation(x, y, 0.0f);
            this.attachChild((Spatial)this.header[i]);
            x = (int)((float)x + this.columnSizes[i]);
            if (i >= cols - 1) continue;
            Geometry div = new Geometry("vert divider", (Mesh)vertical);
            div.setMaterial(vertMat);
            div.setLocalTranslation((float)x, 0.0f - height - 5.0f, 0.0f);
            this.attachChild((Spatial)div);
            x = (int)((float)x + colSpacer);
        }
        float width = (float)x - colSpacer;
        y -= 24;
        float textScale = 0.6666667f;
        Quad horizontal = new Quad((float)(x += 18), 6.0f);
        tx = (float)x / 256.0f;
        ty = 0.0234375f;
        horizontal.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, ty, tx, ty, tx, 0.0f, 0.0f, 0.0f});
        Geometry geom = new Geometry("horz divider", (Mesh)horizontal);
        geom.setMaterial(horzMat);
        geom.setLocalTranslation(0.0f, (float)(y -= 12), 0.0f);
        this.attachChild((Spatial)geom);
        Quad quad = new Quad(width, 20.0f);
        this.cells = new Label[this.visibleRows][cols];
        for (int i = 0; i < this.visibleRows; ++i) {
            x = 0;
            for (int j = 0; j < cols; ++j) {
                Label l = new Label(this.writingFont);
                l.setText("Test");
                l.setLocalScale(textScale);
                l.setColor(cellColor);
                l.setShadowColor(shadowColor);
                l.setVAlignment(VAlignment.TOP);
                l.setLocalTranslation(x, y, 0.0f);
                this.cells[i][j] = l;
                this.attachChild((Spatial)l);
                x = (int)((float)x + (this.columnSizes[j] + colSpacer));
            }
            y -= 24;
            if (this.rowQuads[i] == null) {
                this.rowQuads[i] = new Geometry("row[" + i + "]", (Mesh)quad);
                this.rowQuads[i].setMaterial(horzMat);
                this.rowQuads[i].addControl((Control)new MouseEventControl(new RowSelector(i, (Spatial)this.rowQuads[i])));
            }
            if (this.rowQuads[i].getParent() == null) {
                this.attachChild((Spatial)this.rowQuads[i]);
            }
            this.rowQuads[i].setLocalTranslation(0.0f, (float)(y + 3), 0.5f);
        }
        this.updateCells();
    }

    protected void updateCells() {
        this.lastVersion = this.table.getChangeVersion();
        this.maxPage = this.table.getSize() / this.visibleRows;
        if (this.table.getSize() % this.visibleRows == 0) {
            --this.maxPage;
        }
        this.clampPage();
        int cols = this.table.getColumnCount();
        int base = this.page * this.visibleRows;
        int size = this.table.getSize();
        float textScale = 0.6666667f;
        for (int i = 0; i < this.visibleRows; ++i) {
            int row = base + i;
            for (int j = 0; j < cols; ++j) {
                String s = this.cell(row, j);
                float w = this.writingFont.getLineWidth((CharSequence)s) * textScale;
                while (w > this.columnSizes[j]) {
                    s = s.substring(0, s.length() - 1);
                    w = this.writingFont.getLineWidth((CharSequence)s) * textScale;
                }
                this.cells[i][j].setText(s);
            }
            if (row < size && this.rowQuads[i].getParent() == null) {
                this.attachChild((Spatial)this.rowQuads[i]);
                continue;
            }
            if (row < size || this.rowQuads[i].getParent() == null) continue;
            this.detachChild((Spatial)this.rowQuads[i]);
        }
    }

    private class RowSelector
    extends MouseAdapter {
        private int row;
        private Spatial quad;

        public RowSelector(int i, Spatial quad) {
            this.row = i;
            this.quad = quad;
            quad.setMaterial(TableView.this.unselectedMaterial);
        }

        public void click(MouseButtonEvent event) {
            int realRow = TableView.this.page * TableView.this.visibleRows + this.row;
            Object clicked = TableView.this.table.getRow(realRow);
            System.out.println("Click[" + realRow + "]:" + clicked);
            Entity e = (Entity)clicked;
            Vector3f p = new Vector3f((float)event.getX(), (float)event.getY(), 0.0f);
            ObjectParameter parm = new ObjectParameter(e.getId(), p);
            TableView.this.gameClient.execute(TableView.this.clickAction, e.getId(), parm);
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            this.quad.setMaterial(TableView.this.selectedMaterial);
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
            this.quad.setMaterial(TableView.this.unselectedMaterial);
        }
    }
}

