/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.temp;

public class CellMemTest {
    private static Runtime runtime = Runtime.getRuntime();

    public static void runGc(int count) {
        System.out.println("Running GC " + count + " times.");
        for (int i = 0; i < count; ++i) {
            System.gc();
        }
    }

    public static long usedRam() {
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void memTest1(int count) {
        CellMemTest.runGc(5);
        long before = CellMemTest.usedRam();
        CellArray[] list = new CellArray[count];
        for (int i = 0; i < count; ++i) {
            list[i] = new Combined();
        }
        CellMemTest.runGc(5);
        long after = CellMemTest.usedRam();
        System.out.println("Test 1 total memory change:" + (after - before) + " bytes");
    }

    public static void memTest2(int count) {
        CellMemTest.runGc(5);
        long before = CellMemTest.usedRam();
        CellArray[] list = new CellArray[count];
        for (int i = 0; i < count; ++i) {
            list[i] = new Split();
        }
        CellMemTest.runGc(5);
        long after = CellMemTest.usedRam();
        System.out.println("Test 2 total memory change:" + (after - before) + " bytes");
    }

    public static void memTest3(int count) {
        CellMemTest.runGc(5);
        long before = CellMemTest.usedRam();
        CellArray[] list = new CellArray[count];
        for (int i = 0; i < count; ++i) {
            list[i] = new SingleDimensional();
        }
        CellMemTest.runGc(5);
        long after = CellMemTest.usedRam();
        System.out.println("Test 3 total memory change:" + (after - before) + " bytes");
    }

    public static void memTest4(int count) {
        CellMemTest.runGc(5);
        long before = CellMemTest.usedRam();
        CellArray[] list = new CellArray[count];
        for (int i = 0; i < count; ++i) {
            list[i] = new SplitSingleDimensional();
        }
        CellMemTest.runGc(5);
        long after = CellMemTest.usedRam();
        System.out.println("Test 4 total memory change:" + (after - before) + " bytes");
    }

    public static void rawTest1(int count, int[][][] array) {
        long start = System.nanoTime();
        long total = 0L;
        for (int i = 0; i < count; ++i) {
            for (int x = 0; x < 32; ++x) {
                for (int y = 0; y < 32; ++y) {
                    for (int z = 0; z < 32; ++z) {
                        total += (long)array[x][y][z];
                    }
                }
            }
        }
        long end = System.nanoTime();
        System.out.println("Raw1 time:" + (double)(end - start) / 1000000.0);
    }

    public static void rawTest2(int count, int[] array) {
        long start = System.nanoTime();
        long total = 0L;
        for (int i = 0; i < count; ++i) {
            for (int x = 0; x < 32768; ++x) {
                total += (long)array[x];
            }
        }
        long end = System.nanoTime();
        System.out.println("Raw2 time:" + (double)(end - start) / 1000000.0);
    }

    public static void accessTest(int count, CellArray array) {
        long start = System.nanoTime();
        long total = 0L;
        for (int i = 0; i < count; ++i) {
            for (int x = 0; x < 32; ++x) {
                for (int y = 0; y < 32; ++y) {
                    for (int z = 0; z < 32; ++z) {
                        total += (long)array.getType(x, y, z);
                    }
                }
            }
        }
        long end = System.nanoTime();
        System.out.println(array.getClass().getSimpleName() + " time:" + (double)(end - start) / 1000000.0);
    }

    public static void main(String ... args) {
        System.out.println("----------- starting access performance tests ---------");
        for (int i = 0; i < 5; ++i) {
            CellMemTest.runGc(5);
            System.out.println("Pass:" + (i + 1));
            CellMemTest.rawTest1(10000, new int[32][32][32]);
            CellMemTest.rawTest2(10000, new int[32768]);
            CellMemTest.accessTest(10000, new Combined());
            CellMemTest.accessTest(10000, new Split());
            CellMemTest.accessTest(10000, new SingleDimensional());
            CellMemTest.accessTest(10000, new SplitSingleDimensional());
        }
    }

    public static class SplitSingleDimensional
    implements CellArray {
        private short[] cells = new short[32768];
        private byte[] lights = new byte[32768];

        public final int getType(int x, int y, int z) {
            int index = x * 32 * 32 + (y + 32) + z;
            return this.cells[index];
        }

        public final int getLight(int x, int y, int z) {
            int index = x * 32 * 32 + (y + 32) + z;
            return this.lights[index];
        }
    }

    public static class SingleDimensional
    implements CellArray {
        private int[] cells = new int[32768];

        public final int getType(int x, int y, int z) {
            int index = x * 32 * 32 + (y + 32) + z;
            return this.cells[index] & 0xFFFF;
        }

        public final int getLight(int x, int y, int z) {
            int index = x * 32 * 32 + (y + 32) + z;
            return this.cells[index] >> 16 & 0xFFFF;
        }
    }

    public static class Split
    implements CellArray {
        private short[][][] cells = new short[32][32][32];
        private byte[][][] lights = new byte[32][32][32];

        public final int getType(int x, int y, int z) {
            return this.cells[x][y][z];
        }

        public final int getLight(int x, int y, int z) {
            return this.lights[x][y][z];
        }
    }

    public static class Combined
    implements CellArray {
        private int[][][] cells = new int[32][32][32];

        public final int getType(int x, int y, int z) {
            return this.cells[x][y][z] & 0xFFFF;
        }

        public final int getLight(int x, int y, int z) {
            return this.cells[x][y][z] >> 16 & 0xFFFF;
        }
    }

    public static interface CellArray {
        public int getType(int var1, int var2, int var3);

        public int getLight(int var1, int var2, int var3);
    }
}

