/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioNode;
import com.jme3.font.BitmapFont;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.texture.Texture;
import mythruna.client.ClientOptions;
import mythruna.client.ui.Command;
import mythruna.client.ui.CommandList;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.MouseListener;
import mythruna.client.ui.VAlignment;
import mythruna.geom.Trifold;
import org.progeeks.util.ObjectUtils;

public class Button
extends Node {
    public static final ColorRGBA DEFAULT_COLOR = ColorRGBA.Black;
    public static final ColorRGBA DEFAULT_SHADOW = new ColorRGBA(0.972549f, 0.9411765f, 0.7529412f, 1.0f);
    public static final ColorRGBA DEFAULT_SELECTED = ColorRGBA.Green;
    private AssetManager assets;
    private Label label;
    private Geometry background;
    private Trifold backgroundMesh;
    private Texture backgroundTexture;
    private Material bgMaterial;
    private float width;
    private float height;
    private Vector3f textOffset = new Vector3f();
    private float textScale = 1.0f;
    private AudioNode click;
    private ColorRGBA textColor = DEFAULT_COLOR;
    private ColorRGBA shadowColor = DEFAULT_SHADOW;
    private ColorRGBA selectedColor = DEFAULT_SELECTED;
    private boolean highlight = false;
    private CommandList commands = new CommandList();

    public Button(Application app, float width, float height) {
        this(app, new Trifold(width, height), app.getAssetManager().loadTexture("Interface/BrassButton.png"));
    }

    public Button(Application app, Trifold backgroundMesh, Texture backgroundTexture) {
        this(app.getAssetManager(), backgroundMesh, backgroundTexture);
    }

    public Button(AssetManager assets, Trifold backgroundMesh, Texture backgroundTexture) {
        this.assets = assets;
        this.width = backgroundMesh.getSize().x;
        this.height = backgroundMesh.getSize().y;
        this.backgroundMesh = backgroundMesh;
        this.backgroundTexture = backgroundTexture;
        this.setupChildren();
        this.addControl((Control)new MouseEventControl());
        ((MouseEventControl)this.getControl(MouseEventControl.class)).addMouseListener(new MouseObserver());
        this.click = new AudioNode(assets, "Sounds/button-click.ogg", false);
        this.click.setPositional(false);
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public void addCommand(Command cmd) {
        this.commands.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this.commands.removeCommand(cmd);
    }

    public void setTextOffset(Vector3f offset) {
        this.textOffset.set(offset);
        this.setChildBase(0.0f, 0.0f, 0.0f);
    }

    public void setTextScale(float scale) {
        if (this.textScale == scale) {
            return;
        }
        this.textScale = scale;
        this.setChildBase(0.0f, 0.0f, 0.0f);
    }

    public void setTextColor(ColorRGBA color) {
        if (ObjectUtils.areEqual((Object)color, (Object)this.textColor)) {
            return;
        }
        ColorRGBA colorRGBA = this.textColor = color == null ? DEFAULT_COLOR : color;
        if (!this.highlight) {
            this.label.setColor(this.textColor);
            this.label.setShadowColor(this.shadowColor);
        }
    }

    public void setTextShadowColor(ColorRGBA color) {
        if (ObjectUtils.areEqual((Object)color, (Object)this.textColor)) {
            return;
        }
        ColorRGBA colorRGBA = this.shadowColor = color == null ? DEFAULT_SHADOW : color;
        if (!this.highlight) {
            this.label.setColor(this.textColor);
            this.label.setShadowColor(this.shadowColor);
        }
    }

    public void setTextSelectedColor(ColorRGBA color) {
        if (ObjectUtils.areEqual((Object)color, (Object)this.selectedColor)) {
            return;
        }
        ColorRGBA colorRGBA = this.selectedColor = color == null ? DEFAULT_SELECTED : color;
        if (this.highlight) {
            this.label.setColor(this.selectedColor);
        }
    }

    public void setBackgroundColor(ColorRGBA color) {
        this.bgMaterial.setColor("Color", color);
    }

    public void setFont(String fontName) {
        BitmapFont font = this.assets.loadFont(fontName);
        this.label.setFont(font);
    }

    private void setupChildren() {
        BitmapFont font = this.assets.loadFont("Interface/knights32.fnt");
        this.label = new Label(font);
        this.label.setColor(this.textColor);
        this.label.setShadowColor(this.shadowColor);
        this.label.setHAlignment(HAlignment.CENTER);
        this.label.setVAlignment(VAlignment.CENTER);
        this.label.setLocalScale(this.textScale);
        this.attachChild((Spatial)this.label);
        this.background = new Geometry("Button Bg", (Mesh)this.backgroundMesh);
        this.bgMaterial = new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.bgMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.bgMaterial.setTexture("ColorMap", this.backgroundTexture);
        this.background.setMaterial(this.bgMaterial);
        this.attachChild((Spatial)this.background);
        this.setChildBase(0.0f, 0.0f, 0.0f);
    }

    protected void setChildBase(float x, float y, float z) {
        this.label.setLocalTranslation(this.textOffset.x + x + this.width * 0.5f, this.textOffset.y + y + this.height * 0.5f + 2.0f, this.textOffset.z + z + 0.2f);
        this.label.setLocalScale(this.textScale);
        this.background.setLocalTranslation(x, y, z);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    protected void runCommands() {
        System.out.println("runCommands():" + (Object)((Object)this));
        this.commands.execute((Object)this, "Click");
    }

    public String toString() {
        return "Button[" + (Object)((Object)this.label) + "]";
    }

    private class MouseObserver
    implements MouseListener {
        private int xDown;
        private int yDown;

        private MouseObserver() {
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
            if (event.isPressed()) {
                this.xDown = event.getX();
                this.yDown = event.getY();
                Button.this.click.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.6f);
                Button.this.click.play();
                Button.this.setChildBase(1.0f, -2.0f, -0.1f);
            } else {
                Button.this.setChildBase(0.0f, 0.0f, 0.0f);
                int x = event.getX();
                int y = event.getY();
                if (Math.abs(x - this.xDown) < 3 && Math.abs(y - this.yDown) < 3) {
                    Button.this.runCommands();
                }
            }
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            Button.this.label.setColor(Button.this.selectedColor);
            Button.this.highlight = true;
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
            Button.this.label.setColor(Button.this.textColor);
            Button.this.label.setShadowColor(Button.this.shadowColor);
            Button.this.highlight = false;
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
        }
    }
}

