/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapFont;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import java.util.StringTokenizer;
import mythruna.client.GameClient;
import mythruna.client.ui.ActionCommand;
import mythruna.client.ui.Border;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.Label;
import mythruna.client.ui.LabelSelector;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.VAlignment;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.script.DialogOption;
import mythruna.script.DialogPrompt;
import mythruna.script.NumberParameter;
import org.progeeks.util.log.Log;

public class DialogState
extends ObservableState {
    static Log log = Log.getLog();
    private GameClient gameClient;
    private EntityData ed;
    private float scale = 1.0f;
    private Node promptPanel;
    private Border border;
    private Geometry background;
    private Node optionPanel;
    private Geometry divider;
    private BitmapFont font;
    private Label promptText;
    private EntitySet entities;
    private DialogPrompt prompt;
    private Vector3f position = new Vector3f(38.0f, 30.0f, 0.0f);
    private ColorRGBA promptColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private ColorRGBA optionColor = new ColorRGBA(0.08235294f, 0.1254902f, 0.28627452f, 1.0f);
    private ColorRGBA selectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.20784314f, 1.0f);
    private ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private ColorRGBA dividerColor = new ColorRGBA(0.5019608f, 0.34117648f, 0.23529412f, 0.35f);

    public DialogState(GameClient gameClient) {
        super("Dialog State", false);
        this.gameClient = gameClient;
        this.ed = gameClient.getEntityData();
        this.entities = this.ed.getEntities(new FieldFilter<DialogPrompt>(DialogPrompt.class, "player", gameClient.getPlayer()), DialogPrompt.class);
    }

    public void checkActive() {
        if (this.entities.applyChanges()) {
            if (this.promptPanel == null) {
                return;
            }
            if (!this.entities.getAddedEntities().isEmpty() || !this.entities.getChangedEntities().isEmpty()) {
                Entity e = this.entities.iterator().next();
                this.setPrompt(e.get(DialogPrompt.class));
            } else if (!this.entities.getRemovedEntities().isEmpty()) {
                this.setPrompt(null);
            } else {
                log.warn((Object)("Unknown state in dialog entity set.  It says there are changes but there aren't:" + this.entities));
            }
        }
    }

    protected void setPrompt(DialogPrompt prompt) {
        System.out.println("setPrompt(" + prompt + ")");
        if (this.prompt == prompt) {
            return;
        }
        this.prompt = prompt;
        if (this.prompt == null) {
            this.setEnabled(false);
        } else if (this.prompt.getOptions() == null || this.prompt.getOptions().length == 0) {
            this.gameClient.getConsole().echo(prompt.getPrompt());
            this.setEnabled(false);
        } else {
            this.updatePrompt();
            this.setEnabled(true);
        }
    }

    protected String makePromptFit(String s) {
        float max = 450.0f;
        if (this.font.getLineWidth((CharSequence)s) < max) {
            return s;
        }
        s = s.replaceAll("(\\S)<br>", "$1 <br>");
        StringBuilder sb = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, " \t\r\n");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if ("<br>".equals(next)) {
                sb.append("\n");
                line = new StringBuilder();
                continue;
            }
            line.append(next);
            if (this.font.getLineWidth((CharSequence)line) > max) {
                sb.append("\n");
                line = new StringBuilder();
                line.append(next);
            }
            if (line.length() > 0) {
                sb.append(" ");
                line.append(" ");
            }
            sb.append(next);
        }
        return sb.toString();
    }

    protected void updatePrompt() {
        System.out.println("updatePrompt()");
        Application app = this.getApplication();
        String text = this.prompt.getPrompt();
        text = this.makePromptFit(text);
        this.promptText.setText(text);
        this.optionPanel.detachAllChildren();
        float y = -24.0f;
        int index = 1;
        for (DialogOption opt : this.prompt.getOptions()) {
            Label l = new Label(this.font);
            l.setText(index + ". " + opt.getText());
            l.setColor(this.optionColor);
            l.setShadowColor(this.shadowColor);
            l.setLocalTranslation(0.0f, y, 1.0f);
            OptionCommand cmd = new OptionCommand(index);
            l.addControl((Control)new MouseEventControl(new LabelCommandAdapter(l, cmd)));
            this.optionPanel.attachChild((Spatial)l);
            y -= 35.0f;
            ++index;
        }
        float height = this.promptText.getHeight() + 30.0f;
        y = Math.max(height, 170.0f);
        this.promptText.setLocalTranslation(39.0f, 564.0f - y * 0.5f, 0.1f);
        this.divider.setLocalTranslation(14.0f, 564.0f - y, 0.1f);
        this.optionPanel.setLocalTranslation(39.0f, 564.0f - (y += 14.0f), 0.0f);
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.font = app.getAssetManager().loadFont("Interface/templar32.fnt");
        GuiAppState guiState = this.getState(GuiAppState.class);
        this.scale = (float)guiState.getCamera().getHeight() / 720.0f;
        if (this.scale > 1.0f) {
            this.scale = 1.0f;
        }
        Camera cam = app.getCamera();
        this.promptPanel = new Node("Prompt");
        this.promptPanel.setLocalScale(this.scale);
        this.border = new Border(528.0f, 564.0f, app.getAssetManager());
        this.promptPanel.attachChild((Spatial)this.border);
        Quad quad = new Quad(528.0f, 564.0f);
        float x = 2.0625f;
        float y = 2.203125f;
        quad.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, y, x, y, x, 0.0f, 0.0f, 0.0f});
        this.background = new Geometry("bg", (Mesh)quad);
        Material m = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        Texture t = app.getAssetManager().loadTexture("Textures/sand.jpg");
        t.setWrap(Texture.WrapMode.Repeat);
        m.setTexture("ColorMap", t);
        m.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.85f));
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.background.setMaterial(m);
        this.background.setLocalTranslation(0.0f, 0.0f, -0.1f);
        this.promptPanel.attachChild((Spatial)this.background);
        this.promptText = new Label(this.font);
        this.promptText.setText("Testing");
        this.promptText.setVAlignment(VAlignment.CENTER);
        this.promptText.setLocalTranslation(39.0f, 479.0f, 0.1f);
        this.promptText.setColor(this.promptColor);
        this.promptText.setShadowColor(this.shadowColor);
        this.promptPanel.attachChild((Spatial)this.promptText);
        this.optionPanel = new Node("Options");
        this.optionPanel.setLocalTranslation(39.0f, 370.0f, 0.0f);
        this.promptPanel.attachChild((Spatial)this.optionPanel);
        Material horzMat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/sand.jpg");
        key.setGenerateMips(false);
        t = app.getAssetManager().loadTexture(key);
        t.setWrap(Texture.WrapMode.Repeat);
        horzMat.setTexture("ColorMap", t);
        horzMat.setColor("Color", this.dividerColor);
        horzMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Quad horizontal = new Quad(500.0f, 6.0f);
        y = 0.0234375f;
        horizontal.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, y, x /= 256.0f, y, x, 0.0f, 0.0f, 0.0f});
        this.divider = new Geometry("horz divider", (Mesh)horizontal);
        this.divider.setMaterial(horzMat);
        this.divider.setLocalTranslation(14.0f, 394.0f, 0.0f);
        this.promptPanel.attachChild((Spatial)this.divider);
    }

    protected void enable() {
        super.enable();
        GuiAppState guiState = this.getState(GuiAppState.class);
        guiState.addDependent(this);
        Camera cam = guiState.getCamera();
        this.promptPanel.setLocalTranslation(this.position.x, (float)cam.getHeight() - this.border.getHeight() - this.position.y, this.position.z);
        guiState.getOrthoRoot().attachChild((Spatial)this.promptPanel);
    }

    protected void disable() {
        super.disable();
        GuiAppState guiState = this.getState(GuiAppState.class);
        guiState.removeDependent(this);
        guiState.getOrthoRoot().detachChild((Spatial)this.promptPanel);
    }

    public void render(RenderManager rm) {
        super.render(rm);
    }

    public void update(float tpf) {
    }

    protected class OptionCommand
    extends ActionCommand {
        private int number;

        public OptionCommand(int number) {
            super("Option " + number);
            this.number = number;
        }

        public void execute(Object source, Object action) {
            DialogState.this.gameClient.execute("DialogOption", DialogState.this.gameClient.getPlayer(), new NumberParameter(this.number));
        }
    }

    protected class LabelCommandAdapter
    extends LabelSelector {
        private ActionCommand cmd;

        public LabelCommandAdapter(Label label, ActionCommand cmd) {
            super(label, DialogState.this.optionColor, DialogState.this.shadowColor, DialogState.this.selectColor);
            this.cmd = cmd;
        }

        public void click(MouseButtonEvent event) {
            event.setConsumed();
            System.out.println("Click.");
            if (this.cmd != null) {
                this.cmd.execute(this, null);
            }
        }
    }
}

