/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.audio.AudioNode;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.client.ui.ObservableState;

public class MessageLog
extends ObservableState {
    private static MessageLog instance = new MessageLog();
    private float visibleTime = 15.0f;
    private Node node;
    private BitmapFont font;
    private float fontSize;
    private int backlog = 20;
    private List<MessageEntry> log = new CopyOnWriteArrayList<MessageEntry>();
    private float screenHeight;
    private float screenWidth;
    private float y;
    private float yTarget = 0.0f;
    private float rate = 0.0f;
    private int lastSize = 0;
    private AudioNode ping;
    private float alphaOverride = 0.0f;
    private boolean playSound = false;

    protected MessageLog() {
        super("MessageLog", true);
    }

    public void setAllVisible(boolean f) {
        this.alphaOverride = f ? 1.0f : 0.0f;
    }

    public void move(float yNew, float duration) {
        this.yTarget = yNew;
        this.rate = (yNew - this.y) / duration;
    }

    protected void initialize(Application app) {
        super.initialize(app);
        Camera cam = app.getCamera();
        this.screenHeight = cam.getHeight();
        this.screenWidth = cam.getWidth();
        this.font = app.getAssetManager().loadFont("Interface/knights24.fnt");
        this.ping = new AudioNode(app.getAssetManager(), "Sounds/paper-small.wav", false);
        this.ping.setReverbEnabled(false);
        this.node = new Node("MessageLog");
        this.node.setLocalTranslation(3.0f, 0.0f, -10.0f);
        this.fontSize = this.font.getPreferredSize();
        int count = (int)(this.screenHeight / this.fontSize);
        if (count > this.backlog) {
            this.backlog = count;
        } else {
            this.fontSize = this.screenHeight / (float)this.backlog;
        }
    }

    protected void enable() {
        if (this.node.getParent() != null) {
            return;
        }
        Node guiNode = ((SimpleApplication)this.getApplication()).getGuiNode();
        guiNode.attachChild((Spatial)this.node);
    }

    protected void disable() {
        Node guiNode = ((SimpleApplication)this.getApplication()).getGuiNode();
        guiNode.detachChild((Spatial)this.node);
    }

    public void update(float tpf) {
        if (this.playSound) {
            this.ping.playInstance();
            this.playSound = false;
        }
        int oldSize = this.lastSize;
        this.lastSize = this.log.size();
        int delta = this.lastSize - oldSize;
        if (delta > 0) {
            float time = Math.min(1.0f, (float)delta * 0.2f);
            float yStart = (float)(-delta) * this.fontSize;
            int line = 1;
            for (MessageEntry e : this.log) {
                if (line <= delta) {
                    e.setLocalTranslation(0.0f, yStart + (float)line * this.fontSize, 0.0f);
                    this.node.attachChild((Spatial)e.getText());
                }
                e.move((float)line * this.fontSize, time);
                ++line;
            }
        } else if (delta < 0) {
            throw new RuntimeException("how did the message log shrink without us knowing?");
        }
        for (MessageEntry e : this.log) {
            e.update(tpf);
            if (!e.isDone()) continue;
            System.out.println("Dropping message:" + e.message);
            this.node.detachChild((Spatial)e.text);
            this.log.remove(e);
            --this.lastSize;
        }
        if (this.rate != 0.0f) {
            float temp = this.y + this.rate * tpf;
            if (this.rate > 0.0f && temp > this.yTarget || this.rate < 0.0f && temp < this.yTarget) {
                this.rate = 0.0f;
                this.y = this.yTarget;
                Vector3f loc = this.node.getLocalTranslation();
                this.node.setLocalTranslation(loc.x, this.y, loc.z);
            } else if ((double)Math.abs(temp - this.y) > 0.1) {
                Vector3f loc = this.node.getLocalTranslation();
                this.y = temp;
                this.node.setLocalTranslation(loc.x, this.y, loc.z);
            }
        }
    }

    public void add(String msg) {
        if (msg.indexOf(10) >= 0 || msg.indexOf(13) >= 0) {
            StringTokenizer st = new StringTokenizer(msg, "\r\n");
            while (st.hasMoreTokens()) {
                this.add(st.nextToken());
            }
            return;
        }
        if (this.font != null) {
            float lineWidth = this.font.getLineWidth((CharSequence)msg);
            while (lineWidth > this.screenWidth - 20.0f) {
                int index = (int)((this.screenWidth - 20.0f) / lineWidth * (float)msg.length());
                index = Math.min(msg.length() - 1, index);
                String sub = msg.substring(0, index);
                int split = sub.lastIndexOf(32);
                if (split < 0) {
                    this.add(sub);
                    msg = msg.substring(index);
                } else {
                    sub = sub.substring(0, split);
                    this.add(sub);
                    msg = msg.substring(split);
                }
                lineWidth = this.font.getLineWidth((CharSequence)msg);
            }
        }
        this.log.add(0, new MessageEntry(msg));
    }

    public static void addMessage(String msg) {
        MessageLog.addMessage(msg, false);
    }

    public static void addMessage(String msg, boolean makeSound) {
        MessageLog.getInstance().add(msg);
        if (makeSound && MessageLog.getInstance().ping != null) {
            MessageLog.getInstance().playSound = true;
        }
    }

    public static MessageLog getInstance() {
        return instance;
    }

    private class MessageEntry {
        private float timeVisible = 0.0f;
        private String message;
        private volatile BitmapText text;
        private BitmapText textShadow;
        private float y = 0.0f;
        private float yTarget = 0.0f;
        private float rate = 0.0f;
        private float alpha = 1.0f;

        public MessageEntry(String message) {
            this.message = message;
        }

        public void move(float yNew, float duration) {
            this.y = this.getText().getLocalTranslation().y;
            this.yTarget = yNew;
            this.rate = (yNew - this.y) / duration;
        }

        public boolean isDone() {
            if (this.text == null) {
                return false;
            }
            return this.y > MessageLog.this.screenHeight - this.text.getLineHeight();
        }

        protected float getTargetAlpha() {
            if (MessageLog.this.alphaOverride != 0.0f) {
                return MessageLog.this.alphaOverride;
            }
            return Math.max(0.0f, (MessageLog.this.visibleTime - this.timeVisible) / MessageLog.this.visibleTime);
        }

        public void setLocalTranslation(float x, float y, float z) {
            this.getText().setLocalTranslation(x, y, z);
            float lineHeight = this.getText().getHeight();
            if (y < lineHeight) {
                this.getText().setCullHint(Spatial.CullHint.Always);
            } else {
                this.getText().setCullHint(Spatial.CullHint.Inherit);
            }
        }

        public void update(float tpf) {
            float temp;
            if (this.y > 0.0f) {
                if (MessageLog.this.alphaOverride == 0.0f) {
                    this.timeVisible += tpf;
                }
                if ((double)Math.abs((temp = this.getTargetAlpha()) - this.alpha) > 0.01 || temp == 0.0f && this.alpha != 0.0f) {
                    this.alpha = temp;
                    this.text.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, this.alpha));
                    this.textShadow.setColor(new ColorRGBA(0.0f, 0.0f, 0.0f, this.alpha));
                }
            }
            if (this.rate != 0.0f) {
                temp = this.y + this.rate * tpf;
                if (this.rate > 0.0f && temp > this.yTarget || this.rate < 0.0f && temp < this.yTarget) {
                    this.rate = 0.0f;
                    this.y = this.yTarget;
                    Vector3f loc = this.getText().getLocalTranslation();
                    this.setLocalTranslation(loc.x, this.y, loc.z);
                } else if ((double)Math.abs(temp - this.y) > 0.1) {
                    Vector3f loc = this.getText().getLocalTranslation();
                    this.y = temp;
                    this.setLocalTranslation(loc.x, this.y, loc.z);
                }
            }
        }

        public BitmapText getText() {
            if (this.text != null) {
                return this.text;
            }
            this.text = new BitmapText(MessageLog.this.font, false);
            this.text.setSize(MessageLog.this.fontSize);
            this.text.setText(this.message);
            this.text.setColor(ColorRGBA.White);
            this.textShadow = new BitmapText(MessageLog.this.font, false);
            this.textShadow.setSize(MessageLog.this.fontSize);
            this.textShadow.setText(this.message);
            this.textShadow.setColor(ColorRGBA.Black);
            this.textShadow.setLocalTranslation(1.0f, -1.0f, -2.0f);
            this.text.attachChild((Spatial)this.textShadow);
            return this.text;
        }
    }
}

