/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.audio.AudioNode;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import mythruna.MaterialIndex;
import mythruna.client.ClientOptions;
import mythruna.client.ConveyerCamera;
import mythruna.client.GameClient;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.ui.ActionCommand;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.Label;
import mythruna.client.ui.LabelSelector;
import mythruna.client.ui.MouseAdapter;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.StringEntryState;
import mythruna.client.ui.VAlignment;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.Name;
import mythruna.geom.Trifold;
import mythruna.script.ActionParameter;
import mythruna.script.ActionReference;
import mythruna.script.ActionType;
import mythruna.script.ComponentParameter;
import mythruna.script.ContextActions;
import org.progeeks.util.log.Log;

public class PopupMenuState
extends ObservableState {
    static Log log = Log.getLog();
    private static final ColorRGBA titleColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA selectColor = new ColorRGBA(0.12156863f, 0.39215687f, 0.20784314f, 1.0f);
    private static final ColorRGBA itemColor = new ColorRGBA(0.24313726f, 0.24313726f, 0.41568628f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private GameClient gameClient;
    private EntityData ed;
    private AudioNode switchOn;
    private AudioNode switchOff;
    private AudioNode click;
    private Node buttons;
    private float buttonScale = 1.0f;
    private boolean mouseWasEnabled = false;
    private ColorRGBA enabledColor = new ColorRGBA(0.20392157f, 0.44313726f, 0.8392157f, 1.0f);
    private EntitySet entities;
    private ContextActions actions;

    public PopupMenuState(GameClient gameClient) {
        super("Context Popup Menu", false);
        this.gameClient = gameClient;
        this.ed = gameClient.getEntityData();
        this.entities = this.ed.getEntities(new FieldFilter<ContextActions>(ContextActions.class, "player", gameClient.getPlayer()), ContextActions.class);
    }

    public void checkActive() {
        if (this.entities.applyChanges()) {
            if (this.buttons == null) {
                return;
            }
            if (!this.entities.getAddedEntities().isEmpty() || !this.entities.getChangedEntities().isEmpty()) {
                Entity e = this.entities.iterator().next();
                this.setActions(e.get(ContextActions.class));
            } else if (!this.entities.getRemovedEntities().isEmpty()) {
                this.setActions(null);
            } else {
                log.warn((Object)("Unknown state in actions entity set.  It says there are changes but there aren't:" + this.entities));
            }
        }
    }

    protected void setActions(ContextActions actions) {
        System.out.println("setActions(" + actions + ")");
        if (this.actions == actions) {
            return;
        }
        this.actions = actions;
        if (this.actions == null) {
            this.setEnabled(false);
        } else {
            this.updateActions();
            this.setEnabled(true);
        }
    }

    protected void updateActions() {
        Application app = this.getApplication();
        Camera cam = this.getApplication().getCamera();
        Vector3f pos = this.actions.getPosition();
        if (pos == null) {
            pos = new Vector3f((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, 0.0f);
        }
        this.buttons.setLocalTranslation(pos.x, pos.y, 10.0f);
        this.buttons.detachAllChildren();
        String name = this.actions.getName();
        String title = this.actions.getTitle();
        EntityId target = this.actions.getTarget();
        ActionReference[] refs = this.actions.getActions();
        float y = 0.0f;
        ColorRGBA titleColor = new ColorRGBA(0.0f, 0.0f, 0.2f, 1.0f);
        ColorRGBA bgColor = new ColorRGBA(0.5f, 0.5f, 0.4f, 1.0f);
        Label l = new Label(app);
        l.setText(name);
        l.setColor(titleColor);
        l.setShadowColor(new ColorRGBA(0.9f, 0.9f, 1.0f, 1.0f));
        l.setVAlignment(VAlignment.TOP);
        l.setLocalTranslation(0.0f, y, 2.0f);
        this.buttons.attachChild((Spatial)l);
        float yDiv = (y -= 28.0f) - 4.0f;
        float width = l.getWidth();
        float xOffset = 5.0f;
        for (ActionReference ar : refs) {
            l = new Label(app);
            l.setText(ar.getName());
            l.setColor(itemColor);
            l.setShadowColor(shadowColor);
            l.setVAlignment(VAlignment.TOP);
            l.setLocalTranslation(0.0f, y, 2.0f);
            NamedActionCommand cmd = new NamedActionCommand(ar, target, this.actions.getParameter());
            l.addControl((Control)new MouseEventControl(new LabelCommandAdapter(l, cmd)));
            this.buttons.attachChild((Spatial)l);
            y -= 24.0f;
            width = Math.max(width, l.getWidth());
        }
        y -= 10.0f;
        float xMarginLeft = 7.0f;
        float xMarginRight = 17.0f;
        float yMarginTop = 7.0f;
        float yMarginBottom = 18.0f;
        Quad div = new Quad(width, 4.0f);
        Geometry divGeom = new Geometry("div", (Mesh)div);
        Material mDiv = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mDiv.setColor("Color", new ColorRGBA(0.43529412f, 0.19607843f, 0.19607843f, 1.0f));
        divGeom.setMaterial(mDiv);
        divGeom.setLocalTranslation(0.0f, yDiv, 0.1f);
        this.buttons.attachChild((Spatial)divGeom);
        float quadWidth = width + 2.0f * xOffset + xMarginLeft + xMarginRight;
        float quadHeight = Math.abs(y) + yMarginTop + yMarginBottom;
        Trifold quad = new Trifold(quadWidth, quadHeight);
        quad.setFoldCoordinates(new Vector2f(21.0f, 18.0f), new Vector2f(quadWidth - 17.0f, quadHeight - 21.0f));
        quad.setFoldTextureCoordinates(new Vector2f(0.328125f, 0.28125f), new Vector2f(0.734375f, 0.671875f));
        quad.updateGeometry();
        Geometry bg = new Geometry("menu bg", (Mesh)quad);
        Material m = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        m.setTexture("ColorMap", app.getAssetManager().loadTexture("Interface/popup-border.png"));
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        bg.setMaterial(m);
        bg.setLocalTranslation(-xOffset - xMarginLeft, y - yMarginBottom, -0.1f);
        this.buttons.attachChild((Spatial)bg);
        Quad cancel = new Quad((float)cam.getWidth(), (float)cam.getHeight());
        Geometry cancelGeom = new Geometry("Cancel BG", (Mesh)cancel);
        m = MaterialIndex.TRANSPARENT_MATERIAL.clone();
        cancelGeom.setMaterial(m);
        cancelGeom.addControl((Control)new MouseEventControl(new CommandAdapter(new CancelCommand())));
        cancelGeom.setLocalTranslation(-pos.x, -pos.y, -0.2f);
        this.buttons.attachChild((Spatial)cancelGeom);
    }

    protected void initialize(Application app) {
        super.initialize(app);
        Camera cam = app.getCamera();
        float radialScale = 1.0f;
        this.buttonScale = Math.min(1.0f, (float)cam.getWidth() / 1000.0f);
        this.buttons = new Node("PopupMenu");
        this.buttons.setLocalTranslation((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, 0.0f);
        this.buttons.setLocalScale(this.buttonScale);
        this.switchOn = new AudioNode(app.getAssetManager(), "Sounds/switch.ogg", false);
        this.switchOn.setPositional(false);
        this.switchOff = new AudioNode(app.getAssetManager(), "Sounds/switch-off-short.ogg", false);
        this.switchOff.setPositional(false);
        this.click = new AudioNode(app.getAssetManager(), "Sounds/button-click.ogg", false);
        this.click.setPositional(false);
    }

    protected void enable() {
        super.enable();
        GuiAppState guiState = this.getState(GuiAppState.class);
        Camera cam = guiState.getCamera();
        float radialScale = (float)cam.getHeight() / 720.0f;
        this.switchOn.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
        this.switchOn.play();
        Node gui = guiState.getOrthoRoot();
        guiState.addDependent(this);
        gui.attachChild((Spatial)this.buttons);
        this.buttons.setLocalScale(0.01f);
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.buttons, 0.01f, this.buttonScale, 0.25f));
        this.mouseWasEnabled = this.getState(ConveyerCamera.class).isEnabled();
        this.getState(ConveyerCamera.class).setEnabled(false);
    }

    protected void disable() {
        super.disable();
        this.getState(ConveyerCamera.class).setEnabled(this.mouseWasEnabled);
        this.gameClient.execute("Close Context Menu", null, null);
        GuiAppState guiState = this.getState(GuiAppState.class);
        Node gui = this.getState(GuiAppState.class).getOrthoRoot();
        this.getState(AnimationState.class).add(Animation.detach((Spatial)this.buttons, 0.25f));
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.buttons, this.buttonScale, 0.01f, 0.25f));
        guiState.removeDependent(this, 0.25f);
    }

    public void render(RenderManager rm) {
        super.render(rm);
    }

    public void update(float tpf) {
    }

    protected class CancelCommand
    extends ActionCommand {
        public CancelCommand() {
            super("Cancel");
        }

        public void execute(Object source, Object a) {
            PopupMenuState.this.switchOff.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
            PopupMenuState.this.switchOff.play();
            PopupMenuState.this.setEnabled(false);
        }
    }

    protected class SetNameCommand
    extends ActionCommand {
        private ActionReference ref;
        private EntityId target;

        public SetNameCommand(ActionReference ref, EntityId target) {
            super("Set Name");
            this.target = target;
            this.ref = ref;
        }

        public void execute(Object source, Object a) {
            PopupMenuState.this.setEnabled(false);
            System.out.println("Source:" + source);
            StringEntryState state = (StringEntryState)((Object)source);
            System.out.println("Entered text:" + state.getText());
            String s = state.getText().trim();
            if (s.length() > 25) {
                s = s.substring(0, 25);
            }
            Name name = new Name(s);
            PopupMenuState.this.gameClient.executeRef(this.ref, this.target, new ComponentParameter(name));
        }
    }

    protected class NamedActionCommand
    extends ActionCommand {
        private ActionReference ref;
        private EntityId target;
        private ActionParameter parm;

        public NamedActionCommand(ActionReference ref, EntityId target, ActionParameter parm) {
            super(ref.getName());
            this.target = target;
            this.ref = ref;
            this.parm = parm;
        }

        public void execute(Object source, Object a) {
            if (this.ref.getType() == ActionType.NameComponent) {
                StringEntryState state = new StringEntryState("Enter a New Name", new SetNameCommand(this.ref, this.target), new CancelCommand());
                PopupMenuState.this.getApplication().getStateManager().attach((AppState)state);
                return;
            }
            PopupMenuState.this.click.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
            PopupMenuState.this.click.play();
            PopupMenuState.this.setEnabled(false);
            PopupMenuState.this.gameClient.executeRef(this.ref, this.target, this.parm);
        }
    }

    protected class CommandAdapter
    extends MouseAdapter {
        private ActionCommand cmd;

        public CommandAdapter(ActionCommand cmd) {
            this.cmd = cmd;
        }

        public void click(MouseButtonEvent event) {
            event.setConsumed();
            this.cmd.execute(this, null);
        }
    }

    protected class LabelCommandAdapter
    extends LabelSelector {
        private ActionCommand cmd;

        public LabelCommandAdapter(Label label, ActionCommand cmd) {
            super(label, itemColor, shadowColor, selectColor);
            this.cmd = cmd;
        }

        public void click(MouseButtonEvent event) {
            event.setConsumed();
            this.cmd.execute(this, null);
        }
    }
}

