/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;
import mythruna.World;
import mythruna.client.view.BuilderReference;
import mythruna.client.view.LocalArea;
import mythruna.db.BlueprintData;
import mythruna.es.EntityId;
import mythruna.geom.GeomPartBuffer;
import mythruna.geom.LeafMesh;
import mythruna.util.LruCache;
import org.progeeks.util.log.Log;

public class BlockObject
implements Cloneable,
BuilderReference {
    static Log log = Log.getLog();
    private static LruCache<Long, Node> meshCache = new LruCache("ObjectMeshes", 200);
    private static long instanceCount = 0L;
    private long id = instanceCount++;
    private Vector3f position = new Vector3f();
    private Quaternion rotation = new Quaternion();
    private int xSize;
    private int ySize;
    private int zSize;
    private int[][][] cells;
    private float sunlight = 1.0f;
    private float localLight = 0.0f;
    private float scale = 0.25f;
    private World world;
    private long blueprintId;
    private EntityId entity;
    private Node node;
    private Node builder;
    private boolean built = false;
    private boolean cache = true;

    public BlockObject(int xSize, int ySize, int zSize) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.cells = new int[xSize][ySize][zSize];
    }

    public BlockObject(BlueprintData data) {
        this(data, true);
    }

    public BlockObject(BlueprintData data, boolean cache) {
        this.xSize = data.xSize;
        this.ySize = data.ySize;
        this.zSize = data.zSize;
        this.scale = data.scale;
        this.cells = data.cells;
        this.blueprintId = data.id;
        this.cache = false;
    }

    public BlockObject(World world, long blueprintId) {
        this.world = world;
        this.blueprintId = blueprintId;
        Node cached = meshCache.get(blueprintId);
        if (cached != null) {
            this.node = (Node)cached.deepClone();
            this.node.setName(String.valueOf(this));
            this.scale = this.node.getLocalScale().x;
            this.uncloneMaterials(cached, this.node);
            this.built = true;
            this.cache = false;
            this.relight(this.node);
        }
    }

    public long getBlueprintId() {
        return this.blueprintId;
    }

    public void setBlueprintId(long blueprintId) {
        if (this.blueprintId == blueprintId) {
            return;
        }
        this.blueprintId = blueprintId;
        Node cached = meshCache.get(blueprintId);
        if (cached != null) {
            Node newNode = (Node)cached.deepClone();
            newNode.setName(String.valueOf(this));
            this.scale = newNode.getLocalScale().x;
            this.uncloneMaterials(cached, newNode);
            this.cache = false;
            this.builder = newNode;
            this.relight(this.builder);
            this.built = false;
            this.applyUpdates(null);
            this.built = true;
        } else {
            this.cells = null;
            this.built = false;
        }
    }

    public void setEntity(EntityId e) {
        this.entity = e;
    }

    public EntityId getEntity() {
        return this.entity;
    }

    protected void uncloneMaterials(Node original, Node clone) {
        int count = original.getQuantity();
        for (int i = 0; i < count; ++i) {
            Spatial s1 = original.getChild(i);
            Spatial s2 = clone.getChild(i);
            if (!(s1 instanceof Geometry)) continue;
            s2.setMaterial(((Geometry)s1).getMaterial());
        }
    }

    protected void dumpControls(Spatial s) {
        System.out.println("Spatial:" + s + "  controls:");
        for (int i = 0; i < s.getNumControls(); ++i) {
            System.out.println(" [" + i + "] = " + s.getControl(i));
        }
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                this.dumpControls(child);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    public int[][][] getCells() {
        return this.cells;
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public void setPosition(Vector3f v) {
        this.position.set(v);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setRotation(Quaternion rot) {
        this.rotation.set(rot);
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getSizeZ() {
        return this.zSize;
    }

    public void setScale(float scale) {
        this.scale = scale;
        if (this.node != null) {
            this.node.setLocalScale(scale);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setType(int i, int j, int k, int type) {
        this.cells[i][j][k] = type;
    }

    public BlockObject cloneFully() {
        try {
            BlockObject clone = (BlockObject)super.clone();
            clone.position = this.position.clone();
            clone.rotation = this.rotation.clone();
            clone.id = instanceCount++;
            if (this.node == null) {
                throw new RuntimeException("Cannot clone an unbuilt block object.");
            }
            clone.node = this.node.clone(false);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen", e);
        }
    }

    protected int getAdjacent(int x, int y, int z, int d) {
        if ((x += Direction.DIRS[d][0]) < 0 || (y += Direction.DIRS[d][1]) < 0 || (z += Direction.DIRS[d][2]) < 0) {
            return 0;
        }
        if (x >= this.xSize || y >= this.ySize || z >= this.zSize) {
            return 0;
        }
        return this.cells[x][y][z];
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = new Node(String.valueOf(this));
            this.node.setLocalScale(this.scale);
        }
        return this.node;
    }

    public boolean isBuilt() {
        return this.built;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        if (this.builder != null || this.isBuilt()) {
            log.info((Object)"Canceling build for already built object.");
            return;
        }
        Node cached = meshCache.get(this.blueprintId);
        if (cached != null) {
            this.builder = (Node)cached.deepClone();
            this.builder.setName(String.valueOf(this) + ":builderClone");
            this.uncloneMaterials(cached, this.builder);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reused existing geometry for:" + this));
            }
            this.relight(this.builder);
            return;
        }
        if (this.cells == null) {
            BlueprintData data = this.world.getBlueprint(this.blueprintId);
            this.xSize = data.xSize;
            this.ySize = data.ySize;
            this.zSize = data.zSize;
            this.scale = data.scale;
            this.cells = data.cells;
            this.blueprintId = data.id;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating builder node for:" + this));
        }
        this.builder = new Node(String.valueOf(this) + ":builder");
        BlockObject blockObject = this;
        synchronized (blockObject) {
            this.generateNode(this.builder, this.sunlight, this.localLight);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Geometry generated.");
        }
    }

    public void applyUpdates(LocalArea parent) {
        if (this.isBuilt()) {
            return;
        }
        if (this.node != null && this.node.getParent() == null) {
            log.info((Object)"Canceling applyUpdates for detached node.");
            return;
        }
        this.getNode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Applying updates for:" + this));
        }
        this.node.detachAllChildren();
        ArrayList children = new ArrayList(this.builder.getChildren());
        this.builder.detachAllChildren();
        for (Spatial s : children) {
            this.node.attachChild(s);
        }
        this.node.setLocalScale(this.scale);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Builder done for:" + this));
        }
        this.builder = null;
        if (this.cache && !meshCache.containsKey(this.blueprintId)) {
            Node cacheNode = (Node)this.node.deepClone();
            this.uncloneMaterials(this.node, cacheNode);
            meshCache.put(this.blueprintId, cacheNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLighting(float sunlight, float localLight) {
        if (this.sunlight == sunlight && this.localLight == localLight) {
            return;
        }
        BlockObject blockObject = this;
        synchronized (blockObject) {
            this.sunlight = sunlight;
            this.localLight = localLight;
        }
        if (this.node != null) {
            this.relight(this.node, sunlight, localLight);
        }
    }

    protected void relight(Node n) {
        this.relight(n, this.sunlight, this.localLight);
    }

    protected void relight(Node n, float sun, float local) {
        for (Spatial child : n.getChildren()) {
            Mesh m;
            if (!(child instanceof Geometry) || !((m = ((Geometry)child).getMesh()) instanceof LeafMesh)) continue;
            ((LeafMesh)m).relight(sun, local);
        }
    }

    public GeomPartBuffer generateParts(float sun, float localLight) {
        GeomPartBuffer parts = new GeomPartBuffer();
        for (int k = 0; k < this.zSize; ++k) {
            for (int i = 0; i < this.xSize; ++i) {
                for (int j = 0; j < this.ySize; ++j) {
                    int d;
                    int t = this.cells[i][j][k];
                    BlockType type = BlockTypeIndex.types[t];
                    if (t != 0) {
                        d = -1;
                        if (k == 0) {
                            d = 5;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (i == 0) {
                            d = 3;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (j == 0) {
                            d = 0;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (k == this.zSize - 1) {
                            d = 4;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (i == this.xSize - 1) {
                            d = 2;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (j == this.ySize - 1) {
                            d = 1;
                            type.getGeomFactory().createGeometry(parts, i, j, k, i, j, k, sun, localLight, type, d);
                        }
                        if (type.isSolid() && type.getGroup() == 0) continue;
                    }
                    for (d = 0; d < 6; ++d) {
                        int adj = this.getAdjacent(i, j, k, d);
                        if (adj == 0) continue;
                        BlockType adjType = BlockTypeIndex.types[adj];
                        if (type != null && adjType.getGroup() == type.getGroup() && (adjType.getGroup() != 0 || type.isSolid(d))) continue;
                        int x = i + Direction.DIRS[d][0];
                        int y = j + Direction.DIRS[d][1];
                        int z = k + Direction.DIRS[d][2];
                        int back = Direction.INVERSE[d];
                        adjType.getGeomFactory().createGeometry(parts, x, y, z, x, y, z, sun, localLight, adjType, back);
                    }
                    if (t == 0 || type.isSolid()) continue;
                    type.getGeomFactory().createInternalGeometry(parts, i, j, k, i, j, k, sun, localLight, type);
                }
            }
        }
        return parts;
    }

    protected Node generateNode(Node node, float sun, float localLight) {
        GeomPartBuffer parts = this.generateParts(sun, localLight);
        parts.createGeometry(node, (float)(-this.xSize) / 2.0f, (float)(-this.ySize) / 2.0f, 0.0f);
        return node;
    }
}

