/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.Coordinates;
import mythruna.MaterialIndex;
import mythruna.Vector3i;
import mythruna.client.view.RopeLink;
import mythruna.client.view.RopeMesh;
import mythruna.es.ChangeQueue;
import mythruna.es.Entity;
import mythruna.es.EntityChange;
import mythruna.es.EntityComponent;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntityProcessor;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.ModelInfo;
import mythruna.es.ObservableEntityData;
import mythruna.es.OrFilter;
import mythruna.es.Position;
import mythruna.phys.Mass;
import mythruna.phys.PhysicalLink;
import mythruna.phys.Rope;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RopeControl
extends AbstractControl {
    static Log log = Log.getLog();
    private ObservableEntityData ed;
    private EntitySet entities;
    private RopeMesh ropeMesh;
    private Node ropeNode;
    private Map<EntityId, SimpleBody> simpleBodies = new ConcurrentHashMap<EntityId, SimpleBody>();
    private Map<EntityId, BodyLink> links = new HashMap<EntityId, BodyLink>();
    private ChangeQueue changes;
    private FieldFilter<Position>[] filters;
    private ConcurrentLinkedQueue<BodyLink> newLinks = new ConcurrentLinkedQueue();
    private Vector3f worldBase = new Vector3f();

    public RopeControl(ObservableEntityData ed) {
        this.ed = ed;
        super.setEnabled(true);
        this.ropeMesh = new RopeMesh();
        Geometry geom = new Geometry("Ropes", (Mesh)this.ropeMesh);
        geom.setMaterial(MaterialIndex.ROPE_MATERIAL);
        this.ropeNode = new Node("Ropes");
        this.ropeNode.attachChild((Spatial)geom);
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        this.initialize();
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("This control cannot be cloned.");
    }

    protected void setupFilters(Vector3i areaLocation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("RopeControl.setupFilters(" + areaLocation + ")"));
        }
        int width = 1;
        int xCenter = areaLocation.x + 6;
        int yCenter = areaLocation.x + 6;
        if (this.filters == null) {
            int filterCount = width * 2 + 1;
            filterCount *= filterCount;
            this.filters = new FieldFilter[filterCount];
        }
        int i = 0;
        for (int x = xCenter - width; x <= xCenter + width; ++x) {
            for (int y = yCenter - width; y <= yCenter + width; ++y) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("catch[" + x + ", " + y + "]"));
                }
                long colId = Coordinates.leafToColumnId(x, y);
                this.filters[i++] = FieldFilter.create(Position.class, "columnId", colId);
            }
        }
        OrFilter<Position> f = OrFilter.create(Position.class, this.filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filter:" + f));
        }
        if (this.entities == null) {
            this.entities = this.ed.getEntities(f, Position.class, ModelInfo.class, Mass.class);
            this.addChildren(this.entities);
        } else if (this.entities.resetFilter(f)) {
            this.processChanges();
        }
    }

    protected void processChanges() {
        this.removeChildren(this.entities.getRemovedEntities());
        this.addChildren(this.entities.getAddedEntities());
        this.updateChildren(this.entities.getChangedEntities());
    }

    protected void initialize() {
        System.out.println("RopeControl.initialize()");
        this.changes = this.ed.getChangeQueue(Rope.class, PhysicalLink.class);
        ((Node)this.spatial).attachChild((Spatial)this.ropeNode);
    }

    protected void terminate() {
        ((Node)this.spatial).detachChild((Spatial)this.ropeNode);
        this.changes.release();
        if (this.entities != null) {
            this.removeChildren(this.entities);
            this.entities.release();
            this.entities = null;
        }
    }

    public void setLocation(Vector3i areaLocation, int clipDistance) {
        this.setupFilters(areaLocation);
        this.setWorldLocation(Coordinates.leafToWorld(areaLocation), clipDistance);
    }

    public void setWorldLocation(Vector3i worldLocation, int clipDistance) {
        System.out.println("RopeControl.setWorldLocation(" + worldLocation + ")");
        float x = 0 - worldLocation.x;
        float y = 0 - worldLocation.y;
        float z = 0.0f;
        this.ropeNode.setLocalTranslation(x, z, y);
        this.worldBase.set(x, z, y);
    }

    public void activate(Entity e) {
    }

    public void deactivate(Entity e) {
    }

    protected void addChildren(Set<Entity> set) {
        for (Entity e : set) {
            this.ed.execute(new LinkLoader(e));
        }
    }

    protected void updateChildren(Set<Entity> set) {
        for (Entity e : set) {
            for (BodyLink l : this.links.values()) {
                l.entityChanged(e);
            }
        }
    }

    protected void removeChildren(Set<Entity> set) {
        for (Entity entity : set) {
        }
    }

    protected void componentChange(EntityChange c) {
        EntityId id = c.getEntityId();
        EntityComponent comp = c.getComponent();
        if (comp instanceof Rope) {
            float x = (float)(Math.random() * 64.0 - 32.0);
            float y = (float)(Math.random() * 64.0 + 70.0);
            float z = (float)(Math.random() * 64.0 - 32.0);
            Vector3f v1 = new Vector3f(x, y, z);
            x = (float)(Math.random() * 64.0 - 32.0);
            y = (float)(Math.random() * 64.0 + 70.0);
            z = (float)(Math.random() * 64.0 - 32.0);
            Vector3f v2 = new Vector3f(x, y, z);
            RopeLink link = new RopeLink(v1, v2);
            System.out.println("Adding rope from:" + v1 + " to:" + v2);
            this.ropeMesh.addRope(link);
        }
    }

    public void setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return;
        }
        super.setEnabled(b);
        if (b) {
            this.initialize();
        } else {
            this.terminate();
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected void controlUpdate(float tpf) {
        if (this.entities != null) {
            long start = System.nanoTime();
            boolean hasChanges = this.entities.applyChanges();
            long end = System.nanoTime();
            if (hasChanges) {
                if (end - start > 2000000L) {
                    System.out.println(((Object)((Object)this)).getClass().getSimpleName() + " apply changes time:" + (double)(end - start) / 1000000.0 + " ms");
                }
                this.processChanges();
            }
            while (!this.newLinks.isEmpty()) {
                BodyLink bl = this.newLinks.poll();
                if (this.links.put(bl.entity.getId(), bl) != null) continue;
                System.out.println("Adding new link:" + bl);
                System.out.println("----- geometry:" + bl.getGeometry());
                this.ropeMesh.addRope(bl.getGeometry());
            }
        }
        EntityChange c = null;
        while ((c = (EntityChange)this.changes.poll()) != null) {
            this.componentChange(c);
        }
        for (BodyLink l : this.links.values()) {
            l.update();
        }
        this.ropeMesh.update();
    }

    protected SimpleBody getSimpleBody(EntityId id) {
        if (id == null) {
            return null;
        }
        SimpleBody body = this.simpleBodies.get(id);
        if (body == null) {
            Entity e = this.entities.getEntity(id);
            body = new SimpleBody(e);
            this.simpleBodies.put(id, body);
        }
        return body;
    }

    private class LinkLoader
    implements EntityProcessor {
        Entity entity;

        public LinkLoader(Entity e) {
            this.entity = e;
        }

        protected void addLink(EntityId id, EntityData ed) {
            Entity linkEntity = ed.getEntity(id, PhysicalLink.class, Rope.class);
            PhysicalLink link = linkEntity.get(PhysicalLink.class);
            EntityId source = link.getSource();
            EntityId target = link.getTarget();
            SimpleBody b1 = RopeControl.this.getSimpleBody(source);
            SimpleBody b2 = RopeControl.this.getSimpleBody(target);
            BodyLink bl = new BodyLink(linkEntity, b1, b2);
            RopeControl.this.newLinks.add(bl);
        }

        public void run(EntityData ed) {
            FieldFilter<PhysicalLink> f = FieldFilter.create(PhysicalLink.class, "source", this.entity.getId());
            Set<EntityId> set = ed.findEntities(f, PhysicalLink.class, Rope.class);
            for (EntityId id : set) {
                this.addLink(id, ed);
            }
            f = FieldFilter.create(PhysicalLink.class, "target", this.entity.getId());
            set = ed.findEntities(f, PhysicalLink.class, Rope.class);
            for (EntityId id : set) {
                this.addLink(id, ed);
            }
        }
    }

    private class SimpleBody {
        private Entity entity;
        private Transform transform;

        public SimpleBody(Entity entity) {
            this.entity = entity;
            this.transform = new Transform();
            this.resetTransform();
        }

        public void resetTransform() {
            Position pos = this.entity.get(Position.class);
            Vector3f loc = pos.getLocation();
            this.transform.setTranslation(loc.x, loc.z, loc.y);
            this.transform.setRotation(pos.getRotation());
        }

        public EntityId getId() {
            return this.entity.getId();
        }

        public Vector3f localToWorld(Vector3f local) {
            System.out.println("localToWorld(" + local + ")");
            Vector3f result = new Vector3f(local.x, local.z, local.y);
            result = this.transform.transformVector(result, result);
            System.out.println("result:" + result);
            return result;
        }
    }

    private class BodyLink {
        Entity entity;
        PhysicalLink link;
        Rope ropeInfo;
        SimpleBody b1;
        SimpleBody b2;
        RopeLink ropeGeometry;
        boolean needsUpdate = true;

        public BodyLink(Entity entity, SimpleBody b1, SimpleBody b2) {
            this.entity = entity;
            this.link = entity.get(PhysicalLink.class);
            this.ropeInfo = entity.get(Rope.class);
            this.b1 = b1;
            this.b2 = b2;
        }

        public RopeLink getGeometry() {
            if (this.ropeGeometry == null) {
                this.ropeGeometry = new RopeLink(this.end1(), this.end2());
            }
            return this.ropeGeometry;
        }

        protected Vector3f flip(Vector3f v) {
            return new Vector3f(v.x, v.z, v.y);
        }

        protected Vector3f end1() {
            if (this.b1 == null) {
                return this.flip(this.link.getSourceOffset());
            }
            return this.b1.localToWorld(this.link.getSourceOffset());
        }

        protected Vector3f end2() {
            if (this.b2 == null) {
                return this.flip(this.link.getTargetOffset());
            }
            return this.b2.localToWorld(this.link.getTargetOffset());
        }

        public void entityChanged(Entity e) {
            if (this.b1 != null && this.b1.entity == e) {
                this.b1.resetTransform();
                this.needsUpdate = true;
            }
            if (this.b2 != null && this.b2.entity == e) {
                this.b2.resetTransform();
                this.needsUpdate = true;
            }
        }

        public void update() {
            if (!this.needsUpdate) {
                return;
            }
            this.needsUpdate = false;
            this.ropeGeometry.update(this.end1(), this.end2());
        }
    }
}

