/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mythruna.BlockType;
import mythruna.MaterialType;
import mythruna.db.building.BlockTransforms;
import mythruna.geom.AngleFactory;
import mythruna.geom.ConeFactory;
import mythruna.geom.CubeFactory;
import mythruna.geom.CylinderFactory;
import mythruna.geom.CylinderFactory2;
import mythruna.geom.FlameFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.GrassFactory;
import mythruna.geom.OuterCornerFactory;
import mythruna.geom.PartialCubeFactory;
import mythruna.geom.PineBranchFactory;
import mythruna.geom.PineTopFactory;
import mythruna.geom.StaticParticleFactory;
import mythruna.geom.ThatchCornerFactory;
import mythruna.geom.ThatchFactory;
import mythruna.geom.TreeLeafFactory;
import mythruna.geom.WedgeFactory;
import mythruna.geom.script.BlockScripts;

public class BlockTypeIndex {
    public static BlockType INVALID = new BlockType(Short.MAX_VALUE, "Invalid", MaterialType.EMPTY, true, 0, new CubeFactory(0));
    private static boolean initialized = false;
    private static int maxId = 0;
    public static BlockType[] types = new BlockType[80];
    private static Map<String, BlockGroup> groups = new LinkedHashMap<String, BlockGroup>();
    private static Map<MaterialType, BlockType> defaultTypes = new HashMap<MaterialType, BlockType>();

    public static int getMaxId() {
        return maxId;
    }

    public static Set<String> groupNames() {
        return groups.keySet();
    }

    public static BlockGroup getGroup(String name) {
        return groups.get(name);
    }

    public static Collection<BlockGroup> groups() {
        return groups.values();
    }

    public static BlockType getDefaultType(MaterialType type) {
        return defaultTypes.get(type);
    }

    protected static void expand(int size) {
        BlockType[] newTypes = new BlockType[size];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        types = newTypes;
        for (int i = 1; i < types.length; ++i) {
            if (types[i] != null) continue;
            BlockTypeIndex.types[i] = INVALID;
        }
    }

    public static void set(int index, BlockType type) {
        if (types.length <= index) {
            BlockTypeIndex.expand(index + 20);
        }
        if (types[index] != null && types[index] != INVALID && type != null) {
            throw new RuntimeException("Type already exists at index:" + index + "  type:" + types[index]);
        }
        BlockTypeIndex.types[index] = type;
        if (type != null && index > maxId) {
            maxId = index;
        }
        if (type != null) {
            for (BlockGroup bg : groups.values()) {
                bg.reset(index, type);
            }
            MaterialType mt = type.getMaterial();
            System.out.println("type:" + type + "  material:" + mt + "  already indexed:" + defaultTypes.containsKey(mt));
            if (!defaultTypes.containsKey(mt)) {
                defaultTypes.put(mt, type);
            }
        } else {
            BlockTypeIndex.types[index] = INVALID;
        }
    }

    public static BlockGroup setGroup(String name, List<BlockType> types) {
        BlockGroup bg = groups.get(name);
        if (bg == null) {
            bg = new BlockGroup(name, types);
            groups.put(name, bg);
            return bg;
        }
        bg.update(types);
        return bg;
    }

    public static BlockGroup addGroup(String name, BlockType ... types) {
        BlockGroup bg = new BlockGroup(name, types);
        if (groups.containsKey(name)) {
            throw new RuntimeException("Group already defined for name:" + name);
        }
        groups.put(name, bg);
        return bg;
    }

    public static BlockType addType(int id, String name, MaterialType material, int group, GeomFactory factory) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, factory);
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    public static BlockType addBlockType(int id, String name, MaterialType material, int group, int materialType) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, new CubeFactory(materialType));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addRampType(int id, String name, MaterialType material, int group, int solidXY, int solidZ, int materialType) {
        return BlockTypeIndex.addRampType(id, name, material, group, solidXY, solidZ, materialType, materialType, materialType);
    }

    protected static BlockType addRampType(int id, String name, MaterialType material, int group, int solidXY, int solidZ, int sideType, int topType, int bottomType) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, new WedgeFactory(solidXY, solidZ, sideType, topType, bottomType));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addRampType(int id, String name, MaterialType material, int group, int solidXY, int solidZ, int sideType, int topType, int bottomType, boolean yFlip) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, new WedgeFactory(solidXY, solidZ, sideType, topType, bottomType, yFlip));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockTypeW(int id, String name, MaterialType material, int group, float light, int ... materialTypes) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        float[] dirs = new float[]{light, light, light};
        BlockType bt = new BlockType(id, name, material, opaque, group, new CubeFactory(dirs, materialTypes[0], materialTypes[0], materialTypes));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int materialType, float yOffset) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        boolean clip = material != MaterialType.EMPTY;
        Vector3f min = Vector3f.ZERO;
        Vector3f max = CubeFactory.UNIT_CUBE.clone();
        max.z = 0.5f + yOffset;
        BlockType bt = new BlockType(id, name, material, opaque, group, min, max, new PartialCubeFactory(min, max, clip, false, null, materialType, materialType, materialType, new int[0]));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockTypeX(int id, String name, MaterialType material, int group, float light, float yOffset, int ... materialTypes) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        boolean clip = material != MaterialType.EMPTY;
        float[] dirs = new float[]{light, light, light};
        Vector3f min = Vector3f.ZERO;
        Vector3f max = CubeFactory.UNIT_CUBE.clone();
        max.z = 0.5f + yOffset;
        BlockType bt = new BlockType(id, name, material, opaque, group, min, max, new PartialCubeFactory(min, max, clip, false, dirs, materialTypes[0], materialTypes[0], materialTypes[0], materialTypes));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int materialType, float x1, float y1, float z1, float x2, float y2, float z2) {
        return BlockTypeIndex.addBlockType(id, name, material, group, materialType, materialType, materialType, x1, y1, z1, x2, y2, z2);
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int sideType, int topType, int bottomType, float x1, float y1, float z1, float x2, float y2, float z2) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        float x = x2 - x1;
        float y = y2 - y1;
        float z = z2 - z1;
        boolean clip = material != MaterialType.EMPTY;
        Vector3f min = new Vector3f(x1, y1, z1);
        Vector3f max = new Vector3f(x2, y2, z2);
        BlockType bt = new BlockType(id, name, material, opaque, group, min, max, new PartialCubeFactory(min, max, clip, false, null, sideType, topType, bottomType, new int[0]));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int materialType, float x1, float y1, float z1, float x2, float y2, float z2, float light) {
        boolean opaque = true;
        if (group > 0) {
            opaque = false;
        }
        float x = x2 - x1;
        float y = y2 - y1;
        float z = z2 - z1;
        boolean clip = material != MaterialType.EMPTY;
        float[] dirs = new float[]{light, light, light};
        Vector3f min = new Vector3f(x1, y1, z1);
        Vector3f max = new Vector3f(x2, y2, z2);
        BlockType bt = new BlockType(id, name, material, opaque, group, min, max, new PartialCubeFactory(min, max, clip, false, dirs, materialType, materialType, materialType, new int[0]));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int sideType, int topType, int bottomType) {
        boolean opaque = true;
        if (group != 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, new CubeFactory(sideType, topType, bottomType));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addBlockType(int id, String name, MaterialType material, int group, int topType, int bottomType, int ... sides) {
        boolean opaque = true;
        if (group != 0) {
            opaque = false;
        }
        BlockType bt = new BlockType(id, name, material, opaque, group, new CubeFactory(topType, bottomType, sides));
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    protected static BlockType addGrassBlockType(int id, String name, MaterialType material, int group, float height, int materialType) {
        GrassFactory factory = new GrassFactory(height, materialType);
        BlockType bt = new BlockType(id, name, material, false, group, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, height * 0.5f), factory);
        BlockTypeIndex.set(id, bt);
        return bt;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        BlockTypeIndex.addGroup("Dirt", BlockTypeIndex.addBlockType(1, "Dirt", MaterialType.DIRT, 0, 0), BlockTypeIndex.addBlockType(2, "Grass", MaterialType.GRASS, 0, 1, 2, 0), BlockTypeIndex.addRampType(48, "Dirt Slope", MaterialType.DIRT, 0, 0, 5, 0, 100, 0), BlockTypeIndex.addRampType(49, "Dirt Slope", MaterialType.DIRT, 0, 1, 5, 0, 100, 0), BlockTypeIndex.addRampType(50, "Dirt Slope", MaterialType.DIRT, 0, 2, 5, 0, 100, 0), BlockTypeIndex.addRampType(51, "Dirt Slope", MaterialType.DIRT, 0, 3, 5, 0, 100, 0));
        BlockTypeIndex.addGroup("Sand", BlockTypeIndex.addBlockType(3, "Sand", MaterialType.SAND, 0, 3));
        BlockTypeIndex.addGroup("Stone", new BlockType[0]);
        BlockTypeIndex.addGroup("Stone Slopes", new BlockType[0]);
        BlockTypeIndex.addGroup("Rock", BlockTypeIndex.addBlockType(6, "Rock", MaterialType.ROCK, 0, 6, 16, 6), BlockTypeIndex.addType(143, "Rock Angle", MaterialType.ROCK, 0, new AngleFactory(2, 0, 6, 106)), BlockTypeIndex.addType(140, "Rock Angle", MaterialType.ROCK, 0, new AngleFactory(0, 3, 6, 106)), BlockTypeIndex.addType(141, "Rock Angle", MaterialType.ROCK, 0, new AngleFactory(3, 1, 6, 106)), BlockTypeIndex.addType(142, "Rock Angle", MaterialType.ROCK, 0, new AngleFactory(1, 2, 6, 106)), BlockTypeIndex.addBlockType(5, "Rock Capped", MaterialType.ROCK, 0, 14, 15, 6), BlockTypeIndex.addType(147, "Rock Capped Angle", MaterialType.ROCK, 0, new AngleFactory(2, 0, 14, 15, 6, 106)), BlockTypeIndex.addType(144, "Rock Capped Angle", MaterialType.ROCK, 0, new AngleFactory(0, 3, 14, 15, 6, 106)), BlockTypeIndex.addType(145, "Rock Capped Angle", MaterialType.ROCK, 0, new AngleFactory(3, 1, 14, 15, 6, 106)), BlockTypeIndex.addType(146, "Rock Capped Angle", MaterialType.ROCK, 0, new AngleFactory(1, 2, 14, 15, 6, 106)));
        BlockTypeIndex.addGroup("Cobble", BlockTypeIndex.addBlockType(43, "Cobble", MaterialType.COBBLE, 0, 5), BlockTypeIndex.addBlockType(23, "Cobble Wall", MaterialType.COBBLE, 0, 5, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(24, "Cobble Wall", MaterialType.COBBLE, 0, 5, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(22, "Cobble Wall", MaterialType.COBBLE, 0, 5, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(21, "Cobble Wall", MaterialType.COBBLE, 0, 5, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addType(151, "Cobble Angle", MaterialType.COBBLE, 0, new AngleFactory(2, 0, 5, 105)), BlockTypeIndex.addType(148, "Cobble Angle", MaterialType.COBBLE, 0, new AngleFactory(0, 3, 5, 105)), BlockTypeIndex.addType(149, "Cobble Angle", MaterialType.COBBLE, 0, new AngleFactory(3, 1, 5, 105)), BlockTypeIndex.addType(150, "Cobble Angle", MaterialType.COBBLE, 0, new AngleFactory(1, 2, 5, 105)));
        BlockTypeIndex.addGroup("Mortared Rock", new BlockType[0]);
        BlockTypeIndex.addGroup("Water", BlockTypeIndex.addBlockTypeW(7, "Water", MaterialType.WATER, 1, 0.99f, 24, 24, 24, 24, 7, 24), BlockTypeIndex.addBlockTypeX(8, "Water Top", MaterialType.WATER, 1, 0.99f, 0.3f, 24, 24, 24, 24, 7, 24));
        BlockTypeIndex.addGroup("Trees", BlockTypeIndex.addType(161, "Trunk", MaterialType.WOOD, 0, new CylinderFactory(108, 113, 0.5f)), BlockTypeIndex.addType(168, "Trunk", MaterialType.WOOD, 0, new CylinderFactory(108, 113, 0.25f)), BlockTypeIndex.addType(170, "Branch", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 0)), BlockTypeIndex.addType(172, "Branch", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 1)), BlockTypeIndex.addType(169, "Branch", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 2)), BlockTypeIndex.addType(171, "Branch", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 3)), BlockTypeIndex.addType(308, "Log", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 0.501f, new Quaternion().fromAngles(1.5707964f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -0.4f))), BlockTypeIndex.addType(309, "Log", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.25f, 0.501f, new Quaternion().fromAngles(0.0f, 0.0f, 1.5707964f), new Vector3f(0.0f, 0.0f, -0.4f))), BlockTypeIndex.addType(310, "Log", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.55f, 0.501f, new Quaternion().fromAngles(1.5707964f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -0.15f))), BlockTypeIndex.addType(311, "Log", MaterialType.WOOD, 0, new CylinderFactory2(108, 113, 0.55f, 0.501f, new Quaternion().fromAngles(0.0f, 0.0f, 1.5707964f), new Vector3f(0.0f, 0.0f, -0.15f))), BlockTypeIndex.addType(160, "Leaves", MaterialType.LEAVES, 3, new TreeLeafFactory(25)), BlockTypeIndex.addType(173, "Leaves 2", MaterialType.LEAVES, 3, new TreeLeafFactory(26)), BlockTypeIndex.addType(238, "Spike", MaterialType.WOOD, 0, new ConeFactory(134, 113, 4, 1.2f, 0.5f)), BlockTypeIndex.addType(239, "Spike", MaterialType.WOOD, 0, new ConeFactory(134, 113, 5, 1.2f, 0.5f)), BlockTypeIndex.addType(240, "Spike", MaterialType.WOOD, 0, new ConeFactory(134, 113, 4, 1.1f, 0.25f)), BlockTypeIndex.addType(241, "Spike", MaterialType.WOOD, 0, new ConeFactory(134, 113, 5, 1.1f, 0.25f)), BlockTypeIndex.addType(223, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 0.0f)), BlockTypeIndex.addType(227, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 0.7853982f)), BlockTypeIndex.addType(224, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 1.5707964f)), BlockTypeIndex.addType(228, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 2.3561945f)), BlockTypeIndex.addType(225, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, (float)Math.PI)), BlockTypeIndex.addType(229, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 3.926991f)), BlockTypeIndex.addType(226, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 4.712389f)), BlockTypeIndex.addType(230, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 5.497787f)), BlockTypeIndex.addType(231, "Pine Sapling", MaterialType.LEAVES, 4, new PineTopFactory(108, 32)));
        BlockTypeIndex.addGroup("Flora", BlockTypeIndex.addGrassBlockType(82, "Tall Grass", MaterialType.FLORA, 0, 0.99f, 22), BlockTypeIndex.addGrassBlockType(83, "Medium Grass", MaterialType.FLORA, 0, 0.75f, 22), BlockTypeIndex.addGrassBlockType(84, "Short Grass", MaterialType.FLORA, 0, 0.5f, 22), BlockTypeIndex.addType(232, "Wild Flowers", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 2, 3, 3, 3).setHeight(0, 0.25f)), BlockTypeIndex.addType(233, "Flower 1", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 5, 0, 0).setHeight(0, 0.25f)), BlockTypeIndex.addType(234, "Flower 2", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 0, 5, 0).setHeight(0, 0.25f)), BlockTypeIndex.addType(235, "Flower 3", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 0, 0, 5).setHeight(0, 0.25f)), BlockTypeIndex.addType(236, "Brush Short", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.1f), new Vector3f(1.0f, 1.0f, 0.25f), types[84].getGeomFactory(), 8, 0, 0, 0)), BlockTypeIndex.addType(237, "Brush Tall", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.1f), new Vector3f(1.0f, 1.0f, 0.5f), types[82].getGeomFactory(), 10, 0, 0, 0)));
        BlockTypeIndex.addGroup("Old Vegetation", BlockTypeIndex.addBlockType(9, "Tree Trunk", MaterialType.WOOD, 0, 8, 13, 13), BlockTypeIndex.addBlockType(85, "Log", MaterialType.WOOD, 0, 8, 8, 13, 13, 23, 23), BlockTypeIndex.addBlockType(86, "Log", MaterialType.WOOD, 0, 23, 23, 23, 23, 13, 13), BlockTypeIndex.addRampType(90, "Trunk Slope", MaterialType.WOOD, 0, 0, 5, 23, 108, 8), BlockTypeIndex.addRampType(91, "Trunk Slope", MaterialType.WOOD, 0, 1, 5, 23, 108, 8), BlockTypeIndex.addRampType(92, "Trunk Slope", MaterialType.WOOD, 0, 2, 5, 23, 123, 23), BlockTypeIndex.addRampType(93, "Trunk Slope", MaterialType.WOOD, 0, 3, 5, 23, 123, 23), BlockTypeIndex.addRampType(94, "Trunk Slope Bottom", MaterialType.WOOD, 0, 0, 4, 23, 8, 108), BlockTypeIndex.addRampType(95, "Trunk Slope Bottom", MaterialType.WOOD, 0, 1, 4, 23, 8, 108), BlockTypeIndex.addRampType(96, "Trunk Slope Bottom", MaterialType.WOOD, 0, 2, 4, 23, 23, 123), BlockTypeIndex.addRampType(97, "Trunk Slope Bottom", MaterialType.WOOD, 0, 3, 4, 23, 23, 123), BlockTypeIndex.addBlockType(10, "Leaves", MaterialType.LEAVES, 2, 9), BlockTypeIndex.addRampType(102, "Leaves Slope", MaterialType.LEAVES, 2, 0, 5, 9, 109, 9), BlockTypeIndex.addRampType(103, "Leaves Slope", MaterialType.LEAVES, 2, 1, 5, 9, 109, 9), BlockTypeIndex.addRampType(104, "Leaves Slope", MaterialType.LEAVES, 2, 2, 5, 9, 109, 9), BlockTypeIndex.addRampType(105, "Leaves Slope", MaterialType.LEAVES, 2, 3, 5, 9, 109, 9), BlockTypeIndex.addRampType(98, "Leaves Slope Bottom", MaterialType.LEAVES, 2, 0, 4, 9, 9, 109), BlockTypeIndex.addRampType(99, "Leaves Slope Bottom", MaterialType.LEAVES, 2, 1, 4, 9, 9, 109), BlockTypeIndex.addRampType(100, "Leaves Slope Bottom", MaterialType.LEAVES, 2, 2, 4, 9, 9, 109), BlockTypeIndex.addRampType(101, "Leaves Slope Bottom", MaterialType.LEAVES, 2, 3, 4, 9, 9, 109), BlockTypeIndex.addType(155, "Leaves Angle", MaterialType.LEAVES, 2, new AngleFactory(2, 0, 9, 109)), BlockTypeIndex.addType(152, "Leaves Angle", MaterialType.LEAVES, 2, new AngleFactory(0, 3, 9, 109)), BlockTypeIndex.addType(153, "Leaves Angle", MaterialType.LEAVES, 2, new AngleFactory(3, 1, 9, 109)), BlockTypeIndex.addType(154, "Leaves Angle", MaterialType.LEAVES, 2, new AngleFactory(1, 2, 9, 109)));
        BlockTypeIndex.addGroup("Wood", BlockTypeIndex.addBlockType(32, "Wood Planks", MaterialType.WOOD, 0, 11, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(87, "Wood Planks-90", MaterialType.WOOD, 0, 21, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(31, "Wood Planks Top", MaterialType.WOOD, 0, 11, 0.0f, 0.0f, 0.7f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(88, "Wood Planks Top-90", MaterialType.WOOD, 0, 21, 0.0f, 0.0f, 0.7f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(12, "Wood Planks Bottom", MaterialType.WOOD, 0, 11, -0.3f), BlockTypeIndex.addBlockType(89, "Wood Planks Bottom-90", MaterialType.WOOD, 0, 21, -0.3f), BlockTypeIndex.addBlockType(54, "Wood Wall", MaterialType.WOOD, 0, 21, 0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f), BlockTypeIndex.addBlockType(55, "Wood Wall", MaterialType.WOOD, 0, 21, 0.0f, 0.7f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(53, "Wood Wall", MaterialType.WOOD, 0, 21, 0.7f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(52, "Wood Wall", MaterialType.WOOD, 0, 21, 0.0f, 0.0f, 0.0f, 0.3f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(18, "Wood Pillar", MaterialType.WOOD, 0, 21, 0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(17, "Wood Pillar", MaterialType.WOOD, 0, 21, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(19, "Wood Pillar", MaterialType.WOOD, 0, 21, 0.0f, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(20, "Wood Pillar", MaterialType.WOOD, 0, 21, 0.5f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(62, "Wood Beam Bottom", MaterialType.WOOD, 0, 11, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f), BlockTypeIndex.addBlockType(63, "Wood Beam Bottom", MaterialType.WOOD, 0, 11, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(61, "Wood Beam Bottom", MaterialType.WOOD, 0, 11, 21, 21, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(60, "Wood Beam Bottom", MaterialType.WOOD, 0, 11, 21, 21, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(66, "Wood Beam Top", MaterialType.WOOD, 0, 11, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(67, "Wood Beam Top", MaterialType.WOOD, 0, 11, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(65, "Wood Beam Top", MaterialType.WOOD, 0, 11, 21, 21, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(64, "Wood Beam Top", MaterialType.WOOD, 0, 11, 21, 21, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addType(162, "Wood Column", MaterialType.WOOD, 0, new CylinderFactory(128, 128, 0.5f)), BlockTypeIndex.addType(166, "Wood Post", MaterialType.WOOD, 0, new CylinderFactory(128, 128, 0.25f)), BlockTypeIndex.addType(306, "Spar", MaterialType.WOOD, 0, new CylinderFactory2(121, 121, 0.25f, 0.5f, new Quaternion().fromAngles(1.5707964f, 0.0f, 0.0f))), BlockTypeIndex.addType(307, "Spar", MaterialType.WOOD, 0, new CylinderFactory2(121, 121, 0.25f, 0.5f, new Quaternion().fromAngles(0.0f, 0.0f, 1.5707964f))));
        BlockTypeIndex.addGroup("Wood Slopes", new BlockType[0]);
        BlockTypeIndex.addGroup("W & D", BlockTypeIndex.addBlockType(11, "W&D Block", MaterialType.WADDLE, 0, 10), BlockTypeIndex.addBlockType(15, "W&D Wall", MaterialType.WADDLE, 0, 10, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(16, "W&D Wall", MaterialType.WADDLE, 0, 10, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(14, "W&D Wall", MaterialType.WADDLE, 0, 10, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(13, "W&D Wall", MaterialType.WADDLE, 0, 10, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f));
        BlockTypeIndex.addGroup("Shingles", BlockTypeIndex.addRampType(254, "Shingles", MaterialType.WOOD, 0, 0, 5, 11, 135, 21), BlockTypeIndex.addRampType(255, "Shingles", MaterialType.WOOD, 0, 1, 5, 11, 135, 21, true), BlockTypeIndex.addRampType(256, "Shingles", MaterialType.WOOD, 0, 2, 5, 11, 136, 11), BlockTypeIndex.addRampType(257, "Shingles", MaterialType.WOOD, 0, 3, 5, 11, 136, 11, true), BlockTypeIndex.addType(258, "Shingles Crnr", MaterialType.WOOD, 0, new OuterCornerFactory(2, 136, 135, 11, 21)), BlockTypeIndex.addType(259, "Shingles Crnr", MaterialType.WOOD, 0, new OuterCornerFactory(0, 136, 135, 11, 21)), BlockTypeIndex.addType(260, "Shingles Crnr", MaterialType.WOOD, 0, new OuterCornerFactory(3, 136, 135, 11, 21)), BlockTypeIndex.addType(261, "Shingles Crnr", MaterialType.WOOD, 0, new OuterCornerFactory(1, 136, 135, 11, 21)));
        BlockTypeIndex.addGroup("Thatch", BlockTypeIndex.addType(209, "Thatch", MaterialType.LEAVES, 0, new ThatchFactory(29, 30, 0)), BlockTypeIndex.addType(210, "Thatch", MaterialType.LEAVES, 0, new ThatchFactory(29, 30, 1)), BlockTypeIndex.addType(207, "Thatch", MaterialType.LEAVES, 0, new ThatchFactory(29, 30, 2)), BlockTypeIndex.addType(208, "Thatch", MaterialType.LEAVES, 0, new ThatchFactory(29, 30, 3)), BlockTypeIndex.addType(215, "Thatch Corner", MaterialType.LEAVES, 0, new ThatchCornerFactory(29, 30, 2)), BlockTypeIndex.addType(216, "Thatch Corner", MaterialType.LEAVES, 0, new ThatchCornerFactory(29, 30, 0)), BlockTypeIndex.addType(217, "Thatch Corner", MaterialType.LEAVES, 0, new ThatchCornerFactory(29, 30, 3)), BlockTypeIndex.addType(218, "Thatch Corner", MaterialType.LEAVES, 0, new ThatchCornerFactory(29, 30, 1)));
        BlockTypeIndex.addGroup("Glass", BlockTypeIndex.addBlockTypeW(30, "Glass", MaterialType.GLASS, 4, 0.99f, 18), BlockTypeIndex.addBlockType(58, "Glass Panel", MaterialType.GLASS, 0, 18, 0.0f, 0.2f, 0.0f, 1.0f, 0.3f, 1.0f, 0.99f), BlockTypeIndex.addBlockType(59, "Glass Panel", MaterialType.GLASS, 0, 18, 0.0f, 0.7f, 0.0f, 1.0f, 0.8f, 1.0f, 0.99f), BlockTypeIndex.addBlockType(57, "Glass Panel", MaterialType.GLASS, 0, 18, 0.7f, 0.0f, 0.0f, 0.8f, 1.0f, 1.0f, 0.99f), BlockTypeIndex.addBlockType(56, "Glass Panel", MaterialType.GLASS, 0, 18, 0.2f, 0.0f, 0.0f, 0.3f, 1.0f, 1.0f, 0.99f));
        BlockTypeIndex.addGroup("Black Marble", BlockTypeIndex.addBlockType(42, "Black Marble", MaterialType.MARBLE, 0, 20), BlockTypeIndex.addBlockType(110, "Blk Mrbl Slab Top", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(111, "Blk Mrbl Slab Bottom", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(114, "Blk Mrbl Wall", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(115, "Blk Mrbl Wall", MaterialType.MARBLE, 0, 20, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(113, "Blk Mrbl Wall", MaterialType.MARBLE, 0, 20, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(112, "Blk Mrbl Wall", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(117, "Blk Mrbl Pillar", MaterialType.MARBLE, 0, 20, 0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(116, "Blk Mrbl Pillar", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(118, "Blk Mrbl Pillar", MaterialType.MARBLE, 0, 20, 0.0f, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(119, "Blk Mrbl Pillar", MaterialType.MARBLE, 0, 20, 0.5f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(122, "Blk Mrbl Beam Bottom", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f), BlockTypeIndex.addBlockType(123, "Blk Mrbl Beam Bottom", MaterialType.MARBLE, 0, 20, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(121, "Blk Mrbl Beam Bottom", MaterialType.MARBLE, 0, 20, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(120, "Blk Mrbl Beam Bottom", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(126, "Blk Mrbl Beam Top", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(127, "Blk Mrbl Beam Top", MaterialType.MARBLE, 0, 20, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(125, "Blk Mrbl Beam Top", MaterialType.MARBLE, 0, 20, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(124, "Blk Mrbl Beam Top", MaterialType.MARBLE, 0, 20, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addType(159, "Blk Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(2, 0, 20, 120)), BlockTypeIndex.addType(156, "Blk Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(0, 3, 20, 120)), BlockTypeIndex.addType(157, "Blk Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(3, 1, 20, 120)), BlockTypeIndex.addType(158, "Blk Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(1, 2, 20, 120)), BlockTypeIndex.addType(163, "Blk Marble Column", MaterialType.MARBLE, 0, new CylinderFactory(120, 120, 0.5f)), BlockTypeIndex.addType(167, "Blk Marble Post", MaterialType.MARBLE, 0, new CylinderFactory(120, 120, 0.25f)), BlockTypeIndex.addType(246, "Blk Marble Cone", MaterialType.MARBLE, 0, new ConeFactory(120, 120, 4, 1.2f, 0.5f)), BlockTypeIndex.addType(247, "Blk Marble Cone", MaterialType.MARBLE, 0, new ConeFactory(120, 120, 5, 1.2f, 0.5f)), BlockTypeIndex.addType(248, "Blk Marble Spike", MaterialType.MARBLE, 0, new ConeFactory(120, 120, 4, 1.1f, 0.25f)), BlockTypeIndex.addType(249, "Blk Marble Spike", MaterialType.MARBLE, 0, new ConeFactory(120, 120, 5, 1.1f, 0.25f)));
        BlockTypeIndex.addGroup("Blackk Marble Slopes", BlockTypeIndex.addRampType(128, "Blk Mrbl Slope", MaterialType.MARBLE, 0, 0, 5, 20, 120, 20), BlockTypeIndex.addRampType(129, "Blk Mrbl Slope", MaterialType.MARBLE, 0, 1, 5, 20, 120, 20), BlockTypeIndex.addRampType(130, "Blk Mrbl Slope", MaterialType.MARBLE, 0, 2, 5, 20, 120, 20), BlockTypeIndex.addRampType(131, "Blk Mrbl Slope", MaterialType.MARBLE, 0, 3, 5, 20, 120, 20), BlockTypeIndex.addRampType(132, "Blk Mrbl Slope Bottom", MaterialType.MARBLE, 0, 0, 4, 20, 20, 120), BlockTypeIndex.addRampType(133, "Blk Mrbl Slope Bottom", MaterialType.MARBLE, 0, 1, 4, 20, 20, 120), BlockTypeIndex.addRampType(134, "Blk Mrbl Slope Bottom", MaterialType.MARBLE, 0, 2, 4, 20, 20, 120), BlockTypeIndex.addRampType(135, "Blk Mrbl Slope Bottom", MaterialType.MARBLE, 0, 3, 4, 20, 20, 120));
        BlockTypeIndex.addGroup("White Marble", BlockTypeIndex.addBlockType(174, "White Marble", MaterialType.MARBLE, 0, 27), BlockTypeIndex.addBlockType(175, "Wht Mrbl Slab Top", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(176, "Wht Mrbl Slab Bottom", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(179, "Wht Mrbl Wall", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(180, "Wht Mrbl Wall", MaterialType.MARBLE, 0, 27, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(178, "Wht Mrbl Wall", MaterialType.MARBLE, 0, 27, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(177, "Wht Mrbl Wall", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(182, "Wht Mrbl Pillar", MaterialType.MARBLE, 0, 27, 0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(181, "Wht Mrbl Pillar", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(183, "Wht Mrbl Pillar", MaterialType.MARBLE, 0, 27, 0.0f, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(184, "Wht Mrbl Pillar", MaterialType.MARBLE, 0, 27, 0.5f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(187, "Wht Mrbl Beam Bottom", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f), BlockTypeIndex.addBlockType(188, "Wht Mrbl Beam Bottom", MaterialType.MARBLE, 0, 27, 0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(186, "Wht Mrbl Beam Bottom", MaterialType.MARBLE, 0, 27, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(185, "Wht Mrbl Beam Bottom", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f), BlockTypeIndex.addBlockType(191, "Wht Mrbl Beam Top", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f), BlockTypeIndex.addBlockType(192, "Wht Mrbl Beam Top", MaterialType.MARBLE, 0, 27, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(190, "Wht Mrbl Beam Top", MaterialType.MARBLE, 0, 27, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f), BlockTypeIndex.addBlockType(189, "Wht Mrbl Beam Top", MaterialType.MARBLE, 0, 27, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f), BlockTypeIndex.addType(204, "Wht Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(2, 0, 27, 127)), BlockTypeIndex.addType(201, "Wht Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(0, 3, 27, 127)), BlockTypeIndex.addType(202, "Wht Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(3, 1, 27, 127)), BlockTypeIndex.addType(203, "Wht Mrbl Angle", MaterialType.MARBLE, 0, new AngleFactory(1, 2, 27, 127)), BlockTypeIndex.addType(205, "Wht Marble Column", MaterialType.MARBLE, 0, new CylinderFactory(127, 127, 0.5f)), BlockTypeIndex.addType(206, "Wht Marble Post", MaterialType.MARBLE, 0, new CylinderFactory(127, 127, 0.25f)), BlockTypeIndex.addType(250, "Wht Marble Cone", MaterialType.MARBLE, 0, new ConeFactory(127, 127, 4, 1.2f, 0.5f)), BlockTypeIndex.addType(251, "Wht Marble Cone", MaterialType.MARBLE, 0, new ConeFactory(127, 127, 5, 1.2f, 0.5f)), BlockTypeIndex.addType(252, "Wht Marble Spike", MaterialType.MARBLE, 0, new ConeFactory(127, 127, 4, 1.1f, 0.25f)), BlockTypeIndex.addType(253, "Wht Marble Spike", MaterialType.MARBLE, 0, new ConeFactory(127, 127, 5, 1.1f, 0.25f)));
        BlockTypeIndex.addGroup("White Marble Slopes", BlockTypeIndex.addRampType(193, "Wht Mrbl Slope", MaterialType.MARBLE, 0, 0, 5, 27, 127, 27), BlockTypeIndex.addRampType(194, "Wht Mrbl Slope", MaterialType.MARBLE, 0, 1, 5, 27, 127, 27), BlockTypeIndex.addRampType(195, "Wht Mrbl Slope", MaterialType.MARBLE, 0, 2, 5, 27, 127, 27), BlockTypeIndex.addRampType(196, "Wht Mrbl Slope", MaterialType.MARBLE, 0, 3, 5, 27, 127, 27), BlockTypeIndex.addRampType(197, "Wht Mrbl Slope Bottom", MaterialType.MARBLE, 0, 0, 4, 27, 27, 127), BlockTypeIndex.addRampType(198, "Wht Mrbl Slope Bottom", MaterialType.MARBLE, 0, 1, 4, 27, 27, 127), BlockTypeIndex.addRampType(199, "Wht Mrbl Slope Bottom", MaterialType.MARBLE, 0, 2, 4, 27, 27, 127), BlockTypeIndex.addRampType(200, "Wht Mrbl Slope Bottom", MaterialType.MARBLE, 0, 3, 4, 27, 27, 127));
        BlockTypeIndex.addGroup("Minerals", BlockTypeIndex.addBlockType(41, "Mineral Vein", MaterialType.STONE, 0, 19));
        BlockTypeIndex.addGroup("Lights", BlockTypeIndex.addType(29, "Magic Light", MaterialType.EMPTY, -1, new PartialCubeFactory(new Vector3f(0.4f, 0.4f, 0.4f), new Vector3f(0.6f, 0.6f, 0.6f), false, true, null, 12, 12, 12, new int[0])), BlockTypeIndex.addType(214, "Small Flame", MaterialType.FIRE, -1, new FlameFactory(31, 0.5f)), BlockTypeIndex.addType(211, "Large Flame", MaterialType.FIRE, -1, new FlameFactory(31)), BlockTypeIndex.addType(212, "Fire", MaterialType.FIRE, -1, new FlameFactory(31, 3)), BlockTypeIndex.addType(213, "Inferno", MaterialType.FIRE, -1, new FlameFactory(31, 5)));
        System.out.println("Running block scripts...");
        long start = System.nanoTime();
        BlockScripts.initialize();
        long end = System.nanoTime();
        System.out.println("Block scripts run in:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        BlockTransforms.initialize();
        end = System.nanoTime();
        System.out.println("Block transforms initialized in:" + (double)(end - start) / 1000000.0 + " ms");
        defaultTypes.put(MaterialType.STONE, types[4]);
        defaultTypes.put(MaterialType.WOOD, types[32]);
    }

    public static void setFloraQualityLow(boolean uglyGrass) {
        BlockTypeIndex.set(232, null);
        BlockTypeIndex.set(233, null);
        BlockTypeIndex.set(234, null);
        BlockTypeIndex.set(235, null);
        BlockTypeIndex.set(236, null);
        BlockTypeIndex.set(237, null);
        if (uglyGrass) {
            BlockTypeIndex.addBlockType(232, "Wild Flowers", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
            BlockTypeIndex.addBlockType(233, "Flower 1", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
            BlockTypeIndex.addBlockType(234, "Flower 2", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
            BlockTypeIndex.addBlockType(235, "Flower 3", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
            BlockTypeIndex.addBlockType(236, "Brush Short", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
            BlockTypeIndex.addBlockType(237, "Brush Tall", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.2f);
        } else {
            BlockTypeIndex.addType(232, "Wild Flowers", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 2, 3, 3, 3).setHeight(0, 0.25f));
            BlockTypeIndex.addType(233, "Flower 1", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 5, 0, 0).setHeight(0, 0.25f));
            BlockTypeIndex.addType(234, "Flower 2", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 0, 5, 0).setHeight(0, 0.25f));
            BlockTypeIndex.addType(235, "Flower 3", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.2f), new Vector3f(1.0f, 1.0f, 0.5f), types[84].getGeomFactory(), 3, 0, 0, 5).setHeight(0, 0.25f));
            BlockTypeIndex.addType(236, "Brush Short", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.1f), new Vector3f(1.0f, 1.0f, 0.25f), types[84].getGeomFactory(), 8, 0, 0, 0));
            BlockTypeIndex.addType(237, "Brush Tall", MaterialType.FLORA, -1, new StaticParticleFactory(33, new Vector3f(0.0f, 0.0f, 0.1f), new Vector3f(1.0f, 1.0f, 0.5f), types[82].getGeomFactory(), 10, 0, 0, 0));
        }
    }

    public static void setGrassQuality(int level) {
        BlockTypeIndex.set(82, null);
        BlockTypeIndex.set(83, null);
        BlockTypeIndex.set(84, null);
        if (level == 0) {
            BlockTypeIndex.addBlockType(82, "Tall Grass", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.3f);
            BlockTypeIndex.addBlockType(83, "Medium Grass", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.2f);
            BlockTypeIndex.addBlockType(84, "Short Grass", MaterialType.FLORA, 0, 2, 0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.1f);
        } else if (level == 1) {
            BlockTypeIndex.addGrassBlockType(82, "Tall Grass", MaterialType.FLORA, 0, 0.99f, 102);
            BlockTypeIndex.addGrassBlockType(83, "Medium Grass", MaterialType.FLORA, 0, 0.75f, 102);
            BlockTypeIndex.addGrassBlockType(84, "Short Grass", MaterialType.FLORA, 0, 0.5f, 102);
        } else if (level == 2) {
            BlockTypeIndex.addGrassBlockType(82, "Tall Grass", MaterialType.FLORA, 0, 0.99f, 500);
            BlockTypeIndex.addGrassBlockType(83, "Medium Grass", MaterialType.FLORA, 0, 0.75f, 500);
            BlockTypeIndex.addGrassBlockType(84, "Short Grass", MaterialType.FLORA, 0, 0.5f, 500);
        } else {
            BlockTypeIndex.addGrassBlockType(82, "Tall Grass", MaterialType.FLORA, 0, 0.99f, 22);
            BlockTypeIndex.addGrassBlockType(83, "Medium Grass", MaterialType.FLORA, 0, 0.75f, 22);
            BlockTypeIndex.addGrassBlockType(84, "Short Grass", MaterialType.FLORA, 0, 0.5f, 22);
        }
    }

    public static void setTreeQualityLow(boolean uglyTrees) {
        BlockTypeIndex.set(160, null);
        BlockTypeIndex.set(173, null);
        BlockTypeIndex.set(223, null);
        BlockTypeIndex.set(227, null);
        BlockTypeIndex.set(224, null);
        BlockTypeIndex.set(228, null);
        BlockTypeIndex.set(225, null);
        BlockTypeIndex.set(229, null);
        BlockTypeIndex.set(226, null);
        BlockTypeIndex.set(230, null);
        BlockTypeIndex.set(231, null);
        if (uglyTrees) {
            BlockTypeIndex.addBlockType(160, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(173, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(223, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(227, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(224, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(228, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(225, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(229, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(226, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(230, "Leaves", MaterialType.LEAVES, 2, 9);
            BlockTypeIndex.addBlockType(231, "Leaves", MaterialType.LEAVES, 2, 9);
        } else {
            BlockTypeIndex.addType(160, "Leaves", MaterialType.LEAVES, 3, new TreeLeafFactory(25));
            BlockTypeIndex.addType(173, "Leaves 2", MaterialType.LEAVES, 3, new TreeLeafFactory(26));
            BlockTypeIndex.addType(223, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 0.0f));
            BlockTypeIndex.addType(227, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 0.7853982f));
            BlockTypeIndex.addType(224, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 1.5707964f));
            BlockTypeIndex.addType(228, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 2.3561945f));
            BlockTypeIndex.addType(225, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, (float)Math.PI));
            BlockTypeIndex.addType(229, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 3.926991f));
            BlockTypeIndex.addType(226, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 4.712389f));
            BlockTypeIndex.addType(230, "Pine Branch", MaterialType.LEAVES, 4, new PineBranchFactory(32, 5.497787f));
            BlockTypeIndex.addType(231, "Pine Sapling", MaterialType.LEAVES, 4, new PineTopFactory(108, 32));
        }
    }

    public static class BlockGroup {
        private String name;
        private List<BlockType> types = new ArrayList<BlockType>();

        public BlockGroup(String name, BlockType ... types) {
            this.name = name;
            this.types.addAll(Arrays.asList(types));
        }

        public BlockGroup(String name, List<BlockType> types) {
            this.name = name;
            this.types.addAll(types);
        }

        public void reset(int id, BlockType type) {
            for (int i = 0; i < this.types.size(); ++i) {
                if (this.types.get(i).getId() != id) continue;
                this.types.set(i, type);
            }
        }

        public void update(List<BlockType> newTypes) {
            this.types.clear();
            this.types.addAll(newTypes);
        }

        public String getName() {
            return this.name;
        }

        public List<BlockType> getTypes() {
            return this.types;
        }

        public String toString() {
            return "BlockGrou[" + this.name + "]";
        }
    }
}

