/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.Vector3i;
import mythruna.mathd.Vec3d;

public class Coordinates {
    public static final int LEAF_SIZE = 32;
    public static final int NODE_SIZE = 1024;
    public static final int MAX_ELEVATION = 159;
    public static final int MAX_K = 5;

    public static Quaternion flipAxes(Quaternion q) {
        return q;
    }

    public static long worldToNodeId(int wx, int wy) {
        long x = (long)Coordinates.worldToNode(wx) & 0xFFFFFFFFL;
        long y = (long)Coordinates.worldToNode(wy) & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static long worldToNodeId(float wx, float wy) {
        long x = (long)Coordinates.worldToNode(Coordinates.worldToCell(wx)) & 0xFFFFFFFFL;
        long y = (long)Coordinates.worldToNode(Coordinates.worldToCell(wy)) & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static long leafToColumnId(int lx, int ly) {
        long x = (long)lx & 0xFFFFFFFFL;
        long y = (long)ly & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static long worldToColumnId(Vector3f world) {
        long x = (long)Coordinates.worldToLeaf(world.x) & 0xFFFFFFFFL;
        long y = (long)Coordinates.worldToLeaf(world.y) & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static long worldToColumnId(float wx, float wy) {
        long x = (long)Coordinates.worldToLeaf(wx) & 0xFFFFFFFFL;
        long y = (long)Coordinates.worldToLeaf(wy) & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static long worldToColumnId(double wx, double wy) {
        long x = (long)Coordinates.worldToLeaf(wx) & 0xFFFFFFFFL;
        long y = (long)Coordinates.worldToLeaf(wy) & 0xFFFFFFFFL;
        return x << 32 | y;
    }

    public static int worldToCell(float f) {
        return (int)Math.floor(f);
    }

    public static int worldToCell(double d) {
        return (int)Math.floor(d);
    }

    public static Vector3i worldToCell(Vec3d world) {
        return new Vector3i(Coordinates.worldToCell(world.x), Coordinates.worldToCell(world.y), Coordinates.worldToCell(world.z));
    }

    public static Vector3i worldToCell(Vector3f world) {
        return new Vector3i(Coordinates.worldToCell(world.x), Coordinates.worldToCell(world.y), Coordinates.worldToCell(world.z));
    }

    public static Vector3i physToCell(Vec3d world) {
        return new Vector3i(Coordinates.worldToCell(world.x), Coordinates.worldToCell(world.z), Coordinates.worldToCell(world.y));
    }

    public static int worldToLeaf(double d) {
        return Coordinates.worldToLeaf((float)d);
    }

    public static int worldToLeaf(float f) {
        return Coordinates.worldToLeaf(Coordinates.worldToCell(f));
    }

    public static int leafToWorld(int i) {
        return i * 32;
    }

    public static Vector3i leafToWorld(Vector3i leaf) {
        return new Vector3i(Coordinates.leafToWorld(leaf.x), Coordinates.leafToWorld(leaf.y), Coordinates.leafToWorld(leaf.z));
    }

    public static Vector3i worldToLeaf(Vector3f world) {
        return new Vector3i(Coordinates.worldToLeaf(world.x), Coordinates.worldToLeaf(world.y), Coordinates.worldToLeaf(world.z));
    }

    public static Vector3i worldToLeaf(Vector3i world) {
        return new Vector3i(Coordinates.worldToLeaf(world.x), Coordinates.worldToLeaf(world.y), Coordinates.worldToLeaf(world.z));
    }

    public static int worldToLeaf(int i) {
        if (i < 0) {
            i = (i + 1) / 32;
            return i - 1;
        }
        return i / 32;
    }

    public static int worldToNode(int i) {
        if (i < 0) {
            i = (i + 1) / 1024;
            return i - 1;
        }
        return i / 1024;
    }

    public static int nodeToWorld(int i) {
        return i * 1024;
    }

    public static void main(String ... args) {
        System.out.println("512, 512 = " + Coordinates.worldToColumnId(512.0f, 512.0f));
        System.out.println("-512, 512 = " + Coordinates.worldToColumnId(-512.0f, 512.0f));
        System.out.println("512, -512 = " + Coordinates.worldToColumnId(512.0f, -512.0f));
        System.out.println("-512, -512 = " + Coordinates.worldToColumnId(-512.0f, -512.0f));
        System.out.println("1024, 1024 = " + Coordinates.worldToColumnId(1024.0f, 1024.0f));
        System.out.println("-1024, 1024 = " + Coordinates.worldToColumnId(-1024.0f, 1024.0f));
        System.out.println("1024, -1024 = " + Coordinates.worldToColumnId(1024.0f, -1024.0f));
        System.out.println("-1024, -1024 = " + Coordinates.worldToColumnId(-1024.0f, -1024.0f));
        System.out.println("-1, -1 = " + Coordinates.worldToColumnId(-1.0f, -1.0f));
    }
}

