/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.math.Vector3f;
import mythruna.Coordinates;
import mythruna.PlayerPermissions;
import mythruna.Vector3i;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimPermissionChain;
import mythruna.es.ClaimPermissions;
import mythruna.es.ClaimType;
import mythruna.es.CreatedBy;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import mythruna.es.OwnedBy;
import mythruna.es.Position;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.log.Log;

public class DefaultPlayerPermissions
implements PlayerPermissions {
    static Log log = Log.getLog();
    private EntityId player;
    private EntityData ed;
    private Entity lastWorldZone = null;
    private EntitySet worldZones;
    private Entity lastZone = null;
    private ClaimPermissionChain lastChain = null;
    private EntityId lastParent = null;
    private EntitySet lastChildren = null;
    private EntitySet badges = null;

    public DefaultPlayerPermissions(EntityId player, EntityData ed) {
        this.player = player;
        this.ed = ed;
        this.worldZones = ed.getEntities(new FieldFilter<ClaimType>(ClaimType.class, "parent", null), ClaimType.class, ClaimArea.class, OwnedBy.class);
        this.badges = ed.getEntities(new FieldFilter<InContainer>(InContainer.class, "parentId", player), InContainer.class, ClaimPermissions.class);
    }

    @Override
    public void release() {
        this.worldZones.release();
        this.badges.release();
        if (this.lastChildren != null) {
            this.lastChildren.release();
        }
    }

    protected void setLastWorldZone(Entity z) {
        if (this.lastWorldZone == z) {
            return;
        }
        this.lastWorldZone = z;
    }

    @Override
    public ClaimPermissionChain getPermissions(Vector3i location) {
        Entity e = this.getContainingZone(location);
        if (e == null) {
            return new ClaimPermissionChain();
        }
        if (this.lastChain != null && this.lastChain.isClaim(e.getId())) {
            return this.lastChain;
        }
        this.badges.applyChanges();
        this.lastChain = this.lastWorldZone == e ? new ClaimPermissionChain(this.player, this.badges, e) : new ClaimPermissionChain(this.player, this.badges, e, this.lastWorldZone);
        return this.lastChain;
    }

    @Override
    public ClaimPermissionChain getPermissions(Entity claim) {
        if (this.lastChain != null && this.lastChain.isClaim(claim.getId())) {
            return this.lastChain;
        }
        this.badges.applyChanges();
        ClaimType type = claim.get(ClaimType.class);
        if (type.getParent() == null) {
            return new ClaimPermissionChain(this.player, this.badges, claim);
        }
        Entity parent = this.getWorldZone(type.getParent());
        if (parent == null) {
            return new ClaimPermissionChain();
        }
        return new ClaimPermissionChain(this.player, this.badges, claim, parent);
    }

    @Override
    public Entity getContainingProperty(Vector3i location) {
        return this.getContainingZone(location);
    }

    protected Entity findInArea(EntitySet zones, Vector3i location) {
        for (Entity e : zones) {
            ClaimArea area = e.get(ClaimArea.class);
            if (!area.contains(location)) continue;
            return e;
        }
        return null;
    }

    protected Entity getWorldZone(EntityId id) {
        this.worldZones.applyChanges();
        for (Entity e : this.worldZones) {
            if (!ObjectUtils.areEqual((Object)e.getId(), (Object)id)) continue;
            return e;
        }
        return null;
    }

    protected Entity getWorldZone(Vector3i location) {
        this.worldZones.applyChanges();
        ClaimArea area = null;
        if (this.lastWorldZone != null) {
            area = this.lastWorldZone.get(ClaimArea.class);
        }
        if (area != null && area.contains(location)) {
            return this.lastWorldZone;
        }
        for (Entity e : this.worldZones) {
            area = e.get(ClaimArea.class);
            if (!area.contains(location)) continue;
            this.setLastWorldZone(e);
            return e;
        }
        return null;
    }

    protected Entity getContainingZone(Vector3i location) {
        EntitySet children;
        Entity sub;
        ClaimType type;
        this.worldZones.applyChanges();
        ClaimArea area = null;
        if (this.lastZone != null) {
            area = this.lastZone.get(ClaimArea.class);
        }
        if (area != null && area.contains(location)) {
            return this.lastZone;
        }
        Entity w = this.getWorldZone(location);
        if (w != null && (type = w.get(ClaimType.class)).canBeParent() && (sub = this.findInArea(children = this.getChildren(w.getId()), location)) != null) {
            w = sub;
        }
        return w;
    }

    protected EntitySet getChildren(EntityId parent) {
        if (parent.equals(this.lastParent) && this.lastChildren != null) {
            this.lastChildren.applyChanges();
            return this.lastChildren;
        }
        this.lastParent = parent;
        if (this.lastChildren != null) {
            this.lastChildren.release();
        }
        this.lastChildren = this.ed.getEntities(new FieldFilter<ClaimType>(ClaimType.class, "parent", parent), ClaimType.class, ClaimArea.class, Position.class, OwnedBy.class);
        return this.lastChildren;
    }

    protected boolean checkBlockEdit(Entity zone, Vector3i block) {
        OwnedBy owner = this.ed.getComponent(zone.getId(), OwnedBy.class);
        ClaimType type = zone.get(ClaimType.class);
        if (type.getParent() != null) {
            OwnedBy parentOwner = this.ed.getComponent(type.getParent(), OwnedBy.class);
            if (this.player.equals(parentOwner.getOwnerId())) {
                return true;
            }
            if (!this.player.equals(owner.getOwnerId())) {
                return false;
            }
            ClaimArea area = zone.get(ClaimArea.class);
            return area.containsVertically(block.z);
        }
        return this.player.equals(owner.getOwnerId());
    }

    @Override
    public boolean canChangeBlock(Vector3i location) {
        ClaimPermissionChain chain = this.getPermissions(location);
        return chain.canDo(4);
    }

    @Override
    public boolean canChangeClaim(EntityId claim) {
        return this.isOwner(claim);
    }

    @Override
    public boolean canRemoveClaim(EntityId claim) {
        return this.isOwner(claim);
    }

    @Override
    public boolean canPlaceClaim(Vector3i location, ClaimArea area, EntityId claim) {
        Entity zone = this.getContainingZone(location);
        if (zone == null) {
            return true;
        }
        ClaimType type = this.ed.getComponent(claim, ClaimType.class);
        return zone.getId().equals(type.getParent());
    }

    @Override
    public boolean hasSubPlots(EntityId claim) {
        this.worldZones.applyChanges();
        if (!this.worldZones.containsId(claim)) {
            return false;
        }
        return !this.getChildren(claim).isEmpty();
    }

    public ClaimArea trim(EntityId parent, Vector3i block, ClaimArea area, EntityId child) {
        if (parent != null) {
            log.warn((Object)"trim() not supported on non-world level claims.");
            return null;
        }
        this.worldZones.applyChanges();
        EntitySet children = this.worldZones;
        for (Entity e : children) {
            if (e.getId().equals(child)) continue;
            ClaimArea a = e.get(ClaimArea.class);
            if (a.contains(block)) {
                return null;
            }
            if (!a.intersects(area)) continue;
            area.trimTo(a);
        }
        return area;
    }

    @Override
    public boolean intersectsSiblings(EntityId parent, ClaimArea area, EntityId child) {
        if (parent == null) {
            return this.intersects(this.worldZones, area, child);
        }
        EntitySet children = this.getChildren(parent);
        boolean intersects = this.intersects(children, area, child);
        return intersects;
    }

    protected boolean intersects(EntitySet siblings, ClaimArea area, EntityId self) {
        siblings.applyChanges();
        for (Entity e : siblings) {
            ClaimArea a;
            if (e.getId().equals(self) || !area.intersects(a = e.get(ClaimArea.class))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkWorld(ClaimArea area, ClaimType type, OwnedBy owner, EntityId claim) {
        if (!owner.getOwnerId().equals(this.player)) {
            return false;
        }
        return !this.intersects(this.worldZones, area, claim);
    }

    protected boolean checkSub(ClaimArea area, ClaimType type, OwnedBy owner, EntityId claim) {
        OwnedBy parentOwner = this.ed.getComponent(type.getParent(), OwnedBy.class);
        if (!parentOwner.getOwnerId().equals(this.player) && !owner.getOwnerId().equals(this.player)) {
            return false;
        }
        ClaimArea parentArea = this.ed.getComponent(type.getParent(), ClaimArea.class);
        if (!parentArea.contains(area)) {
            return false;
        }
        return !this.intersectsSiblings(type.getParent(), area, claim);
    }

    @Override
    public boolean canMoveClaim(ClaimArea area, EntityId claim) {
        ClaimType type = this.ed.getComponent(claim, ClaimType.class);
        OwnedBy owner = this.ed.getComponent(claim, OwnedBy.class);
        if (type.getParent() == null) {
            return this.checkWorld(area, type, owner, claim);
        }
        return this.checkSub(area, type, owner, claim);
    }

    @Override
    public boolean isOwner(EntityId claim) {
        ClaimType type = this.ed.getComponent(claim, ClaimType.class);
        OwnedBy owner = this.ed.getComponent(claim, OwnedBy.class);
        if (owner.getOwnerId().equals(this.player)) {
            return true;
        }
        if (type.getParent() == null) {
            return false;
        }
        OwnedBy parentOwner = this.ed.getComponent(type.getParent(), OwnedBy.class);
        return parentOwner.getOwnerId().equals(this.player);
    }

    public boolean isCreator(EntityId obj) {
        CreatedBy creator = this.ed.getComponent(obj, CreatedBy.class);
        return creator == null || creator.getCreatorId().equals(this.player);
    }

    @Override
    public boolean canMoveClaim(Position marker, EntityId claim) {
        return this.isOwner(claim);
    }

    @Override
    public boolean canAddObject(Vector3f location) {
        ClaimPermissionChain chain = this.getPermissions(Coordinates.worldToCell(location));
        return chain.canDo(16);
    }

    @Override
    public boolean canMoveObject(Vector3f location, EntityId obj) {
        ClaimPermissionChain chain = this.getPermissions(Coordinates.worldToCell(location));
        boolean creator = this.isCreator(obj);
        if (creator && chain.canDo(64)) {
            return true;
        }
        if (creator) {
            return false;
        }
        Position pos = this.ed.getComponent(obj, Position.class);
        chain = this.getPermissions(Coordinates.worldToCell(pos.getLocation()));
        return chain.canDo(64);
    }

    @Override
    public boolean canRemoveObject(Vector3f location, EntityId obj) {
        if (this.isCreator(obj)) {
            return true;
        }
        ClaimPermissionChain chain = this.getPermissions(Coordinates.worldToCell(location));
        return chain.canDo(32);
    }

    @Override
    public boolean canChangeObject(Vector3f location, EntityId obj) {
        if (this.isCreator(obj)) {
            return true;
        }
        ClaimPermissionChain chain = this.getPermissions(Coordinates.worldToCell(location));
        return chain.canDo(32);
    }
}

