/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Test {
    public static List<Double> testRaw = new ArrayList<Double>();
    public static List<Double> testConc = new CopyOnWriteArrayList<Double>();

    public static double testPlain() {
        int num = testRaw.size();
        double val = 0.0;
        for (int i = 0; i < num; ++i) {
            val += testRaw.get(i).doubleValue();
        }
        return val;
    }

    public static double testForEach() {
        double val = 0.0;
        for (Double d : testRaw) {
            val += d.doubleValue();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double testSync() {
        int num = testRaw.size();
        double val = 0.0;
        for (int i = 0; i < num; ++i) {
            List<Double> list = testRaw;
            synchronized (list) {
                val += testRaw.get(i).doubleValue();
                continue;
            }
        }
        return val;
    }

    public static double testConcurrent() {
        double val = 0.0;
        for (Double d : testConc) {
            val += d.doubleValue();
        }
        return val;
    }

    public static void accessTimingTests() {
        long plain = 0L;
        long forEach = 0L;
        long sync = 0L;
        long conc = 0L;
        int total = 4000;
        for (int i = 0; i < total; ++i) {
            System.out.println("Iteration: " + (i + 1) + " / " + total);
            long start = System.nanoTime();
            Test.testPlain();
            long end = System.nanoTime();
            plain += end - start;
            System.out.println("     indexed:" + (double)(end - start) / 1000000.0 + " ms");
            start = System.nanoTime();
            Test.testForEach();
            end = System.nanoTime();
            forEach += end - start;
            System.out.println("     forEach:" + (double)(end - start) / 1000000.0 + " ms");
            start = System.nanoTime();
            Test.testSync();
            end = System.nanoTime();
            sync += end - start;
            System.out.println("        sync:" + (double)(end - start) / 1000000.0 + " ms");
            start = System.nanoTime();
            Test.testConcurrent();
            end = System.nanoTime();
            conc += end - start;
            System.out.println("        conc:" + (double)(end - start) / 1000000.0 + " ms");
        }
        System.out.println("--------results-----------------------");
        System.out.println("  plain average:" + (double)(plain / (long)total) / 1000000.0 + " ms");
        System.out.println("forEach average:" + (double)(forEach / (long)total) / 1000000.0 + " ms");
        System.out.println("   sync average:" + (double)(sync / (long)total) / 1000000.0 + " ms");
        System.out.println("   conc average:" + (double)(conc / (long)total) / 1000000.0 + " ms");
    }

    public static void main(String ... args) throws Exception {
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            testRaw.add(Math.random());
        }
        testConc.addAll(testRaw);
    }
}

