/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import mythruna.db.BlueprintData;
import mythruna.db.BlueprintDatabase;
import mythruna.util.LruCache;

public class CachingBlueprintDatabase
implements BlueprintDatabase {
    private LruCache<Long, BlueprintData> blueprints = new LruCache("Blueprints", 100);
    private BlueprintDatabase bpDb;

    public CachingBlueprintDatabase(BlueprintDatabase bpDb) {
        this.bpDb = bpDb;
    }

    @Override
    public void close() {
        this.bpDb.close();
    }

    @Override
    public List<Long> getIds() {
        if (this.bpDb == null) {
            return Collections.emptyList();
        }
        try {
            return this.bpDb.getIds();
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving IDs", e);
        }
    }

    protected BlueprintData loadBlueprint(long id) throws IOException {
        BlueprintData result = this.bpDb.getBlueprint(id);
        if (result == null) {
            return result;
        }
        this.blueprints.put(id, result);
        return result;
    }

    protected BlueprintData newBlueprint(String name, int xSize, int ySize, int zSize, float scale, int[][][] cells) throws IOException {
        return this.bpDb.createBlueprint(name, xSize, ySize, zSize, scale, cells);
    }

    @Override
    public synchronized BlueprintData createBlueprint(String name, int xSize, int ySize, int zSize, float scale, int[][][] cells) {
        try {
            BlueprintData bp = this.newBlueprint(name, xSize, ySize, zSize, scale, cells);
            this.blueprints.put(bp.id, bp);
            return bp;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating blueprint", e);
        }
    }

    @Override
    public BlueprintData getBlueprint(long id, boolean load) {
        BlueprintData bp = this.blueprints.get(id);
        if (bp != null || !load) {
            return bp;
        }
        try {
            bp = this.loadBlueprint(id);
            return bp;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading blueprint for:" + id, e);
        }
    }

    @Override
    public BlueprintData getBlueprint(long id) {
        return this.getBlueprint(id, true);
    }
}

