/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Coordinates;
import mythruna.MaterialType;
import mythruna.db.LeafData;

public class ColumnInfo {
    public static final byte WATER = 1;
    public static final byte OCEAN = 2;
    public static final byte GROUND = 3;
    public static final byte TREES = 4;
    public static final byte HILLS = 5;
    public static final byte MOUNTAINS = 6;
    private static int seaLevel = 57;
    private static byte WATER_CANDIDATE = (byte)-1;
    private static byte LEAF_CANDIDATE = (byte)-2;
    private int x;
    private int y;
    private byte[][] elevations = new byte[32][32];
    private byte[][] types = new byte[32][32];
    private short[] counts = new short[7];
    private short maxHeight;
    private short minHeight;

    public ColumnInfo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public short getCount(byte type) {
        return this.counts[type];
    }

    public byte[][] getTypes() {
        return this.types;
    }

    public byte[][] getElevations() {
        return this.elevations;
    }

    public byte getElevation(int xWorld, int yWorld) {
        int i = xWorld - this.x;
        int j = yWorld - this.y;
        if (i < 0 || j < 0) {
            return 0;
        }
        if (i >= 32 || j >= 32) {
            return 0;
        }
        return this.elevations[i][j];
    }

    public byte getType(int xWorld, int yWorld) {
        int i = xWorld - this.x;
        int j = yWorld - this.y;
        if (i < 0 || j < 0) {
            return 0;
        }
        if (i >= 32 || j >= 32) {
            return 0;
        }
        return this.types[i][j];
    }

    public static byte valueToType(int v, int h, MaterialType type) {
        if (type == null || type == MaterialType.EMPTY || v == 0) {
            return 0;
        }
        if (type == MaterialType.WATER) {
            return 1;
        }
        if (type == MaterialType.COBBLE || type == MaterialType.ROCK || type == MaterialType.WOOD || type == MaterialType.WADDLE || type == MaterialType.GLASS || type == MaterialType.FLORA) {
            return 0;
        }
        return 3;
    }

    public void recalculate(LeafData[] leafs) {
        int i;
        int count = 0;
        int total = 1024;
        for (i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.types[i][j] = 0;
            }
        }
        for (i = 0; i < this.counts.length; ++i) {
            this.counts[i] = 0;
        }
        this.maxHeight = 0;
        this.minHeight = (short)160;
        byte leafType = (byte)MaterialType.LEAVES.getId();
        int oceanDepthMinimum = 6;
        for (int l = leafs.length - 1; l >= 0; --l) {
            LeafData leaf = leafs[l];
            if (leaf == null || leaf.isEmpty()) continue;
            int z = Coordinates.leafToWorld(l);
            for (int i2 = 0; i2 < 32; ++i2) {
                block5: for (int j = 0; j < 32; ++j) {
                    if (this.types[i2][j] != 0 && this.types[i2][j] != WATER_CANDIDATE && this.types[i2][j] != LEAF_CANDIDATE) continue;
                    for (int k = 31; k >= 0; --k) {
                        int v = leaf.getTypeUnchecked(i2, j, k);
                        BlockType type = BlockTypeIndex.types[v];
                        MaterialType matType = type != null ? type.getMaterial() : null;
                        byte material = type != null ? (byte)type.getMaterial().getId() : (byte)0;
                        int h = z + k;
                        byte t = ColumnInfo.valueToType(v, h, matType);
                        if (t == 0) continue;
                        if (t == 1 && l > 0 && k > 0) {
                            if (this.types[i2][j] == WATER_CANDIDATE) continue;
                            this.types[i2][j] = WATER_CANDIDATE;
                            this.elevations[i2][j] = (byte)h;
                            continue;
                        }
                        if (this.types[i2][j] == WATER_CANDIDATE) {
                            byte top = this.elevations[i2][j];
                            if (top - h > oceanDepthMinimum) {
                                this.counts[2] = (short)(this.counts[2] + 1);
                            } else {
                                this.counts[1] = (short)(this.counts[1] + 1);
                            }
                            this.types[i2][j] = (byte)(material | 0x80);
                        } else {
                            if (matType == MaterialType.LEAVES) {
                                if (this.types[i2][j] != 0) continue;
                                this.types[i2][j] = LEAF_CANDIDATE;
                                this.counts[4] = (short)(this.counts[4] + 1);
                                continue;
                            }
                            if (this.types[i2][j] == 0) {
                                this.types[i2][j] = material;
                                byte by = t;
                                this.counts[by] = (short)(this.counts[by] + 1);
                            } else if (this.types[i2][j] == LEAF_CANDIDATE) {
                                this.types[i2][j] = leafType;
                                this.counts[4] = (short)(this.counts[4] + 1);
                            }
                        }
                        ++count;
                        this.elevations[i2][j] = (byte)h;
                        if (h < this.minHeight) {
                            this.minHeight = (short)h;
                        }
                        if (h > this.maxHeight) {
                            this.maxHeight = (short)h;
                        }
                        if (count != 1024) continue block5;
                        return;
                    }
                }
            }
        }
    }

    public String toString() {
        return "ColumnInfo[" + this.x + "," + this.y + "]";
    }
}

