/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mythruna.db.ColumnFactory;
import mythruna.db.GeneratorColumnFactory;
import mythruna.db.LeafFileLocator;
import org.progeeks.map.ElevationGenerator;
import org.progeeks.map.FractalSumElevations;
import org.progeeks.map.RidgeFractalElevations;
import org.progeeks.map.SphericalElevations;

public class WorldUtils {
    public static final int ROCK = 4;
    public static final int SAND = 3;
    public static final int GRASS = 2;
    public static final int DIRT = 1;
    public static final int TALL_GRASS = 82;
    public static final int WILD_FLOWERS = 232;
    public static final int FLOWERS1 = 233;
    public static final int FLOWERS2 = 234;
    public static final int FLOWERS3 = 235;
    public static final int BRUSH1 = 236;
    public static final int BRUSH2 = 237;
    private static final int TRUNK = 161;
    private static final int TRUNK2 = 168;
    private static final int LEAVES = 160;
    private static final int LEAVES2 = 173;
    private static final int TOP = 231;
    private static final int BRANCH1 = 169;
    private static final int BRANCH2 = 170;
    private static final int BRANCH3 = 171;
    private static final int BRANCH4 = 172;
    private static final int PINE_BRANCH0 = 223;
    private static final int PINE_BRANCH45 = 227;
    private static final int PINE_BRANCH90 = 224;
    private static final int PINE_BRANCH135 = 228;
    private static final int PINE_BRANCH180 = 225;
    private static final int PINE_BRANCH225 = 229;
    private static final int PINE_BRANCH270 = 226;
    private static final int PINE_BRANCH315 = 230;
    private static final Integer[] BRANCHES = new Integer[]{223, 227, 224, 228, 225, 229, 226, 230, 169, 170, 171, 172};
    private static final Integer[] PINE = new Integer[]{223, 227, 224, 228, 225, 229, 226, 230, 231};
    private static final Integer[] FOLIAGE = new Integer[]{223, 227, 224, 228, 225, 229, 226, 230, 160, 173, 231};
    private static final Set<Integer> BRANCH_SET = new HashSet<Integer>(Arrays.asList(BRANCHES));
    private static final Set<Integer> PINE_SET = new HashSet<Integer>(Arrays.asList(PINE));
    private static final Set<Integer> FOLIAGE_SET = new HashSet<Integer>(Arrays.asList(FOLIAGE));

    public static boolean isFoliage(int type) {
        return FOLIAGE_SET.contains(type);
    }

    public static boolean isLeaves(int type) {
        return type == 160 || type == 173;
    }

    public static boolean isBranch(int type) {
        return BRANCH_SET.contains(type);
    }

    public static boolean isTrunk(int type) {
        return type == 161 || type == 168;
    }

    public static boolean isGrass(int type) {
        return type == 82 || type == 83 || type == 84;
    }

    public static boolean canGrow(int grow, int replace) {
        if (replace == 0 || WorldUtils.isGrass(replace)) {
            return true;
        }
        if (WorldUtils.isTrunk(grow) && (WorldUtils.isFoliage(replace) || WorldUtils.isBranch(replace))) {
            return true;
        }
        if (PINE_SET.contains(grow) && WorldUtils.isLeaves(replace)) {
            return true;
        }
        return WorldUtils.isBranch(grow) && WorldUtils.isLeaves(replace);
    }

    public static int[][] generateTypes(int[][] map, int size, int seaLevel) {
        int j;
        int i;
        int[][] result = new int[size][size];
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                int height = map[i][j];
                int total = 0;
                int count = 0;
                int hMax = Integer.MIN_VALUE;
                int hMin = Integer.MAX_VALUE;
                for (int x = i - 1; x <= i + 1; ++x) {
                    for (int y = j - 1; y <= j + 1; ++y) {
                        if (x < 0 || y < 0 || x >= size || y >= size || x == i && y == j) continue;
                        int val = map[x][y];
                        total += val;
                        ++count;
                        if (val > hMax) {
                            hMax = val;
                        }
                        if (val >= hMin) continue;
                        hMin = val;
                    }
                }
                int average = total / count;
                boolean rocky = false;
                if (Math.abs(height - average) >= 2 || hMax - hMin > 4) {
                    rocky = true;
                }
                result[i][j] = rocky ? 4 : (average <= seaLevel ? 3 : 2);
            }
        }
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                if (result[i][j] != 2) continue;
                int sandCount = 0;
                for (int x = i - 1; x <= i + 1; ++x) {
                    for (int y = j - 1; y <= j + 1; ++y) {
                        int val;
                        if (x < 0 || y < 0 || x >= size || y >= size || x == i && y == j || (val = result[x][y]) != 3) continue;
                        ++sandCount;
                    }
                }
                if (sandCount < 5) continue;
                result[i][j] = 3;
            }
        }
        for (i = 1; i < size - 1; ++i) {
            for (j = 1; j < size - 1; ++j) {
                if (result[i][j] != 2) continue;
                int base = map[i][j];
                boolean canPlant = true;
                int x = i - 1;
                int y = j;
                if (map[x][y] < base || map[x][y] == base && result[x][y] != 2 && result[x][y] != 82) {
                    canPlant = false;
                }
                if (map[x = i + 1][y = j] < base || map[x][y] == base && result[x][y] != 2 && result[x][y] != 82) {
                    canPlant = false;
                }
                if (map[x = i][y = j - 1] < base || map[x][y] == base && result[x][y] != 2 && result[x][y] != 82) {
                    canPlant = false;
                }
                if (map[x = i][y = j + 1] < base || map[x][y] == base && result[x][y] != 2 && result[x][y] != 82) {
                    canPlant = false;
                }
                if (!canPlant) continue;
                result[i][j] = 82;
            }
        }
        return result;
    }

    public static ColumnFactory createDefaultColumnFactory(LeafFileLocator locator, int seed) {
        int baseFrequency = 256;
        int sphereFrequency = baseFrequency * 4;
        int ridgeScale = 2500;
        if (GeneratorColumnFactory.wideExpanses) {
            ridgeScale = 3500;
            baseFrequency = 512;
            sphereFrequency = 4192;
        }
        SphericalElevations elev1 = new SphericalElevations();
        elev1.setSeed(seed);
        elev1.setFrequency(sphereFrequency);
        elev1.setElevationOffset(-1500);
        elev1.setElevationScale(5000);
        FractalSumElevations elev2 = new FractalSumElevations();
        elev2.setSeed(seed);
        elev2.setAdditive(true);
        elev2.setAffected(false);
        elev2.setFrequency(baseFrequency);
        elev2.setElevationOffset(-1500);
        elev2.setElevationScale(15000);
        elev2.setFrequencyIterations(8);
        elev2.setStartingFrequency(1.0);
        RidgeFractalElevations elev3 = new RidgeFractalElevations();
        elev3.setSeed(seed);
        elev3.setAdditive(true);
        elev3.setAffected(true);
        elev3.setFrequency(baseFrequency * 2);
        elev3.setElevationOffset(-ridgeScale);
        elev3.setElevationScale(ridgeScale * 2);
        elev3.setFractalIncrement(0.5);
        elev3.setGain(2.0);
        elev3.setLacunarity(3.02);
        elev3.setOctaves(5);
        elev3.setOffset(0.86);
        elev3.setThreshold(1.5);
        GeneratorColumnFactory columnFactory = new GeneratorColumnFactory(locator, elev1, elev2, elev3);
        FractalSumElevations rock1 = new FractalSumElevations();
        rock1.setSeed(seed);
        rock1.setFrequency(baseFrequency);
        rock1.setAdditive(true);
        rock1.setAffected(false);
        rock1.setElevationOffset(-1500);
        rock1.setElevationScale(15000);
        rock1.setFrequencyIterations(8);
        rock1.setStartingFrequency(1.0);
        RidgeFractalElevations rock2 = new RidgeFractalElevations();
        rock2.setSeed(seed);
        rock2.setFrequency(baseFrequency * 2);
        rock2.setAdditive(true);
        rock2.setAffected(true);
        rock2.setElevationOffset(-2500);
        rock2.setElevationScale(5000);
        rock2.setFractalIncrement(0.5);
        rock2.setGain(2.0);
        rock2.setLacunarity(3.02);
        rock2.setOctaves(5);
        rock2.setOffset(0.86);
        rock2.setThreshold(1.5);
        columnFactory.setStrata(4, null, 1, rock1, rock2);
        FractalSumElevations minerals2 = new FractalSumElevations();
        minerals2.setSeed(seed);
        minerals2.setAdditive(true);
        minerals2.setAffected(false);
        minerals2.setFrequency(baseFrequency);
        minerals2.setElevationOffset(-2000);
        minerals2.setElevationScale(8000);
        minerals2.setFrequencyIterations(8);
        minerals2.setStartingFrequency(1.0);
        RidgeFractalElevations minerals3 = new RidgeFractalElevations();
        minerals3.setSeed(seed);
        minerals3.setAdditive(true);
        minerals3.setAffected(false);
        minerals3.setFrequency(baseFrequency * 2);
        minerals3.setElevationOffset(-150);
        minerals3.setElevationScale(325);
        minerals3.setFractalIncrement(0.1);
        minerals3.setGain(2.0);
        minerals3.setLacunarity(3.02);
        minerals3.setOctaves(5);
        minerals3.setOffset(0.7);
        minerals3.setThreshold(3.0);
        columnFactory.setStrata(41, (ElevationGenerator)minerals2, -4, minerals2, minerals3);
        return columnFactory;
    }
}

