/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db.building;

import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.BoundaryShape;
import mythruna.MaterialType;
import mythruna.geom.AngleFactory;
import mythruna.geom.ConeFactory;
import mythruna.geom.CylinderFactory;
import mythruna.geom.CylinderFactory2;
import mythruna.geom.DefaultGeomFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.PineBranchFactory;
import mythruna.geom.ThatchCornerFactory;
import mythruna.geom.ThatchFactory;
import mythruna.geom.WedgeFactory;

public class BlockTransforms {
    public static int MIRROR_X = 1;
    public static int MIRROR_Y = 2;
    private static Map<String, BlockGroup> groups = new HashMap<String, BlockGroup>();
    private static Map<Integer, BlockGroup> transforms = new HashMap<Integer, BlockGroup>();

    public static void initialize() {
        BlockTransforms.addType("Wood Planks Block", BlockTypeIndex.types[32]);
        BlockTransforms.addType("Wood Planks-90 Block", BlockTypeIndex.types[87]);
        BlockTransforms.addType("Wood Planks Top", BlockTypeIndex.types[31]);
        BlockTransforms.addType("Wood Planks Top-90", BlockTypeIndex.types[88]);
        BlockTransforms.addType("Wood Planks Bottom", BlockTypeIndex.types[12]);
        BlockTransforms.addType("Wood Planks Bottom-90", BlockTypeIndex.types[89]);
        for (BlockType t : BlockTypeIndex.types) {
            BlockTransforms.addType(t);
        }
        for (Map.Entry<String, BlockGroup> e : groups.entrySet()) {
            e.getValue().compile();
        }
    }

    private static float epsilon(float f) {
        long i = Math.round(f * 10000.0f);
        f = (float)i / 10000.0f;
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String getGroup(BlockType type) {
        MaterialType mat = type.getMaterial();
        if (mat == MaterialType.FLORA) {
            return "Flora:" + type.getId();
        }
        if (mat == MaterialType.FIRE) {
            return "Fire:" + type.getId();
        }
        GeomFactory geom = type.getGeomFactory();
        String group = mat.getName();
        if (mat == MaterialType.MARBLE) {
            if (type.getName().startsWith("Blk") || type.getName().startsWith("Black")) {
                group = group + "-blk";
            } else {
                if (!type.getName().startsWith("Wht")) {
                    if (!type.getName().startsWith("White")) throw new RuntimeException("Unknown marble sub-type:" + type);
                }
                group = group + "-wht";
            }
        } else if (mat == MaterialType.ROCK) {
            if (type.getName().indexOf("Capped") >= 0) {
                group = group + "-capped";
            }
        } else if (mat == MaterialType.STONE) {
            if (type.getName().indexOf("Mineral") >= 0) {
                group = group + "-mineral";
            }
        } else if (mat == MaterialType.LEAVES) {
            if (type.getName().indexOf("2") >= 0) {
                group = group + "-dark";
            }
        } else if (mat == MaterialType.WOOD) {
            if (type.getName().indexOf("Trunk") >= 0) {
                group = group + "-trunk";
            } else if (type.getName().indexOf("Log") >= 0) {
                group = group + "-log";
            }
        }
        if (geom instanceof WedgeFactory) {
            WedgeFactory wf = (WedgeFactory)geom;
            return group + ":wedge" + (wf.isFacingUp() ? "" : "-up");
        }
        if (geom instanceof ThatchFactory) {
            ThatchFactory f = (ThatchFactory)geom;
            return group + ":thatch";
        }
        if (geom instanceof AngleFactory) {
            AngleFactory af = (AngleFactory)geom;
            return group + ":angle";
        }
        if (geom instanceof CylinderFactory) {
            CylinderFactory f = (CylinderFactory)geom;
            return group + ":cylinder-" + BlockTransforms.epsilon(f.getRadius());
        }
        if (geom instanceof CylinderFactory2) {
            CylinderFactory2 f = (CylinderFactory2)geom;
            group = f.getDir() < 0 ? group + ":cylinder-horz-" + BlockTransforms.epsilon(f.getRadius()) : group + ":cylinder2";
            Vector3f offset = f.getOffset();
            if (offset.x != 0.0f) return group + "[" + offset + "]";
            if (offset.y != 0.0f) return group + "[" + offset + "]";
            if (offset.z == 0.0f) return group;
            return group + "[" + offset + "]";
        }
        if (geom instanceof ConeFactory) {
            ConeFactory f = (ConeFactory)geom;
            group = group + ":cone-" + BlockTransforms.epsilon(f.getRadius()) + ":" + BlockTransforms.epsilon(f.getHeight());
            if (f.getDirection() != 4) return group;
            return group + "-up";
        }
        if (geom instanceof PineBranchFactory) {
            PineBranchFactory f = (PineBranchFactory)geom;
            group = group + ":pine-branch";
            if (!((double)Math.abs(BlockTransforms.epsilon(f.getYaw()) % BlockTransforms.epsilon(1.5707964f)) > 0.001)) return group;
            return group + "-45";
        }
        if (geom instanceof ThatchCornerFactory) {
            ThatchCornerFactory f = (ThatchCornerFactory)geom;
            return group + ":thatch-corner";
        }
        if (geom instanceof DefaultGeomFactory) {
            DefaultGeomFactory f = (DefaultGeomFactory)geom;
            group = f.getCollider() != null ? group + ":" + f.getCollider().getName() : group + ":default";
            Vector3f min = geom.getMin();
            Vector3f max = geom.getMax();
            float volume = (float)geom.getMassPortion();
            return group + "-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        }
        Vector3f min = geom.getMin();
        Vector3f max = geom.getMax();
        float volume = (float)geom.getMassPortion();
        if (min.x != 0.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        if (min.y != 0.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        if (min.z != 0.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        if (max.x != 1.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        if (max.y != 1.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        if (max.z != 1.0f) return group + ":box-" + BlockTransforms.epsilon(volume) + "[" + BlockTransforms.epsilon(min.z) + ":" + BlockTransforms.epsilon(max.z) + "]";
        return group + ":cube";
    }

    protected static void addType(BlockType t) {
        if (t == null || t.getId() >= Short.MAX_VALUE) {
            return;
        }
        if (transforms.containsKey(t.getId())) {
            return;
        }
        String group = BlockTransforms.getGroup(t);
        BlockTransforms.addType(group, t);
    }

    protected static void addType(String group, BlockType t) {
        BlockGroup g = BlockTransforms.getGroup(group);
        g.add(t);
        System.out.println("type:" + t + "  group:" + group);
        transforms.put(t.getId(), g);
    }

    protected static BlockGroup getGroup(String group) {
        BlockGroup g = groups.get(group);
        if (g == null) {
            g = new BlockGroup();
            groups.put(group, g);
        }
        return g;
    }

    public static BlockType rotate(BlockType type, int amount) {
        BlockGroup g = transforms.get(type.getId());
        if (g == null) {
            return type;
        }
        return g.rotate(type, amount);
    }

    public static BlockType mirror(BlockType type, int mirrorFlags) {
        BlockGroup g = transforms.get(type.getId());
        if (g == null) {
            return type;
        }
        if ((mirrorFlags & MIRROR_Y) != 0 && (g = transforms.get((type = g.mirror(type, 0)).getId())) == null) {
            return type;
        }
        if ((mirrorFlags & MIRROR_X) != 0) {
            type = g.mirror(type, 1);
        }
        return type;
    }

    protected static boolean isSymmetric(GeomFactory geom1, GeomFactory geom2) {
        if (geom1 instanceof WedgeFactory) {
            return true;
        }
        if (geom1 instanceof ThatchFactory) {
            return true;
        }
        if (geom1 instanceof CylinderFactory2) {
            return true;
        }
        if (geom1 instanceof PineBranchFactory) {
            PineBranchFactory f = (PineBranchFactory)geom1;
            return (double)Math.abs(BlockTransforms.epsilon(f.getYaw()) % BlockTransforms.epsilon(1.5707964f)) <= 0.001;
        }
        Vector3f min = geom1.getMin();
        Vector3f max = geom1.getMax();
        Vector3f center1 = min.add(max).mult(0.5f);
        center1.x = BlockTransforms.epsilon(center1.x);
        center1.y = BlockTransforms.epsilon(center1.y);
        min = geom2.getMin();
        max = geom2.getMax();
        Vector3f center2 = min.add(max).mult(0.5f);
        center2.x = BlockTransforms.epsilon(center2.x);
        center2.y = BlockTransforms.epsilon(center2.y);
        if (center1.x == 0.5f && center2.x == 0.5f) {
            BoundaryShape west;
            BoundaryShape east = geom1.getBoundaryShape(2);
            return east == (west = geom1.getBoundaryShape(3));
        }
        if (center1.y == 0.5f && center2.y == 0.5f) {
            BoundaryShape south;
            BoundaryShape north = geom1.getBoundaryShape(0);
            return north == (south = geom1.getBoundaryShape(1));
        }
        return false;
    }

    protected static BlockTransform[] createSingleSymmetricTransforms(List<BlockType> list) {
        System.out.println("createSingleSymmetricTransforms(" + list + ")");
        BlockType[] rotations = new BlockType[]{list.get(0), list.get(2), list.get(1), list.get(3)};
        BlockTransform[] array = new BlockTransform[4];
        System.out.println("Sorted to:" + Arrays.asList(rotations));
        array[0] = new SingleSymmetricTransform(1, rotations);
        rotations[0].transformIndex = 0;
        array[1] = new SingleSymmetricTransform(0, rotations);
        rotations[1].transformIndex = 1;
        array[2] = new SingleSymmetricTransform(1, rotations);
        rotations[2].transformIndex = 2;
        array[3] = new SingleSymmetricTransform(0, rotations);
        rotations[3].transformIndex = 3;
        return array;
    }

    protected static BlockTransform[] createRotationTransforms(List<BlockType> list) {
        Collections.sort(list, new SortOrderComparator());
        GeomFactory geom1 = list.get(0).getGeomFactory();
        GeomFactory geom2 = list.get(1).getGeomFactory();
        if (BlockTransforms.isSymmetric(geom1, geom2)) {
            return BlockTransforms.createSingleSymmetricTransforms(list);
        }
        BlockType[] rotations = new BlockType[]{list.get(3), list.get(2), list.get(1), list.get(0)};
        BlockTransform[] array = new BlockTransform[4];
        array[0] = new RotationTransform(rotations[0], rotations[3], rotations[1], rotations);
        rotations[0].transformIndex = 0;
        array[1] = new RotationTransform(rotations[1], rotations[2], rotations[0], rotations);
        rotations[1].transformIndex = 1;
        array[2] = new RotationTransform(rotations[2], rotations[1], rotations[3], rotations);
        rotations[2].transformIndex = 2;
        array[3] = new RotationTransform(rotations[3], rotations[0], rotations[2], rotations);
        rotations[3].transformIndex = 3;
        return array;
    }

    protected static class SortOrderComparator
    implements Comparator<BlockType> {
        protected SortOrderComparator() {
        }

        @Override
        public int compare(BlockType o1, BlockType o2) {
            int i1 = o1.getSortingIndex();
            int i2 = o2.getSortingIndex();
            return i1 - i2;
        }
    }

    protected static class BlockGroup {
        private List<BlockType> list = new ArrayList<BlockType>();
        private BlockTransform[] transforms;

        public BlockType mirror(BlockType type, int axis) {
            return this.transforms[type.transformIndex].mirror(axis, type);
        }

        public BlockType rotate(BlockType type, int amount) {
            return this.transforms[type.transformIndex].rotate(amount, type);
        }

        public void add(BlockType t) {
            this.list.add(t);
        }

        public void compile() {
            if (this.list.size() == 1) {
                BlockType type = this.list.get(0);
                type.transformIndex = 0;
                this.transforms = new BlockTransform[]{new IdentityTransform(type)};
                return;
            }
            if (this.list.size() == 2) {
                BlockType type1 = this.list.get(0);
                type1.transformIndex = 0;
                BlockType type2 = this.list.get(1);
                type2.transformIndex = 1;
                DualSymmetricTransform xform = new DualSymmetricTransform(type1, type2);
                this.transforms = new BlockTransform[]{xform, xform};
                return;
            }
            if (this.list.size() == 4) {
                this.transforms = BlockTransforms.createRotationTransforms(this.list);
                return;
            }
            throw new RuntimeException("Unable to form transformation for block types:" + this.list);
        }
    }

    protected static class RotationTransform
    implements BlockTransform {
        private BlockType root;
        private BlockType[] axes;
        private BlockType[] rotations;

        public RotationTransform(BlockType root, BlockType axis1, BlockType axis2, BlockType[] rotations) {
            this.root = root;
            this.axes = new BlockType[]{axis1, axis2};
            this.rotations = rotations;
        }

        @Override
        public BlockType mirror(int axis, BlockType start) {
            if (start != this.root) {
                throw new IllegalArgumentException("Using wrong transform to mirror:" + start);
            }
            return this.axes[axis];
        }

        @Override
        public BlockType rotate(int amount, BlockType start) {
            int base = start.transformIndex;
            base += amount;
            return this.rotations[base %= 4];
        }
    }

    protected static class SingleSymmetricTransform
    implements BlockTransform {
        private int symAxis;
        private BlockType[] rotations;

        public SingleSymmetricTransform(int symAxis, BlockType[] rotations) {
            this.symAxis = symAxis;
            this.rotations = rotations;
        }

        @Override
        public BlockType mirror(int axis, BlockType start) {
            if (axis == this.symAxis) {
                return start;
            }
            return this.rotate(2, start);
        }

        @Override
        public BlockType rotate(int amount, BlockType start) {
            int base = start.transformIndex;
            base += amount;
            return this.rotations[base %= 4];
        }
    }

    protected static class DualSymmetricTransform
    implements BlockTransform {
        private BlockType type1;
        private BlockType type2;

        public DualSymmetricTransform(BlockType type1, BlockType type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        @Override
        public BlockType mirror(int axis, BlockType start) {
            return start;
        }

        @Override
        public BlockType rotate(int amount, BlockType start) {
            if (amount % 2 == 0) {
                return start;
            }
            if (start == this.type1) {
                return this.type2;
            }
            return this.type1;
        }
    }

    protected static class IdentityTransform
    implements BlockTransform {
        private BlockType type;

        public IdentityTransform(BlockType type) {
            this.type = type;
        }

        @Override
        public BlockType mirror(int axis, BlockType start) {
            return this.type;
        }

        @Override
        public BlockType rotate(int amount, BlockType start) {
            return this.type;
        }
    }

    protected static interface BlockTransform {
        public BlockType mirror(int var1, BlockType var2);

        public BlockType rotate(int var1, BlockType var2);
    }
}

