/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.sql.SQLException;
import java.util.Set;
import mythruna.es.ComponentFilter;
import mythruna.es.EntityComponent;
import mythruna.es.EntityId;
import mythruna.es.sql.ComponentHandler;
import mythruna.es.sql.ComponentTable;
import mythruna.es.sql.SqlEntityData;
import mythruna.es.sql.SqlSession;

public class SqlComponentHandler<T extends EntityComponent>
implements ComponentHandler<T> {
    private SqlEntityData parent;
    private Class<T> type;
    private ComponentTable<T> table;

    public SqlComponentHandler(SqlEntityData parent, Class<T> type) {
        this.parent = parent;
        this.type = type;
        try {
            this.table = ComponentTable.create(parent.getSession(), type);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating table for component type:" + type, e);
        }
    }

    protected SqlSession getSession() throws SQLException {
        return this.parent.getSession();
    }

    @Override
    public void setComponent(EntityId entityId, T component) {
        try {
            this.table.setComponent(this.getSession(), entityId, component);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting component:" + component + " on entity:" + entityId, e);
        }
    }

    @Override
    public boolean removeComponent(EntityId entityId) {
        try {
            return this.table.removeComponent(this.getSession(), entityId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error removing component type:" + this.type + " from entity:" + entityId);
        }
    }

    @Override
    public T getComponent(EntityId entityId) {
        try {
            return (T)((EntityComponent)this.table.getComponent(this.getSession(), entityId));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component type:" + this.type + " for entity:" + entityId, e);
        }
    }

    @Override
    public Set<EntityId> getEntities() {
        try {
            return this.table.getEntityIds(this.getSession());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component entities for type:" + this.type);
        }
    }

    @Override
    public Set<EntityId> getEntities(ComponentFilter filter) {
        if (filter == null) {
            return this.getEntities();
        }
        try {
            return this.table.getEntityIds(this.getSession(), filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving component entities for type:" + this.type, e);
        }
    }

    @Override
    public EntityId findEntity(ComponentFilter filter) {
        if (filter == null) {
            return null;
        }
        try {
            return this.table.getEntityId(this.getSession(), filter);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving entity for filter:" + filter, e);
        }
    }
}

