/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.es.AbstractEntityData;
import mythruna.es.ComponentFilter;
import mythruna.es.EntityChange;
import mythruna.es.EntityComponent;
import mythruna.es.EntityId;
import mythruna.es.PersistentComponent;
import mythruna.es.StringIndex;
import mythruna.es.sql.ComponentHandler;
import mythruna.es.sql.EntityIdGenerator;
import mythruna.es.sql.MapComponentHandler;
import mythruna.es.sql.SqlComponentHandler;
import mythruna.es.sql.SqlSession;
import mythruna.es.sql.SqlStringIndex;

public class SqlEntityData
extends AbstractEntityData {
    private String dbPath;
    private ThreadLocal<SqlSession> cachedSession = new ThreadLocal();
    private Map<Class, ComponentHandler> handlers = new ConcurrentHashMap<Class, ComponentHandler>();
    private EntityIdGenerator idGenerator;
    private SqlStringIndex stringIndex;

    public SqlEntityData(File dbPath, long writeDelay) throws SQLException {
        this(dbPath.toURI().toString(), writeDelay);
    }

    public SqlEntityData(String dbPath, long writeDelay) throws SQLException {
        this.dbPath = dbPath;
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Driver not found for: org.hsqldb.jdbc.JDBCDriver", e);
        }
        SqlSession session = this.getSession();
        this.execute("SET FILES WRITE DELAY " + writeDelay + " MILLIS");
        this.execute("SET FILES DEFRAG 50");
        this.idGenerator = EntityIdGenerator.create(session);
        this.stringIndex = new SqlStringIndex(this, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String statement) throws SQLException {
        SqlSession session = this.getSession();
        Statement st = session.getConnection().createStatement();
        try {
            st.execute(statement);
        }
        finally {
            st.close();
        }
    }

    protected SqlSession getSession() throws SQLException {
        SqlSession session = this.cachedSession.get();
        if (session != null) {
            return session;
        }
        Connection conn = DriverManager.getConnection("jdbc:hsqldb:" + this.dbPath + "/entity_db", "SA", "");
        System.out.println("Created connection.  Autocommit:" + conn.getAutoCommit());
        session = new SqlSession(conn);
        this.cachedSession.set(session);
        return session;
    }

    @Override
    public StringIndex getStrings() {
        return this.stringIndex;
    }

    @Override
    public void close() {
        super.close();
        try {
            SqlSession session = this.getSession();
            this.execute("SHUTDOWN COMPACT");
            session.getConnection().close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database was not shutdown cleanly", e);
        }
    }

    @Override
    public EntityId createEntity() {
        try {
            return new EntityId(this.idGenerator.nextEntityId(this.getSession()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Database error", e);
        }
    }

    @Override
    public void removeEntity(EntityId entityId) {
        for (Class c : this.handlers.keySet()) {
            this.removeComponent(entityId, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentHandler getHandler(Class type) {
        ComponentHandler result = this.handlers.get(type);
        if (result == null) {
            SqlEntityData sqlEntityData = this;
            synchronized (sqlEntityData) {
                result = this.handlers.get(type);
                if (result == null) {
                    result = PersistentComponent.class.isAssignableFrom(type) ? new SqlComponentHandler(this, type) : new MapComponentHandler();
                    this.handlers.put(type, result);
                }
            }
        }
        return result;
    }

    @Override
    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        ComponentHandler handler = this.getHandler(type);
        return handler.getComponent(entityId);
    }

    @Override
    public void setComponent(EntityId entityId, EntityComponent component) {
        ComponentHandler handler = this.getHandler(component.getType());
        handler.setComponent(entityId, component);
        this.entityChange(new EntityChange(entityId, component));
    }

    @Override
    public boolean removeComponent(EntityId entityId, Class type) {
        ComponentHandler handler = this.getHandler(type);
        boolean result = handler.removeComponent(entityId);
        this.entityChange(new EntityChange(entityId, type));
        return result;
    }

    @Override
    protected EntityId findSingleEntity(ComponentFilter filter) {
        return this.getHandler(filter.getComponentType()).findEntity(filter);
    }

    @Override
    protected Set<EntityId> getEntityIds(Class type) {
        return this.getHandler(type).getEntities();
    }

    @Override
    protected Set<EntityId> getEntityIds(Class type, ComponentFilter filter) {
        return this.getHandler(type).getEntities(filter);
    }
}

