/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import mythruna.es.sql.SqlSession;
import org.progeeks.util.log.Log;

public class StringTable {
    static Log log = Log.getLog();
    private String tableName = "STRINGS";
    private boolean cached = true;
    private String insertSql;
    private String idForString;
    private String stringForId;

    protected StringTable(SqlSession session) throws SQLException {
        this.initialize(session);
        this.idForString = "select id from STRINGS where val=?";
        this.stringForId = "select val from STRINGS where id=?";
        this.insertSql = "insert into " + this.tableName + " (id,val) values (default,?)";
    }

    public static StringTable create(SqlSession session) throws SQLException {
        return new StringTable(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(SqlSession session) throws SQLException {
        DatabaseMetaData md = session.getConnection().getMetaData();
        System.out.println("Checking for table:" + this.tableName);
        ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);
        HashMap<String, Integer> dbFields = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                dbFields.put(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"));
            }
        }
        finally {
            rs.close();
        }
        System.out.println("dbFields for " + this.tableName + " :" + dbFields);
        if (!dbFields.isEmpty()) {
            this.checkStructure(dbFields);
            return;
        }
        StringBuilder sb = new StringBuilder("CREATE");
        if (this.cached) {
            sb.append(" CACHED");
        }
        sb.append(" TABLE");
        sb.append(" " + this.tableName + "\n");
        sb.append("(\n");
        sb.append("  id INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY");
        sb.append(",\n  val VARCHAR(50)");
        sb.append(",\n  CONSTRAINT val_key UNIQUE (val)");
        sb.append("\n)");
        System.out.println("Create statement:\n" + sb);
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(sb.toString());
        st.close();
        System.out.println("Result:" + i);
    }

    protected void checkStructure(Map<String, Integer> dbFields) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lookupString(SqlSession session, String s) throws SQLException {
        System.out.println("executing query:" + this.idForString);
        PreparedStatement st = session.prepareStatement(this.idForString);
        st.setObject(1, s);
        ResultSet rs = st.executeQuery();
        try {
            if (rs.next()) {
                Integer i = (Integer)rs.getObject(1);
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            rs.close();
        }
    }

    protected int addString(SqlSession session, String s) throws SQLException {
        System.out.println("Executing:" + this.insertSql);
        PreparedStatement st = session.prepareStatement(this.insertSql, 1);
        st.setObject(1, s);
        int count = st.executeUpdate();
        System.out.println("count:" + count);
        ResultSet keys = st.getGeneratedKeys();
        try {
            if (keys.next()) {
                Integer i = (Integer)keys.getObject(1);
                System.out.println("Generated key: " + i);
                int n = i;
                return n;
            }
            throw new RuntimeException("Failed to add string:" + s);
        }
        finally {
            keys.close();
        }
    }

    public int getStringId(SqlSession session, String s, boolean add) throws SQLException {
        System.out.println("db.getStringId(" + s + ", " + add + ")");
        int result = this.lookupString(session, s);
        System.out.println("Result from lookup:" + result);
        if (result == -1 && add) {
            result = this.addString(session, s);
            System.out.println("result from add:" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(SqlSession session, int id) throws SQLException {
        PreparedStatement st = session.prepareStatement(this.stringForId);
        st.setObject(1, id);
        ResultSet rs = st.executeQuery();
        try {
            if (rs.next()) {
                String s;
                String string = s = (String)rs.getObject(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            rs.close();
        }
    }
}

